/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskHandleDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskInfoDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskQryDo;
import com.tydic.dyc.umc.service.todo.UmcQueryToDoListService;
import com.tydic.fsc.bo.FscCandidatesBO;
import com.tydic.fsc.bo.FscFinishTaskInfoBO;
import com.tydic.fsc.bo.FscTaskInfoBO;
import com.tydic.fsc.busibase.external.api.notice.FscNoticeSendExtService;
import com.tydic.fsc.busibase.external.api.umc.DycUmcSendHaveDoneAtomService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcSendTodoAtomService;
import com.tydic.fsc.common.atom.api.FscComOrderApprovalAtomService;
import com.tydic.fsc.common.atom.bo.FscComOrderApprovalAtomReqBO;
import com.tydic.fsc.common.busi.api.FscTaskDealBusiService;
import com.tydic.fsc.common.busi.bo.FscTaskDealBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscTaskDealBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTodoConfigMapper;
import com.tydic.fsc.dao.UocApprovalObjMapper;
import com.tydic.fsc.dao.UocAuditOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTodoConfigPO;
import com.tydic.fsc.po.UocAuditOrderPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscTaskDealBusiServiceImpl
implements FscTaskDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscTaskDealBusiServiceImpl.class);
    @Autowired
    private ApproveRepository approveRepository;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderApprovalAtomService fscComOrderApprovalAtomService;
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;
    @Autowired
    private FscTodoConfigMapper fscTodoConfigMapper;
    @Autowired
    private FscUmcSendTodoAtomService fscUmcSendTodoAtomService;
    @Autowired
    private DycUmcSendHaveDoneAtomService dycUmcSendHaveDoneAtomService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private FscNoticeSendExtService fscNoticeSendExtService;
    @Autowired
    private UmcQueryToDoListService umcQueryToDoListService;
    public static final Integer TO_AUDIT = 1009;

    @Override
    public FscTaskDealBusiRspBO dealTask(FscTaskDealBusiReqBO reqBO) {
        List<FscTaskInfoBO> nextTaskInfos;
        ArrayList finishTaskInfoBos = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            reqBO.getCompleteTaskInfos().forEach(completeTaskBo -> {
                FlowTaskQryDo uocOrderTaskInstPo = new FlowTaskQryDo();
                uocOrderTaskInstPo.setObjId(reqBO.getOrderId());
                uocOrderTaskInstPo.setTaskInstId(completeTaskBo.getTaskId());
                uocOrderTaskInstPo.setCenterCode("FSC");
                List uocOrderTaskInsts = this.approveRepository.queryFlowTask(uocOrderTaskInstPo);
                if (CollectionUtils.isEmpty((Collection)uocOrderTaskInsts)) {
                    throw new FscBusinessException("0000", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u4e0d\u5b58\u5728");
                }
                if (FscConstants.PROC_TASK_FINISHED.FINISHED.equals(((FlowTaskInfoDo)uocOrderTaskInsts.get(0)).getFinishTag())) {
                    throw new FscBusinessException("198888", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5df2\u5b8c\u7ed3");
                }
                completeTaskBo.setBusiObjType(((FlowTaskInfoDo)uocOrderTaskInsts.get(0)).getObjType());
                completeTaskBo.setBusiObjId(((FlowTaskInfoDo)uocOrderTaskInsts.get(0)).getObjId());
                FlowTaskHandleDo flowTaskHandleDo = new FlowTaskHandleDo();
                flowTaskHandleDo.setTaskInstId(completeTaskBo.getTaskId());
                flowTaskHandleDo.setDealResult(completeTaskBo.getDealResult().toString());
                flowTaskHandleDo.setDealRemark(completeTaskBo.getDealRemark());
                flowTaskHandleDo.setDealUserId(reqBO.getUserId());
                flowTaskHandleDo.setDealUserName(reqBO.getName());
                flowTaskHandleDo.setCenterCode("FSC");
                flowTaskHandleDo.setLinkJudge(completeTaskBo.getAuditStepFinish().toString());
                flowTaskHandleDo.setStepCode(((FlowTaskInfoDo)uocOrderTaskInsts.get(0)).getStepCode());
                this.approveRepository.completeFlowTask(flowTaskHandleDo);
                FscFinishTaskInfoBO bo = (FscFinishTaskInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)completeTaskBo), FscFinishTaskInfoBO.class);
                bo.setDealOperId(reqBO.getUserId() + "");
                bo.setDealOperName(reqBO.getName());
                bo.setCenter("FSC");
                finishTaskInfoBos.add(bo);
                if (completeTaskBo.getFinish() != null && completeTaskBo.getFinish().booleanValue() && completeTaskBo.getBusiObjType().equals(FscConstants.OBJ_TYPE.APPROVE)) {
                    FscComOrderApprovalAtomReqBO fscComOrderApprovalAtomReqBO = (FscComOrderApprovalAtomReqBO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscComOrderApprovalAtomReqBO.class)));
                    fscComOrderApprovalAtomReqBO.setAuditResult(completeTaskBo.getDealResult());
                    fscComOrderApprovalAtomReqBO.setAuditAdvice(completeTaskBo.getDealRemark());
                    this.fscComOrderApprovalAtomService.dealOrderApproval(fscComOrderApprovalAtomReqBO);
                    UocAuditOrderPo set = new UocAuditOrderPo();
                    if (FscConstants.AuditResultFlagKey.PASS.equals(completeTaskBo.getDealResult())) {
                        set.setAuditOrderStatus(FscConstants.AuditStatus.AUDIT_PASS.toString());
                    } else {
                        set.setAuditOrderStatus(FscConstants.AuditStatus.AUDIT_REJECT.toString());
                    }
                    set.setUpdateTime(new Date());
                    set.setUpdateOperId(reqBO.getUserId() + "");
                    UocAuditOrderPo where = new UocAuditOrderPo();
                    where.setOrderId(reqBO.getOrderId());
                    where.setAuditOrderId(completeTaskBo.getBusiObjId());
                    this.uocAuditOrderMapper.updateBy(set, where);
                }
            });
        }
        if (!CollectionUtils.isEmpty(nextTaskInfos = reqBO.getNextTaskInfos()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getPreTaskId()) && ObjectUtil.isEmpty(reqBO.getRecallTaskInfos())) {
            ArrayList<FlowTaskInfoDo> flowTaskInfoDoList = new ArrayList<FlowTaskInfoDo>();
            for (FscTaskInfoBO nextTaskInfo : nextTaskInfos) {
                FlowTaskInfoDo flowTaskInfoDo = new FlowTaskInfoDo();
                flowTaskInfoDo.setCenterCode("FSC");
                flowTaskInfoDo.setCenterCodeStr("\u7ed3\u7b97");
                flowTaskInfoDo.setTaskInstId(nextTaskInfo.getTaskId());
                flowTaskInfoDo.setProcInstId(nextTaskInfo.getProcInstId());
                flowTaskInfoDo.setProcName(nextTaskInfo.getProcDefName());
                flowTaskInfoDo.setProcDefKey(nextTaskInfo.getProcDefKey());
                if (FscConstants.OBJ_TYPE.APPROVE.equals(nextTaskInfo.getBusiObjType())) {
                    flowTaskInfoDo.setProcType("APPROVE");
                    flowTaskInfoDo.setProcTypeStr("\u5ba1\u6279\u6d41");
                } else {
                    flowTaskInfoDo.setProcType("BUSINESS");
                    flowTaskInfoDo.setProcTypeStr("\u4e1a\u52a1\u6d41");
                }
                flowTaskInfoDo.setObjId(nextTaskInfo.getBusiObjId());
                flowTaskInfoDo.setObjType(nextTaskInfo.getBusiObjType());
                flowTaskInfoDo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
                if (flowTaskInfoDo.getTaskSignTag() == null) {
                    flowTaskInfoDo.setTaskSignTag(Integer.valueOf(0));
                }
                flowTaskInfoDo.setStepCode(nextTaskInfo.getStepId());
                if (ObjectUtil.isNotEmpty((Object)nextTaskInfo.getCandidates())) {
                    List candidates = nextTaskInfo.getCandidates();
                    FscCandidatesBO uocCandidatesBO = (FscCandidatesBO)candidates.get(0);
                    flowTaskInfoDo.setTaskUserId(Long.valueOf(uocCandidatesBO.getCandidateId()));
                    flowTaskInfoDo.setTaskUserName(uocCandidatesBO.getCandidateName());
                }
                flowTaskInfoDoList.add(flowTaskInfoDo);
            }
            this.approveRepository.addFlowTask(flowTaskInfoDoList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPreTaskId())) {
            FscTaskInfoBO nextTaskInfo = reqBO.getNextTaskInfos().get(0);
            this.dealPreOrRecallTask(nextTaskInfo, reqBO.getPreTaskId());
        }
        if (reqBO.getUpdateTaskCandidate() != null && StringUtils.hasText((String)reqBO.getUpdateTaskCandidate().getTaskId())) {
            FscCandidatesBO uocCandidatesBO = (FscCandidatesBO)reqBO.getUpdateTaskCandidate().getCandidates().get(0);
            FlowTaskInfoDo flowTaskInfoDo = new FlowTaskInfoDo();
            flowTaskInfoDo.setTaskInstId(reqBO.getUpdateTaskCandidate().getTaskId());
            flowTaskInfoDo.setTaskUserId(Long.valueOf(uocCandidatesBO.getCandidateId()));
            flowTaskInfoDo.setTaskUserName(uocCandidatesBO.getCandidateName());
            this.approveRepository.transfFlowTask(flowTaskInfoDo);
        }
        if (CollectionUtil.isNotEmpty(reqBO.getRecallTaskInfos())) {
            this.dealRecall(reqBO);
        }
        FscTaskDealBusiRspBO rspBO = new FscTaskDealBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void dealPreOrRecallTask(FscTaskInfoBO nextTaskInfo, String preTaskId) {
        FlowTaskHandleDo flowTaskHandleDo = new FlowTaskHandleDo();
        flowTaskHandleDo.setCenterCode("FSC");
        flowTaskHandleDo.setOldTaskInstId(preTaskId);
        flowTaskHandleDo.setTaskInstId(nextTaskInfo.getTaskId());
        flowTaskHandleDo.setProcInstId(nextTaskInfo.getProcInstId());
        flowTaskHandleDo.setProcName(nextTaskInfo.getProcDefName());
        flowTaskHandleDo.setProcDefKey(nextTaskInfo.getProcDefKey());
        if (FscConstants.OBJ_TYPE.APPROVE.equals(nextTaskInfo.getBusiObjType())) {
            flowTaskHandleDo.setProcType("BUSINESS");
        } else {
            flowTaskHandleDo.setProcType("APPROVE");
        }
        flowTaskHandleDo.setObjId(nextTaskInfo.getBusiObjId());
        flowTaskHandleDo.setObjType(nextTaskInfo.getBusiObjType());
        flowTaskHandleDo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
        if (flowTaskHandleDo.getTaskSignTag() == null) {
            flowTaskHandleDo.setTaskSignTag(Integer.valueOf(0));
        }
        flowTaskHandleDo.setStepCode(nextTaskInfo.getStepId());
        List candidates = nextTaskInfo.getCandidates();
        FscCandidatesBO uocCandidatesBO = (FscCandidatesBO)candidates.get(0);
        flowTaskHandleDo.setTaskUserId(Long.valueOf(uocCandidatesBO.getCandidateId()));
        flowTaskHandleDo.setTaskUserName(uocCandidatesBO.getCandidateName());
        this.approveRepository.beforeJoinFlowTask(flowTaskHandleDo);
    }

    private void dealRecall(FscTaskDealBusiReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getOrderId())) {
            log.error("\u5904\u7406\u64a4\u56de\u4efb\u52a1\u5931\u8d25, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e3a\u7a7a");
            return;
        }
        List<FscTaskInfoBO> recallTaskInfos = reqBO.getRecallTaskInfos();
        FscTaskInfoBO nextTaskInfo = reqBO.getNextTaskInfos().get(0);
        this.dealPreOrRecallTask(nextTaskInfo, recallTaskInfos.get(0).getTaskId());
    }

    private FscTodoConfigPO getFscTodoInfoByFscOrder(FscOrderPO fscOrderPO) {
        FscTodoConfigPO fscTodoConfigPO = new FscTodoConfigPO();
        fscTodoConfigPO.setIsApproval(Integer.valueOf(1));
        if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
            fscTodoConfigPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        } else if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            fscTodoConfigPO.setOrderFlow(FscConstants.OrderFlow.PL_SERVICE_FEE);
        } else if (!FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow()) && !FscConstants.OrderFlow.PAY_BACK.equals(fscOrderPO.getOrderFlow())) {
            fscTodoConfigPO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        }
        fscTodoConfigPO.setOrderState(TO_AUDIT);
        return this.fscTodoConfigMapper.getModelBy(fscTodoConfigPO);
    }

    private FscOrderPO getFscOrderPO(Long fscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        return fscOrderPO;
    }
}

