/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.pay.busi.api.FscPayInfoBackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiRspBO;
import com.tydic.fsc.po.FscPayLogPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayInfoBackBusiServiceImpl
implements FscPayInfoBackBusiService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscPayInfoBackBusiRspBO dealPayInfoBack(FscPayInfoBackBusiReqBO reqBO) {
        this.savePayInfoLog(reqBO);
        FscPayInfoBackBusiRspBO rspBO = new FscPayInfoBackBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void savePayInfoLog(FscPayInfoBackBusiReqBO reqBO) {
        FscPayLogPO fscPayLogPO = (FscPayLogPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscPayLogPO.class);
        fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayLogPO.setUserName(reqBO.getPayerName());
        fscPayLogPO.setIsCredit(Convert.toInt((Object)reqBO.getPayResult()));
        fscPayLogPO.setBusiOrderNo(reqBO.getBusiOrderNo());
        if (ObjectUtil.isNull((Object)fscPayLogPO.getBusiOrderId())) {
            fscPayLogPO.setBusiOrderId(reqBO.getBusiOrderId());
        }
        fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.PERIOD_PAY);
        fscPayLogPO.setBusiOrderType(FscConstants.CreditOrderType.FSC_ORDER);
        fscPayLogPO.setCreateTime(new Date());
        this.fscPayLogMapper.insert(fscPayLogPO);
    }
}

