/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateInspPayStatusReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayInfoBackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayInfoBackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayInfoBackAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayInfoBackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayInfoBackAbilityService"})
public class FscPayInfoBackAbilityServiceImpl
implements FscPayInfoBackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayInfoBackAbilityServiceImpl.class);
    @Autowired
    private FscPayInfoBackBusiService fscPayInfoBackBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource(name="fscInspOrderPayStatusSyncServiceProvider")
    private ProxyMessageProducer fscInspOrderPayStatusSyncServiceProvider;
    @Value(value="${FSC_INSP_ORDER_PAY_STATUS_SYNC_ORDER_TAG:*}")
    private String fscInspOrderPayStatusSyncOrderTag;
    @Value(value="${FSC_INSP_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC:FSC_INSP_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC}")
    private String fscInspOrderPayStatusSyncOrderTopic;

    @PostMapping(value={"dealPayInfoBack"})
    public FscPayInfoBackAbilityRspBO dealPayInfoBack(@RequestBody FscPayInfoBackAbilityReqBO reqBO) {
        this.check(reqBO);
        FscOrderPO fscOrder = this.getFscOrder(reqBO);
        if (ObjectUtil.isNull((Object)fscOrder)) {
            throw new FscBusinessException("191037", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355\u4fe1\u606f");
        }
        FscPayInfoBackBusiReqBO fscPayInfoBackBusiReqBO = (FscPayInfoBackBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscPayInfoBackBusiReqBO.class));
        fscPayInfoBackBusiReqBO.setBusiOrderNo(fscOrder.getOrderNo());
        FscPayInfoBackBusiRspBO fscPayInfoBackBusiRspBO = this.fscPayInfoBackBusiService.dealPayInfoBack(fscPayInfoBackBusiReqBO);
        if (!"0000".equals(fscPayInfoBackBusiRspBO.getRespCode())) {
            throw new FscBusinessException(fscPayInfoBackBusiRspBO.getRespCode(), fscPayInfoBackBusiRspBO.getRespDesc());
        }
        this.updatePayState(fscOrder, reqBO);
        return (FscPayInfoBackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscPayInfoBackBusiRspBO)), FscPayInfoBackAbilityRspBO.class);
    }

    private void check(FscPayInfoBackAbilityReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getBusiOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[busiOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updatePayState(FscOrderPO fscOrder, FscPayInfoBackAbilityReqBO reqBO) {
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setBusiOrderId(fscOrder.getFscOrderId());
        fscPayLogPO = this.fscPayLogMapper.getSumBusiAmount(fscPayLogPO);
        if (null == fscPayLogPO || null == fscPayLogPO.getBusiAmount()) {
            log.error("\u4ed8\u6b3e\u8bb0\u5f55\u8868\u65e0\u4ed8\u6b3e\u6210\u529f\u8bb0\u5f55\uff0c\u672c\u6b21\u540c\u6b65\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)reqBO));
            return;
        }
        if (fscPayLogPO.getBusiAmount().compareTo(fscOrder.getTotalCharge()) >= 0) {
            FscOrderPO fscOrderSet = new FscOrderPO();
            fscOrderSet.setPayState(FscConstants.FscPayOrderState.PAIED);
            FscOrderPO fscOrderWhere = new FscOrderPO();
            fscOrderWhere.setFscOrderId(fscOrder.getFscOrderId());
            this.fscOrderMapper.updateBy(fscOrderSet, fscOrderWhere);
            this.updateInspStatus(fscOrder);
        }
    }

    private void updateInspStatus(FscOrderPO fscOrder) {
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(fscOrder.getFscOrderId());
        fscOrderRelationPO.setOrderBy("id");
        Page fscOrderRelationPOPage = new Page(1, 100);
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getListPage(fscOrderRelationPO, fscOrderRelationPOPage);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
            return;
        }
        this.sendMqSyncInspPayStatus(fscOrderRelationPOList);
        if (fscOrderRelationPOPage.getTotalPages() > 1) {
            for (int i = 2; i < fscOrderRelationPOPage.getTotalPages(); ++i) {
                FscOrderRelationPO pageOrderRelationPo = new FscOrderRelationPO();
                pageOrderRelationPo.setFscOrderId(fscOrder.getFscOrderId());
                pageOrderRelationPo.setOrderBy("id");
                Page pagePo = new Page(1, 100);
                fscOrderRelationPOList = this.fscOrderRelationMapper.getListPage(pageOrderRelationPo, pagePo);
                if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) break;
                this.sendMqSyncInspPayStatus(fscOrderRelationPOList);
            }
        }
    }

    private void sendMqSyncInspPayStatus(List<FscOrderRelationPO> fscOrderRelationPOList) {
        FscUocUpdateInspPayStatusReqBo fscUocUpdateInspPayStatusReqBo = new FscUocUpdateInspPayStatusReqBo();
        List inspIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
        fscUocUpdateInspPayStatusReqBo.setInspList(inspIds);
        this.fscInspOrderPayStatusSyncServiceProvider.send(new ProxyMessage(this.fscInspOrderPayStatusSyncOrderTopic, this.fscInspOrderPayStatusSyncOrderTag, JSON.toJSONString((Object)fscUocUpdateInspPayStatusReqBo)));
    }

    private FscOrderPO getFscOrder(FscPayInfoBackAbilityReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getBusiOrderId());
        return this.fscOrderMapper.getModelBy(fscOrderPo);
    }
}

