/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscUocOrderPayAbilityService;
import com.tydic.fsc.pay.ability.bo.FscUocOrderPayAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscUocOrderPayAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscOrderPayBusiService;
import com.tydic.fsc.pay.busi.bo.FscOrderPayBusiReqBo;
import com.tydic.fsc.pay.busi.bo.FscOrderPayBusiRspBo;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscUocOrderPayAbilityService"})
public class FscUocOrderPayAbilityServiceImpl
implements FscUocOrderPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscUocOrderPayAbilityServiceImpl.class);
    @Autowired
    private FscOrderPayBusiService fscOrderPayBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Resource(name="fscTodoSyncProvider")
    private ProxyMessageProducer fscTodoSyncProvider;
    @Value(value="${FSC_TODO_SYNC_TOPIC:FSC_TODO_SYNC_TOPIC}")
    private String fscTodoSyncTopic;
    @Value(value="${FSC_TODO_SYNC_TAG:FSC_TODO_SYNC_TAG}")
    private String fscTodoSyncTag;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Resource(name="fscOrderPayStatusSyncServiceProvider")
    private ProxyMessageProducer fscOrderPayStatusSyncServiceProvider;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC}")
    private String fscOrderPayStatusSyncOrderTopic;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG}")
    private String fscOrderPayStatusSyncOrderTag;

    @PostMapping(value={"dealOrderPay"})
    public FscUocOrderPayAbilityRspBO dealOrderPay(@RequestBody FscUocOrderPayAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPayBusiReqBo fscOrderPayBusiReqBo = (FscOrderPayBusiReqBo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPayBusiReqBo.class));
        fscOrderPayBusiReqBo.setDetailName("\u8ba2\u5355\u652f\u4ed8");
        FscOrderPayBusiRspBo fscOrderPayBusiRspBo = this.fscOrderPayBusiService.dealOrderPay(fscOrderPayBusiReqBo);
        if (!"0000".equals(fscOrderPayBusiRspBo.getRespCode())) {
            throw new FscBusinessException(fscOrderPayBusiRspBo.getRespCode(), fscOrderPayBusiRspBo.getRespDesc());
        }
        if ("0000".equals(fscOrderPayBusiRspBo.getRespCode())) {
            if (fscOrderPayBusiRspBo.getIsStartAuditFlow().booleanValue()) {
                this.startAuditFlow(reqBO, fscOrderPayBusiRspBo.getFscAuditBaseBo());
            }
            this.syncEs(fscOrderPayBusiRspBo);
            if (null != fscOrderPayBusiRspBo.getFscTodoBO()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("newStatus", (Object)fscOrderPayBusiRspBo.getFscTodoBO().getNewStatus());
                jsonObject.put("fscOrderId", (Object)fscOrderPayBusiRspBo.getFscTodoBO().getFscOrderId());
                jsonObject.put("createTime", (Object)new Date());
                jsonObject.put("sendService", (Object)this.getClass().getName());
                this.fscTodoSyncProvider.send(new ProxyMessage(this.fscTodoSyncTopic, this.fscTodoSyncTag, JSON.toJSONString((Object)jsonObject)));
            }
            ArrayList<Long> fscOrderIds = new ArrayList<Long>();
            fscOrderIds.add(fscOrderPayBusiRspBo.getFscOrderId());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("busiParam", fscOrderIds);
            jsonObject.put("createTime", (Object)new Date());
            jsonObject.put("sendService", (Object)this.getClass().getName());
            this.fscOrderPayStatusSyncServiceProvider.send(new ProxyMessage(this.fscOrderPayStatusSyncOrderTopic, this.fscOrderPayStatusSyncOrderTag, JSON.toJSONString((Object)jsonObject)));
        }
        return (FscUocOrderPayAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscOrderPayBusiRspBo)), FscUocOrderPayAbilityRspBO.class);
    }

    private void syncEs(FscOrderPayBusiRspBo fscOrderPayBusiRspBo) {
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        if (fscOrderPayBusiRspBo.getFscOrderId() != null) {
            fscOrderIds.add(fscOrderPayBusiRspBo.getFscOrderId());
        }
        fscOrderIds.forEach(fscOrderId -> {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
            fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        });
    }

    private void startAuditFlow(FscUocOrderPayAbilityReqBO reqBO, FscAuditBaseBo fscAuditBaseBo) {
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(fscAuditBaseBo.getProcDefKey());
        eacStartProjectAbilityReqBO.setPartitionKey(fscAuditBaseBo.getPartitionKey());
        eacStartProjectAbilityReqBO.setVariables(fscAuditBaseBo.getVariables());
        eacStartProjectAbilityReqBO.setBusinessIdList(fscAuditBaseBo.getBusinessIdList());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void val(FscUocOrderPayAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getShouldPayId()) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getPayAmount()) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getPayMethod())) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getPayChannel())) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("3".equals(abilityReqBO.getPayChannel())) {
            if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscAttachmentBOS())) {
                throw new FscBusinessException("191000", "\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4ed8\u6b3e\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            abilityReqBO.getFscAttachmentBOS().forEach(attachmentBO -> {
                if (null == attachmentBO.getAttachmentType()) {
                    throw new FscBusinessException("191000", "\u9644\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)attachmentBO.getAttachmentName())) {
                    throw new FscBusinessException("191000", "\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)attachmentBO.getAttachmentUrl())) {
                    throw new FscBusinessException("191000", "\u9644\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            });
        }
    }
}

