/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayBackRelationMapper;
import com.tydic.fsc.dao.FscPayBackOrderMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.pay.atom.api.FscPayRefundDealAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayRefundDealAtomServiceReqBo;
import com.tydic.fsc.pay.atom.bo.FscPayRefundDealAtomServiceRspBo;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayBackRelationPO;
import com.tydic.fsc.po.FscPayBackOrderPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscPayRelationPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayRefundDealAtomServiceImpl
implements FscPayRefundDealAtomService {
    @Autowired
    private FscPayBackOrderMapper fscPayBackOrderMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayBackRelationMapper fscOrderPayBackRelationMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;

    @Override
    public FscPayRefundDealAtomServiceRspBo dealPayRefund(FscPayRefundDealAtomServiceReqBo reqBo) {
        FscPayRefundDealAtomServiceRspBo rspBo = new FscPayRefundDealAtomServiceRspBo();
        FscPayBackOrderPO fscPayBackOrderPO = this.getFscPayBackOrderPO(reqBo);
        this.updatePayStatus(reqBo, fscPayBackOrderPO);
        this.createPayLog(reqBo, rspBo);
        return rspBo;
    }

    private void createPayLog(FscPayRefundDealAtomServiceReqBo reqBo, FscPayRefundDealAtomServiceRspBo rspBo) {
        FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
        fscPayRelationPO.setPayOrderId(reqBo.getPayBackOutOrderId());
        fscPayRelationPO = this.fscPayRelationMapper.getModelBy(fscPayRelationPO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscPayRelationPO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(fscOrderPO.getPayerId());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        FscMerchantPO fscMerchant = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        FscOrderPayBackRelationPO fscOrderPayBackRelationPO = new FscOrderPayBackRelationPO();
        fscOrderPayBackRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderPayBackRelationPO = this.fscOrderPayBackRelationMapper.getModelBy(fscOrderPayBackRelationPO);
        FscCreditBalancePO fscCreditBalancePO = new FscCreditBalancePO();
        fscCreditBalancePO.setCreditOrgId(fscOrderPO.getPayeeId());
        fscCreditBalancePO.setMerchantId(fscMerchant.getMerchantId());
        fscCreditBalancePO = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
        Date now = new Date();
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayLogPO.setAccountId(fscMerchant.getAccountId());
        fscPayLogPO.setOrgId(fscOrderPO.getPayerId());
        fscPayLogPO.setPayeeId(fscOrderPO.getPayeeId());
        fscPayLogPO.setUserName(fscOrderPO.getCreateOperName());
        fscPayLogPO.setBusiTime(now);
        fscPayLogPO.setCreateTime(now);
        fscPayLogPO.setBusiAmount(fscOrderPO.getTotalCharge().negate());
        fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
        fscPayLogPO.setBusiOrderType(FscConstants.CreditOrderType.ORDER);
        fscPayLogPO.setBusiOrderId(fscOrderPayBackRelationPO.getRefundOrderId());
        fscPayLogPO.setBusiOrderNo(fscOrderPayBackRelationPO.getRefundOrderNo());
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            fscPayLogPO.setIsCredit(FscConstants.IS_CREDIT.YES);
            if (null != fscCreditBalancePO) {
                fscPayLogPO.setBusiBeforeAmount(fscCreditBalancePO.getAvailableAmount());
                fscPayLogPO.setBusiAfterAmount(fscCreditBalancePO.getAvailableAmount());
            } else {
                fscPayLogPO.setBusiBeforeAmount(fscMerchant.getPayCreditAmount());
                fscPayLogPO.setBusiAfterAmount(fscMerchant.getPayCreditAmount());
            }
        } else {
            fscPayLogPO.setIsCredit(FscConstants.IS_CREDIT.NO);
        }
        this.fscPayLogMapper.insert(fscPayLogPO);
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBo.getPayBackOutOrderId());
        FscOrderPO set = new FscOrderPO();
        set.setPayTime(now);
        this.fscOrderMapper.updateBy(set, where);
        rspBo.setFscOrderId(fscPayRelationPO.getFscOrderId());
    }

    private FscPayBackOrderPO getFscPayBackOrderPO(FscPayRefundDealAtomServiceReqBo reqBo) {
        FscPayBackOrderPO fscPayBackOrderPO = new FscPayBackOrderPO();
        fscPayBackOrderPO.setPayBackOrderId(reqBo.getPayBackOutOrderId());
        fscPayBackOrderPO = this.fscPayBackOrderMapper.getModelBy(fscPayBackOrderPO);
        return fscPayBackOrderPO;
    }

    private void updatePayStatus(FscPayRefundDealAtomServiceReqBo reqBo, FscPayBackOrderPO fscPayBackOrderPO) {
        if (!"3".equals(fscPayBackOrderPO.getPayBackChannel())) {
            FscPayBackOrderPO where = new FscPayBackOrderPO();
            where.setPayBackOrderId(reqBo.getPayBackOutOrderId());
            FscPayBackOrderPO set = new FscPayBackOrderPO();
            set.setPayBackStatus(FscConstants.PayBackStatus.ALREADY_PAY_BACK);
            this.fscPayBackOrderMapper.updateBy(where, set);
        }
    }
}

