/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.order.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommSkuStockInfoRecordsChangeType;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseJdAddressCheckReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseJdAddressCheckRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseJdAddressQryReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseJdAddressQryRspBO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrDetailQryApiService;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrItemListQryApiService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDetailQryApiReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDetailQryApiRspBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemApiBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryApiReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrItemListQryApiRspBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyReqBO;
import com.tydic.dyc.pro.dmc.service.pool.bo.DycProCommPurchaseAuthByBuyRspBO;
import com.tydic.dyc.pro.dmc.service.purchaseAuth.api.DycProCommPurchaseAuthByBuyService;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrScopeJudgeQryService;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommShoppingCartGoodsQryService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeQryReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrScopeJudgeQryRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsInfoBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsQryReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommShoppingCartGoodsQryRspBO;
import com.tydic.dyc.pro.dmc.service.stock.api.DycProCommSkuStockDeductService;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductReqBO;
import com.tydic.dyc.pro.dmc.service.stock.bo.DycProCommSkuStockDeductRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCreateOrderServiceService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqAddressBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqAgrInfoBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqCommodityBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqInvoiceBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqProfessionalBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqSupplierInfoBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspSaleOrderBO;
import com.tydic.dyc.umc.service.enterprise.UmcQrySupplierInfoListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseContactBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQrySupplierInfoListReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQrySupplierInfoListRspBO;
import com.tydic.dyc.umc.service.shoppingcart.UmcRemoveShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartRspBo;
import com.tydic.dycpro.saas.order.order.api.DycProSaasOrderCreateOrderService;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderAgreementBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderCommodityBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderCommodityFillInBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderCreateOrderContextBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderCreateOrderReqBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderCreateOrderRspBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderCreateSaleOrderBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderProfessionalDetailBO;
import com.tydic.dycpro.saas.order.order.bo.DycProSaasOrderSupplierInfoBO;
import com.tydic.osworkflow.ability.OsworkflowStartProcAbilityService;
import com.tydic.osworkflow.ability.bo.StartWithInstanceReqBO;
import com.tydic.osworkflow.ability.bo.StartWithInstanceRespBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.order.order.api.DycProSaasOrderCreateOrderService"})
public class DycProSaasOrderCreateOrderServiceImpl
implements DycProSaasOrderCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasOrderCreateOrderServiceImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${call.esb.url.checkArea}")
    private String checkAreaUrl;
    @Value(value="${call.esb.url.getJDAddressFromAddress}")
    private String getJDAddressFromAddress;
    @Autowired
    private DycProCommPurchaseAuthByBuyService dycProCommPurchaseAuthByBuyService;
    @Autowired
    private DycProAgrItemListQryApiService dycProAgrItemListQryApiService;
    @Autowired
    private DycProAgrDetailQryApiService dycProAgrDetailQryApiService;
    @Autowired
    private DycProCommAgrScopeJudgeQryService dycProCommAgrScopeJudgeQryService;
    @Autowired
    private DycProCommShoppingCartGoodsQryService dycProCommShoppingCartGoodsQryService;
    @Value(value="${uoc.proId:1}")
    private String proId;
    @Value(value="${uoc.proNo:bcm}")
    private String proNo;
    @Value(value="${uoc.proName:\u8fd0\u8425\u7ba1\u7406\u54581}")
    private String proName;
    @Autowired
    private UmcQrySupplierInfoListService umcQrySupplierInfoListService;
    @Autowired
    private DycProCommSkuStockDeductService dycProCommSkuStockDeductService;
    @Autowired
    private DycProOrderCreateOrderServiceService dycProOrderCreateOrderServiceService;
    public static final Integer E_COMMERCE_IMPORT = 2;
    public static final Integer AGR_GENERATE = 3;
    @Value(value="${uoc.agrSaleOrderProcessKey:EGC_AGREEMENT_ORDER_BUSI_FLOW}")
    private String agrSaleOrderProcessKey;
    @Value(value="${uoc.estoreSaleOrderProcessKey:EGC_DS_ORDER_BUSI_FLOW}")
    private String esSaleOrderProcessKey;
    @Value(value="${uoc.auditProcessKey:EGC_ORDER_CREATE_AUDIT_FLOW}")
    private String auditProcessKey;
    @Autowired
    private OsworkflowStartProcAbilityService osworkflowStartProcAbilityService;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    public static final Integer SALE = 2;
    @Autowired
    private UmcRemoveShoppingCartService umcRemoveShoppingCartService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;

    @Override
    @PostMapping(value={"createOrder"})
    public DycProSaasOrderCreateOrderRspBO createOrder(@RequestBody DycProSaasOrderCreateOrderReqBO reqBO) {
        log.debug("\u4e0b\u5355\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        this.verifyParam(reqBO);
        DycProSaasOrderCreateOrderContextBO contextBO = (DycProSaasOrderCreateOrderContextBO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProSaasOrderCreateOrderContextBO.class);
        this.queryAndVerifyJdAddressInfo(contextBO);
        this.batchQuerySkuAndAgreementInfo(contextBO);
        this.queryProfessionalInfo(contextBO);
        this.querySupplierInfo(contextBO);
        if (null == reqBO.getIsNoSupllier() || 0 == reqBO.getIsNoSupllier()) {
            this.minusInventory(contextBO);
        }
        this.createSaleOrder(contextBO);
        this.startSaleOrderProcess(contextBO);
        Boolean isAllAgr = contextBO.getCreateOrderResult().getSaleOrderList().stream().allMatch(bo -> 3 == bo.getOrderSource());
        if (isAllAgr.booleanValue()) {
            this.startApproveProcess(contextBO);
        }
        if (null == reqBO.getIsNoSupllier() || 0 == reqBO.getIsNoSupllier()) {
            this.deleteShopCartGoods(contextBO);
        }
        DycProSaasOrderCreateOrderRspBO rspBO = new DycProSaasOrderCreateOrderRspBO();
        rspBO.setOrderId(String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
        rspBO.setSaleOrderList(JSONArray.parseArray((String)JSON.toJSONString((Object)contextBO.getCreateOrderResult().getSaleOrderList()), DycProSaasOrderCreateSaleOrderBO.class));
        return rspBO;
    }

    private void startApproveProcess(DycProSaasOrderCreateOrderContextBO contextBO) {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("auditId", contextBO.getCreateOrderResult().getAuditId());
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        BeanUtils.copyProperties((Object)contextBO, (Object)eacStartProjectAbilityReqBO);
        eacStartProjectAbilityReqBO.setUserId(contextBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setProcDefKey(this.auditProcessKey);
        eacStartProjectAbilityReqBO.setSysCode(this.SYS_CODE);
        eacStartProjectAbilityReqBO.setPartitionKey(contextBO.getCreateOrderResult().getOrderId().toString());
        eacStartProjectAbilityReqBO.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(contextBO.getCreateOrderResult().getAuditId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(strings);
        log.info("\u8ba2\u5355\u4e0b\u5355\u5ba1\u6279\u6d41\u7a0b\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8ba2\u5355\u4e0b\u5355\u5ba1\u6279\u6d41\u7a0b\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void deleteShopCartGoods(DycProSaasOrderCreateOrderContextBO contextBO) {
        UmcRemoveShoppingCartReqBo umcRemoveShoppingCartReqBo = new UmcRemoveShoppingCartReqBo();
        umcRemoveShoppingCartReqBo.setUserId(contextBO.getUserId());
        umcRemoveShoppingCartReqBo.setGoodsInfoList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(UmcAddShoppingCartBo.class));
        log.info("\u6e05\u9664\u8d2d\u7269\u8f66\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)umcRemoveShoppingCartReqBo));
        UmcRemoveShoppingCartRspBo umcRemoveShoppingCartRspBo = this.umcRemoveShoppingCartService.removeShoppingCart(umcRemoveShoppingCartReqBo);
        log.info("\u6e05\u9664\u8d2d\u7269\u8f66\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)umcRemoveShoppingCartRspBo));
        if (!"0000".equals(umcRemoveShoppingCartRspBo.getRespCode())) {
            throw new BaseBusinessException(umcRemoveShoppingCartRspBo.getRespCode(), "\u6e05\u9664\u8d2d\u7269\u8f66\u4e2d\u672c\u6b21\u5df2\u4e0b\u5355\u7684\u5546\u54c1\u5931\u8d25\uff1a" + umcRemoveShoppingCartRspBo.getRespDesc());
        }
    }

    private void startSaleOrderProcess(DycProSaasOrderCreateOrderContextBO contextBO) {
        for (DycProOrderCreateOrderServiceRspSaleOrderBO saleOrderInfo : contextBO.getCreateOrderResult().getSaleOrderList()) {
            String createOrderProcessKey = null;
            if (AGR_GENERATE.equals(saleOrderInfo.getOrderSource())) {
                createOrderProcessKey = this.agrSaleOrderProcessKey;
            } else if (E_COMMERCE_IMPORT.equals(saleOrderInfo.getOrderSource())) {
                createOrderProcessKey = this.esSaleOrderProcessKey;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{createOrderProcessKey})) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("orderId", String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
                variables.put("saleOrderNo", saleOrderInfo.getSaleOrderNo());
                variables.put("saleOrderId", saleOrderInfo.getSaleOrderId());
                variables.put("auditObjId", saleOrderInfo.getSaleOrderId());
                variables.put("auditObjType", SALE);
                variables.put("auditObjCode", saleOrderInfo.getSaleOrderNo());
                variables.put("objId", saleOrderInfo.getSaleOrderId());
                variables.put("orgId", contextBO.getOrgId());
                variables.put("orgName", contextBO.getOrgName());
                variables.put("userId", contextBO.getUserId());
                variables.put("createOperId", contextBO.getUserId());
                variables.put("userName", contextBO.getName());
                variables.put("modelSettle", saleOrderInfo.getModelSettle());
                variables.put("supId", saleOrderInfo.getSupId());
                variables.put("supplierId", saleOrderInfo.getSupId());
                variables.put("proId", saleOrderInfo.getProId());
                variables.put("shipStartflag", 0);
                variables.put("shipCompleteflag", 0);
                variables.put("subOrderStartflag", 0);
                variables.put("subOrderCompleteflag", 0);
                variables.put("orderSale", contextBO.getTotalSaleFee());
                variables.put("autidStartflag", "1");
                variables.put("autidCompleteflag", "1");
                variables.put("adjustPriceAutidStartflag", "1");
                variables.put("adjustPriceAutidCompleteflag", "1");
                variables.put("auditResult", "1");
                variables.put("auditOrderStatus", "1");
                StartWithInstanceReqBO startWithInstanceReqBO = new StartWithInstanceReqBO();
                startWithInstanceReqBO.setVariables(variables);
                startWithInstanceReqBO.setProcDefKey(createOrderProcessKey);
                startWithInstanceReqBO.setPartitonKey(contextBO.getCreateOrderResult().getOrderId().toString());
                startWithInstanceReqBO.setBusinessId(saleOrderInfo.getSaleOrderId().toString());
                startWithInstanceReqBO.setSysCode(this.SYS_CODE);
                log.debug("\u8ba2\u5355\u4e0b\u5355\u4e1a\u52a1\u6d41\u7a0b\u542f\u52a8\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)startWithInstanceReqBO));
                StartWithInstanceRespBO sartWithInstanceRespBO = this.osworkflowStartProcAbilityService.startWithInstanceByMq(startWithInstanceReqBO);
                log.debug("\u8ba2\u5355\u4e0b\u5355\u4e1a\u52a1\u6d41\u7a0b\u542f\u52a8\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)sartWithInstanceRespBO));
                if (!"0000".equals(sartWithInstanceRespBO.getRespCode())) {
                    throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + sartWithInstanceRespBO.getRespCode() + "\u3011," + sartWithInstanceRespBO.getRespDesc());
                }
                log.debug("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)sartWithInstanceRespBO));
                continue;
            }
            throw new ZTBusinessException("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\uff0c\u672a\u83b7\u53d6\u5230\u9700\u8981\u542f\u52a8\u7684\u6d41\u7a0bkey");
        }
    }

    private void createSaleOrder(DycProSaasOrderCreateOrderContextBO contextBO) {
        DycProOrderCreateOrderServiceReqBO uocCreateOrderServiceReqBo = new DycProOrderCreateOrderServiceReqBO();
        uocCreateOrderServiceReqBo.setTraceId(contextBO.getTraceId());
        uocCreateOrderServiceReqBo.setUserId(contextBO.getUserId());
        uocCreateOrderServiceReqBo.setName(contextBO.getName());
        uocCreateOrderServiceReqBo.setUserName(contextBO.getUserName());
        uocCreateOrderServiceReqBo.setOrgId(contextBO.getOrgId());
        uocCreateOrderServiceReqBo.setOrgName(contextBO.getOrgName());
        uocCreateOrderServiceReqBo.setOrgPath(contextBO.getOrgPath());
        uocCreateOrderServiceReqBo.setCompanyId(contextBO.getCompanyId());
        uocCreateOrderServiceReqBo.setCompanyName(contextBO.getCompanyName());
        uocCreateOrderServiceReqBo.setTotalSaleFee(contextBO.getTotalSaleFee());
        uocCreateOrderServiceReqBo.setTotalPurchaseFee(contextBO.getCommodityInfos().stream().map(bo -> bo.getPurchasePrice().multiply(bo.getPurchaseCount())).reduce(BigDecimal.ZERO, BigDecimal::add));
        uocCreateOrderServiceReqBo.setTotalTransFee(contextBO.getTotalTransFee());
        uocCreateOrderServiceReqBo.setRemark(contextBO.getRemark());
        uocCreateOrderServiceReqBo.setPurContactName(contextBO.getPurPlaceOrderName());
        uocCreateOrderServiceReqBo.setPurMobile(contextBO.getPurMobile());
        uocCreateOrderServiceReqBo.setPurNeedName(contextBO.getPurNeedName());
        uocCreateOrderServiceReqBo.setPurNeedMobile(contextBO.getPurNeedMobile());
        uocCreateOrderServiceReqBo.setSendTime(contextBO.getSendTime());
        uocCreateOrderServiceReqBo.setOrderItems(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityInfos())).toJavaList(DycProOrderCreateOrderServiceReqCommodityBO.class));
        uocCreateOrderServiceReqBo.setUocOrdInvoice((DycProOrderCreateOrderServiceReqInvoiceBO)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getInvoiceBo()), DycProOrderCreateOrderServiceReqInvoiceBO.class));
        uocCreateOrderServiceReqBo.setOperating((DycProOrderCreateOrderServiceReqProfessionalBO)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getProfessionalDetailBO()), DycProOrderCreateOrderServiceReqProfessionalBO.class));
        uocCreateOrderServiceReqBo.setSupplierBos(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getSupplierBos())).toJavaList(DycProOrderCreateOrderServiceReqSupplierInfoBO.class));
        if (!CollectionUtils.isEmpty(contextBO.getAgreementInfos())) {
            uocCreateOrderServiceReqBo.setAgrInfoList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getAgreementInfos())).toJavaList(DycProOrderCreateOrderServiceReqAgrInfoBO.class));
        }
        if (ObjectUtil.isNotEmpty((Object)contextBO.getAddressBo())) {
            uocCreateOrderServiceReqBo.setReceiverAddress((DycProOrderCreateOrderServiceReqAddressBO)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getAddressBo()), DycProOrderCreateOrderServiceReqAddressBO.class));
        }
        if (ObjectUtil.isNotEmpty((Object)contextBO.getInvoiceAddressBo())) {
            uocCreateOrderServiceReqBo.setInvoiceAddress((DycProOrderCreateOrderServiceReqAddressBO)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getInvoiceAddressBo()), DycProOrderCreateOrderServiceReqAddressBO.class));
        }
        uocCreateOrderServiceReqBo.setAccessoryList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getAttachBos())).toJavaList(DycProOrderAccessoryApiBO.class));
        uocCreateOrderServiceReqBo.setOrderName(contextBO.getOrderName());
        log.debug("contextBO.getCommodityBos()" + JSON.toJSONString(contextBO.getCommodityBos()));
        log.debug("contextBO.getCommodityInfos()" + JSON.toJSONString(contextBO.getCommodityInfos()));
        log.debug("uocCreateOrderServiceReqBo.getOrderItems()" + JSON.toJSONString((Object)uocCreateOrderServiceReqBo.getOrderItems()));
        log.info("\u8c03\u7528\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocCreateOrderServiceReqBo));
        DycProOrderCreateOrderServiceRspBO uocCreateOrderServiceRspBo = this.dycProOrderCreateOrderServiceService.createOrder(uocCreateOrderServiceReqBo);
        log.info("\u8c03\u7528\u8ba2\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocCreateOrderServiceRspBo));
        if (!"0000".equals(uocCreateOrderServiceRspBo.getRespCode())) {
            throw new BaseBusinessException(uocCreateOrderServiceRspBo.getRespCode(), "\u521b\u5efa\u9500\u552e\u5355\u5931\u8d25\uff1a" + uocCreateOrderServiceRspBo.getRespDesc());
        }
        contextBO.setCreateOrderResult(uocCreateOrderServiceRspBo);
    }

    private void minusInventory(DycProSaasOrderCreateOrderContextBO contextBO) {
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        for (DycProSaasOrderCommodityBO bo : contextBO.getCommodityBos()) {
            resultMap.put(bo.getSkuId(), resultMap.getOrDefault(bo.getSkuId(), BigDecimal.ZERO).add(bo.getPurchaseCount()));
        }
        DycProCommSkuStockDeductReqBO dycProCommSkuStockDeductReqBO = new DycProCommSkuStockDeductReqBO();
        ArrayList<DycProCommSkuStockDeductBO> deductBOList = new ArrayList<DycProCommSkuStockDeductBO>();
        for (Map.Entry entry : resultMap.entrySet()) {
            DycProCommSkuStockDeductBO dycProCommSkuStockDeductBO = new DycProCommSkuStockDeductBO();
            dycProCommSkuStockDeductBO.setSkuId((Long)entry.getKey());
            dycProCommSkuStockDeductBO.setDeductAmount((BigDecimal)entry.getValue());
            deductBOList.add(dycProCommSkuStockDeductBO);
        }
        dycProCommSkuStockDeductReqBO.setDeductBOList(deductBOList);
        dycProCommSkuStockDeductReqBO.setChangeType(Integer.valueOf(DmcCommSkuStockInfoRecordsChangeType.ORDER_REDUCE.getCode()));
        log.debug("\u8c03\u7528\u6263\u51cf\u5e93\u5b58\u5165\u53c2" + JSON.toJSONString((Object)dycProCommSkuStockDeductReqBO));
        DycProCommSkuStockDeductRspBO dycProCommSkuStockDeductRspBO = this.dycProCommSkuStockDeductService.dealSkuStockDeduct(dycProCommSkuStockDeductReqBO);
        log.debug("\u8c03\u7528\u6263\u51cf\u5e93\u5b58\u51fa\u53c2" + JSON.toJSONString((Object)dycProCommSkuStockDeductRspBO));
        if (!"0000".equals(dycProCommSkuStockDeductRspBO.getRespCode())) {
            throw new BaseBusinessException(dycProCommSkuStockDeductRspBO.getRespCode(), "\u8c03\u7528\u5546\u54c1\u5e93\u5b58\u6263\u51cfAPI\u5931\u8d25\uff1a" + dycProCommSkuStockDeductRspBO.getRespDesc());
        }
    }

    private void querySupplierInfo(DycProSaasOrderCreateOrderContextBO contextBO) {
        List supplierIds = contextBO.getCommodityBos().stream().map(DycProSaasOrderCommodityBO::getSupplierId).distinct().collect(Collectors.toList());
        HashMap<Long, DycProSaasOrderSupplierInfoBO> supplierInfosMap = new HashMap<Long, DycProSaasOrderSupplierInfoBO>();
        UmcQrySupplierInfoListReqBO umcQrySupplierInfoListReqBO = new UmcQrySupplierInfoListReqBO();
        umcQrySupplierInfoListReqBO.setSupplierIds(supplierIds);
        umcQrySupplierInfoListReqBO.setPageSize(Integer.valueOf(supplierIds.size()));
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcQrySupplierInfoListReqBO));
        UmcQrySupplierInfoListRspBO umcQrySupplierInfoListRspBO = this.umcQrySupplierInfoListService.qrySupplierInfoList(umcQrySupplierInfoListReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcQrySupplierInfoListRspBO));
        if ("0000".equals(umcQrySupplierInfoListRspBO.getRespCode())) {
            for (UmcEnterpriseInfoBo umcEnterpriseInfoBo : umcQrySupplierInfoListRspBO.getRows()) {
                DycProSaasOrderSupplierInfoBO dycUocSupplierInfoFuncBO = new DycProSaasOrderSupplierInfoBO();
                dycUocSupplierInfoFuncBO.setSupplierId(umcEnterpriseInfoBo.getOrgId());
                dycUocSupplierInfoFuncBO.setSupplierCode(umcEnterpriseInfoBo.getOrgCode());
                dycUocSupplierInfoFuncBO.setSupplierName(umcEnterpriseInfoBo.getOrgName());
                dycUocSupplierInfoFuncBO.setSupOrgPath(umcEnterpriseInfoBo.getOrgTreePath());
                if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoBo.getEnterpriseContactList())) {
                    dycUocSupplierInfoFuncBO.setSupRelaName(((UmcEnterpriseContactBo)umcEnterpriseInfoBo.getEnterpriseContactList().get(0)).getContactName());
                    dycUocSupplierInfoFuncBO.setSupRelaMobile(((UmcEnterpriseContactBo)umcEnterpriseInfoBo.getEnterpriseContactList().get(0)).getPhoneNumber());
                    dycUocSupplierInfoFuncBO.setContactEmail(((UmcEnterpriseContactBo)umcEnterpriseInfoBo.getEnterpriseContactList().get(0)).getEmail());
                }
                supplierInfosMap.put(dycUocSupplierInfoFuncBO.getSupplierId(), dycUocSupplierInfoFuncBO);
            }
        } else {
            throw new BaseBusinessException(umcQrySupplierInfoListRspBO.getRespCode(), "\u67e5\u8be2\u4f9b\u5e94\u5546\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff1a" + umcQrySupplierInfoListRspBO.getRespDesc());
        }
        contextBO.setSupplierBos(new ArrayList<DycProSaasOrderSupplierInfoBO>(supplierInfosMap.values()));
    }

    private void queryProfessionalInfo(DycProSaasOrderCreateOrderContextBO contextBO) {
        DycProSaasOrderProfessionalDetailBO professionalDetailBO = new DycProSaasOrderProfessionalDetailBO();
        professionalDetailBO.setProId(this.proId);
        professionalDetailBO.setProNo(this.proNo);
        professionalDetailBO.setProName(this.proName);
        contextBO.setProfessionalDetailBO(professionalDetailBO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void batchQuerySkuAndAgreementInfo(DycProSaasOrderCreateOrderContextBO contextBO) {
        if (null != contextBO.getIsNoSupllier() && 1 == contextBO.getIsNoSupllier()) {
            List<Long> agrItemIds = contextBO.getCommodityBos().stream().map(DycProSaasOrderCommodityBO::getAgrItemId).collect(Collectors.toList());
            this.checkBuyAuth(contextBO, agrItemIds, null);
            DycProAgrItemListQryApiReqBO dycProAgrItemListQryApiReqBO = new DycProAgrItemListQryApiReqBO();
            dycProAgrItemListQryApiReqBO.setAgrItemIds(agrItemIds);
            dycProAgrItemListQryApiReqBO.setAgrOrderQryFlag(Boolean.valueOf(true));
            log.debug("\u8c03\u7528\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)dycProAgrItemListQryApiReqBO));
            DycProAgrItemListQryApiRspBO dycProAgrItemListQryApiRspBO = this.dycProAgrItemListQryApiService.qryAgrItemList(dycProAgrItemListQryApiReqBO);
            log.debug("\u8c03\u7528\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u67e5\u8be2\u51fa\u53c2" + JSON.toJSONString((Object)dycProAgrItemListQryApiRspBO));
            if (!"0000".equals(dycProAgrItemListQryApiRspBO.getRespCode())) throw new BaseBusinessException(dycProAgrItemListQryApiRspBO.getRespCode(), "\u8c03\u7528\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u67e5\u8be2\u67e5\u8be2API\u5931\u8d25\uff1a" + dycProAgrItemListQryApiRspBO.getRespDesc());
            if (contextBO.getCommodityBos().size() != dycProAgrItemListQryApiRspBO.getRows().size()) throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            this.comparePriceAndAssembleDataForAgr(contextBO.getCommodityBos(), dycProAgrItemListQryApiRspBO.getRows(), contextBO);
            return;
        } else {
            List<Long> skuIds = contextBO.getCommodityBos().stream().map(DycProSaasOrderCommodityBO::getSkuId).collect(Collectors.toList());
            this.checkBuyAuth(contextBO, null, skuIds);
            DycProCommShoppingCartGoodsQryReqBO dycProCommShoppingCartGoodsQryReqBO = new DycProCommShoppingCartGoodsQryReqBO();
            dycProCommShoppingCartGoodsQryReqBO.setProvince(Long.valueOf(contextBO.getAddressBo().getContactProvinceId()));
            dycProCommShoppingCartGoodsQryReqBO.setCity(Long.valueOf(contextBO.getAddressBo().getContactCityId()));
            dycProCommShoppingCartGoodsQryReqBO.setCounty(Long.valueOf(contextBO.getAddressBo().getContactCountyId()));
            dycProCommShoppingCartGoodsQryReqBO.setTown(Long.valueOf(StringUtils.isNotBlank((CharSequence)contextBO.getAddressBo().getContactTownId()) ? Long.parseLong(contextBO.getAddressBo().getContactTownId()) : 0L));
            dycProCommShoppingCartGoodsQryReqBO.setReturnType(Integer.valueOf(1));
            List skuList = contextBO.getCommodityBos().stream().map(item -> {
                DycProCommShoppingCartGoodsBO dycProCommShoppingCartGoodsBO = new DycProCommShoppingCartGoodsBO();
                dycProCommShoppingCartGoodsBO.setSkuId(item.getSkuId());
                dycProCommShoppingCartGoodsBO.setSpId(item.getSpId());
                if (null == item.getSpId()) {
                    dycProCommShoppingCartGoodsBO.setSpId(item.getSkuId());
                }
                dycProCommShoppingCartGoodsBO.setNum(item.getPurchaseCount());
                return dycProCommShoppingCartGoodsBO;
            }).collect(Collectors.toList());
            dycProCommShoppingCartGoodsQryReqBO.setSkuList(skuList);
            log.debug("\u8c03\u7528\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)dycProCommShoppingCartGoodsQryReqBO));
            DycProCommShoppingCartGoodsQryRspBO dycProCommShoppingCartGoodsQryRspBO = this.dycProCommShoppingCartGoodsQryService.qryShoppingCartGoods(dycProCommShoppingCartGoodsQryReqBO);
            log.debug("\u8c03\u7528\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u51fa\u53c2" + JSON.toJSONString((Object)dycProCommShoppingCartGoodsQryRspBO));
            if (!"0000".equals(dycProCommShoppingCartGoodsQryRspBO.getRespCode())) return;
            if (contextBO.getCommodityBos().size() != dycProCommShoppingCartGoodsQryRspBO.getSkuInfoList().size()) throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            this.comparePriceAndAssembleDataForComm(contextBO.getCommodityBos(), dycProCommShoppingCartGoodsQryRspBO.getSkuInfoList(), contextBO);
        }
    }

    private void comparePriceAndAssembleDataForComm(List<DycProSaasOrderCommodityBO> inputCommodityInfos, List<DycProCommShoppingCartGoodsInfoBO> skuInfoList, DycProSaasOrderCreateOrderContextBO contextBO) {
        ArrayList<DycProSaasOrderCommodityFillInBO> commodityInfos = new ArrayList<DycProSaasOrderCommodityFillInBO>();
        HashMap<Long, DycProSaasOrderAgreementBO> resultAgreementInfosMap = new HashMap<Long, DycProSaasOrderAgreementBO>();
        Map<Long, DycProSaasOrderCommodityBO> inputCommodityInfosMap = inputCommodityInfos.stream().collect(Collectors.toMap(DycProSaasOrderCommodityBO::getSpId, e -> e));
        for (DycProCommShoppingCartGoodsInfoBO backCommodityInfo : skuInfoList) {
            DycProSaasOrderCommodityBO imputCommodityInfo = inputCommodityInfosMap.get(backCommodityInfo.getSpId());
            if (2 != backCommodityInfo.getSkuStatus()) {
                throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u4e0d\u662f\u4e0a\u67b6\u72b6\u6001\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
            }
            if (1 == backCommodityInfo.getBansFlag()) {
                throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u5df2\u7981\u552e\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
            }
            if (3 == backCommodityInfo.getSkuSource()) {
                if (imputCommodityInfo.getPurchaseCount().compareTo(backCommodityInfo.getStockInfo().getUnsaleNum()) > 0) {
                    throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
                }
            } else {
                if (1 != backCommodityInfo.getAreaLimit()) {
                    throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u533a\u57df\u9650\u5236\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
                }
                if (1 != backCommodityInfo.getSkuState()) {
                    throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u4e0d\u662f\u4e0a\u67b6\u72b6\u6001\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
                }
                if (1 != backCommodityInfo.getAvailableSale()) {
                    throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u4e0d\u53ef\u552e\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
                }
                if (34 == backCommodityInfo.getStockStateId() || 0 == backCommodityInfo.getStockStateId()) {
                    throw new ZTBusinessException(backCommodityInfo.getSkuId() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4e0b\u5355\uff01");
                }
            }
            DycProSaasOrderCommodityFillInBO commodityInfo = new DycProSaasOrderCommodityFillInBO();
            BeanUtils.copyProperties((Object)backCommodityInfo, (Object)commodityInfo);
            if (ObjectUtil.isNotEmpty((Object)backCommodityInfo.getPriceInfo().getLadderPriceRule())) {
                commodityInfo.setLadderPrice(true);
            }
            commodityInfo.setUnitDigit(imputCommodityInfo.getUnitDigit());
            commodityInfo.setCmpOrderNo(imputCommodityInfo.getCmpOrderNo());
            commodityInfo.setCmpRemark(imputCommodityInfo.getCmpRemark());
            commodityInfo.setNoCmpReason(imputCommodityInfo.getNoCmpReason());
            commodityInfo.setSkuId(String.valueOf(backCommodityInfo.getSkuId()));
            commodityInfo.setCommodityId(String.valueOf(backCommodityInfo.getSpuId()));
            commodityInfo.setSupplierId(String.valueOf(backCommodityInfo.getSupplierId()));
            commodityInfo.setPurchasePrice(backCommodityInfo.getPriceInfo().getSupplierPrice());
            commodityInfo.setSalePrice(backCommodityInfo.getPriceInfo().getSalePrice());
            commodityInfo.setPurchaseCount(imputCommodityInfo.getPurchaseCount());
            commodityInfo.setUnitName(backCommodityInfo.getSaleMeasureName());
            commodityInfo.setSettleUnit(backCommodityInfo.getSaleMeasureName());
            commodityInfo.setTax(String.valueOf(backCommodityInfo.getRate()));
            commodityInfo.setSkuMaterialId(String.valueOf(backCommodityInfo.getMaterialId()));
            commodityInfo.setSkuMaterialCode(String.valueOf(backCommodityInfo.getMaterialCode()));
            commodityInfo.setSkuBrandName(backCommodityInfo.getBrandName());
            commodityInfo.setSkuMaterialName(backCommodityInfo.getMaterialName());
            commodityInfo.setSkuMaterialTypeName(backCommodityInfo.getMaterialClassifyName());
            commodityInfo.setSkuMaterialTypeId(String.valueOf(backCommodityInfo.getManageCatalogId()));
            commodityInfo.setSkuExtSkuId(backCommodityInfo.getExtSkuId());
            commodityInfo.setSkuMainPicUrl(backCommodityInfo.getPicInfo().getPicUrl());
            if (3 == backCommodityInfo.getSkuSource() && null != backCommodityInfo.getSkuAfterSaleInfo()) {
                commodityInfo.setRejectAllowDate(backCommodityInfo.getSkuAfterSaleInfo().getReturnTimeLimit());
                commodityInfo.setExchangeAllowDate(backCommodityInfo.getSkuAfterSaleInfo().getChangeTimeLimit());
                commodityInfo.setMaintainAllowDate(backCommodityInfo.getSkuAfterSaleInfo().getMaintainTimeLimit());
                ArrayList<Integer> serverReturnTypeList = new ArrayList<Integer>();
                if (null != backCommodityInfo.getSkuAfterSaleInfo() && null != backCommodityInfo.getSkuAfterSaleInfo().getReturnType()) {
                    if (3 != backCommodityInfo.getSkuAfterSaleInfo().getReturnType()) {
                        serverReturnTypeList.add(backCommodityInfo.getSkuAfterSaleInfo().getReturnType());
                    } else {
                        serverReturnTypeList.add(1);
                        serverReturnTypeList.add(2);
                    }
                }
                commodityInfo.setServerReturnTypeList(serverReturnTypeList);
            }
            if (null != backCommodityInfo.getAgrId()) {
                this.setAgrInfo(commodityInfo, backCommodityInfo.getAgrId(), resultAgreementInfosMap);
            }
            commodityInfos.add(commodityInfo);
        }
        contextBO.setCommodityInfos(commodityInfos);
        if (!resultAgreementInfosMap.isEmpty()) {
            contextBO.setAgreementInfos(new ArrayList<DycProSaasOrderAgreementBO>(resultAgreementInfosMap.values()));
        }
        if (!CollectionUtils.isEmpty(commodityInfos)) {
            this.checAgrScope(contextBO);
        }
    }

    private void comparePriceAndAssembleDataForAgr(List<DycProSaasOrderCommodityBO> inputCommodityInfos, List<DycProAgrItemApiBO> skuInfoList, DycProSaasOrderCreateOrderContextBO contextBO) {
        ArrayList<DycProSaasOrderCommodityFillInBO> commodityInfos = new ArrayList<DycProSaasOrderCommodityFillInBO>();
        HashMap<Long, DycProSaasOrderAgreementBO> resultAgreementInfosMap = new HashMap<Long, DycProSaasOrderAgreementBO>();
        Map<Long, DycProSaasOrderCommodityBO> inputCommodityInfosMap = inputCommodityInfos.stream().collect(Collectors.toMap(DycProSaasOrderCommodityBO::getAgrItemId, e -> e));
        for (DycProAgrItemApiBO backCommodityInfo : skuInfoList) {
            DycProSaasOrderCommodityBO imputCommodityInfo = inputCommodityInfosMap.get(backCommodityInfo.getAgrItemId());
            if (imputCommodityInfo.getSalePrice().compareTo(backCommodityInfo.getSalePrice()) != 0) {
                throw new ZTBusinessException(backCommodityInfo.getAgrItemId() + "\u5165\u53c2\u4ef7\u683c\u548c\u534f\u8bae\u8fd4\u56de\u4ef7\u683c\u4e0d\u4e00\u81f4\uff01");
            }
            DycProSaasOrderCommodityFillInBO commodityInfo = new DycProSaasOrderCommodityFillInBO();
            BeanUtils.copyProperties((Object)backCommodityInfo, (Object)commodityInfo);
            commodityInfo.setSkuSource(3);
            if (null != backCommodityInfo.getAgrId()) {
                this.setAgrInfo(commodityInfo, backCommodityInfo.getAgrId(), resultAgreementInfosMap);
            }
            commodityInfo.setUnitDigit(imputCommodityInfo.getUnitDigit());
            commodityInfo.setCmpOrderNo(imputCommodityInfo.getCmpOrderNo());
            commodityInfo.setCmpRemark(imputCommodityInfo.getCmpRemark());
            commodityInfo.setNoCmpReason(imputCommodityInfo.getNoCmpReason());
            commodityInfo.setSkuId(String.valueOf(backCommodityInfo.getAgrItemId()));
            commodityInfo.setCommodityId(String.valueOf(backCommodityInfo.getAgrId()));
            commodityInfo.setSupplierId(String.valueOf(imputCommodityInfo.getSupplierId()));
            commodityInfo.setPurchasePrice(backCommodityInfo.getSupplyPrice());
            commodityInfo.setSalePrice(backCommodityInfo.getSalePrice());
            commodityInfo.setPurchaseCount(imputCommodityInfo.getPurchaseCount());
            commodityInfo.setUnitName(backCommodityInfo.getMeasureName());
            commodityInfo.setSettleUnit(backCommodityInfo.getMeasureName());
            commodityInfo.setTax(String.valueOf(backCommodityInfo.getTaxRate()));
            commodityInfo.setSkuMaterialId(String.valueOf(backCommodityInfo.getMaterialId()));
            commodityInfo.setSkuMaterialCode(String.valueOf(backCommodityInfo.getMaterialCode()));
            commodityInfo.setSkuBrandName(backCommodityInfo.getBrandName());
            commodityInfo.setSkuMaterialName(backCommodityInfo.getMaterialName());
            commodityInfo.setSkuMaterialTypeName(backCommodityInfo.getMaterialClassifyName());
            commodityInfo.setSkuMaterialTypeId(String.valueOf(backCommodityInfo.getManageCatalogId()));
            commodityInfos.add(commodityInfo);
        }
        contextBO.setCommodityInfos(commodityInfos);
        if (!resultAgreementInfosMap.isEmpty()) {
            contextBO.setAgreementInfos(new ArrayList<DycProSaasOrderAgreementBO>(resultAgreementInfosMap.values()));
        }
        if (!CollectionUtils.isEmpty(commodityInfos)) {
            this.checAgrScope(contextBO);
        }
    }

    private void checAgrScope(DycProSaasOrderCreateOrderContextBO contextBO) {
        Map<String, DycProSaasOrderAgreementBO> agreementInfosMap = contextBO.getAgreementInfos().stream().collect(Collectors.toMap(DycProSaasOrderAgreementBO::getAgrId, e -> e));
        if (!CollectionUtils.isEmpty(contextBO.getAgreementInfos())) {
            List agrIds = contextBO.getAgreementInfos().stream().map(DycProSaasOrderAgreementBO::getAgrId).map(Long::parseLong).collect(Collectors.toList());
            DycProCommAgrScopeJudgeQryReqBO dycProCommAgrScopeJudgeQryReqBO = new DycProCommAgrScopeJudgeQryReqBO();
            dycProCommAgrScopeJudgeQryReqBO.setOrgPath(contextBO.getOrgPath());
            dycProCommAgrScopeJudgeQryReqBO.setCompanyId(contextBO.getCompanyId());
            dycProCommAgrScopeJudgeQryReqBO.setAgrIds(agrIds);
            log.info("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u6821\u9a8c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommAgrScopeJudgeQryReqBO));
            DycProCommAgrScopeJudgeQryRspBO dycProCommAgrScopeJudgeQryRspBO = this.dycProCommAgrScopeJudgeQryService.qryAgrScopeJudge(dycProCommAgrScopeJudgeQryReqBO);
            log.info("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u6821\u9a8c\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProCommAgrScopeJudgeQryRspBO));
            if (CollectionUtils.isEmpty((Collection)dycProCommAgrScopeJudgeQryRspBO.getSkuAgrScopeList())) {
                throw new ZTBusinessException("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u6821\u9a8c\u51fa\u53c2\u4e3a\u7a7a");
            }
            Map<Long, List<DycProCommAgrScopeJudgeBO>> agrScopCheckMap = dycProCommAgrScopeJudgeQryRspBO.getSkuAgrScopeList().stream().collect(Collectors.groupingBy(DycProCommAgrScopeJudgeBO::getAgrId));
            for (Long agrId : agrIds) {
                if (agrScopCheckMap.containsKey(agrId)) {
                    if (agrScopCheckMap.get(agrId).get(0).getPurFlag() != null && agrScopCheckMap.get(agrId).get(0).getPurFlag().booleanValue()) continue;
                    throw new ZTBusinessException("\u534f\u8bae\u7f16\u7801\u4e3a\uff1a" + agreementInfosMap.get(agrId.toString()).getPlaAgreementCode() + "\u7684\u534f\u8bae\uff0c\u5e94\u7528\u8303\u56f4\u4e0d\u5305\u62ec\u5f53\u524d\u7528\u6237\uff0c\u4e0d\u80fd\u4e0b\u5355");
                }
                throw new ZTBusinessException("\u67e5\u8be2\u534f\u8bae\u5e94\u7528\u8303\u56f4\u6821\u9a8c\u51fa\u53c2\u672a\u67e5\u8be2\u5230\u534f\u8bae\u7f16\u7801\u4e3a\uff1a" + agreementInfosMap.get(agrId.toString()).getPlaAgreementCode() + "\u7684\u534f\u8bae");
            }
        }
    }

    private void setAgrInfo(DycProSaasOrderCommodityFillInBO commodityInfo, Long agrId, Map<Long, DycProSaasOrderAgreementBO> resultAgreementInfosMap) {
        DycProAgrDetailQryApiReqBO dycProAgrDetailQryApiReqBO = new DycProAgrDetailQryApiReqBO();
        dycProAgrDetailQryApiReqBO.setAgrId(agrId);
        log.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProAgrDetailQryApiReqBO));
        DycProAgrDetailQryApiRspBO dycProAgrDetailQryApiRspBO = this.dycProAgrDetailQryApiService.qryAgrDetail(dycProAgrDetailQryApiReqBO);
        log.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)dycProAgrDetailQryApiRspBO));
        if ("0000".equals(dycProAgrDetailQryApiRspBO.getRespCode())) {
            commodityInfo.setAgreementId(String.valueOf(agrId));
            if (!resultAgreementInfosMap.containsKey(agrId)) {
                DycProSaasOrderAgreementBO agreementFuncBO = new DycProSaasOrderAgreementBO();
                agreementFuncBO.setAgreementId(agrId.toString());
                agreementFuncBO.setPlaAgreementCode(dycProAgrDetailQryApiRspBO.getAgrInfo().getAgrCode());
                agreementFuncBO.setEntAgreementCode(dycProAgrDetailQryApiRspBO.getAgrInfo().getEnAgrCode());
                agreementFuncBO.setAgreementName(dycProAgrDetailQryApiRspBO.getAgrInfo().getAgrName());
                agreementFuncBO.setProducerId(dycProAgrDetailQryApiRspBO.getAgrInfo().getCreateUserId());
                agreementFuncBO.setProducerName(dycProAgrDetailQryApiRspBO.getAgrInfo().getCreateUserName());
                agreementFuncBO.setSupplierId(dycProAgrDetailQryApiRspBO.getAgrInfo().getManagementOrgId());
                agreementFuncBO.setSupplierName(dycProAgrDetailQryApiRspBO.getAgrInfo().getManagementOrgName());
                agreementFuncBO.setVendorId(dycProAgrDetailQryApiRspBO.getAgrInfo().getSupplierId());
                agreementFuncBO.setVendorName(dycProAgrDetailQryApiRspBO.getAgrInfo().getSupplierName());
                agreementFuncBO.setAdjustPrice(dycProAgrDetailQryApiRspBO.getAgrInfo().getAdjustPriceType());
                agreementFuncBO.setAgrDataId(dycProAgrDetailQryApiRspBO.getAgrInfo().getAgrId());
                agreementFuncBO.setAgrId(String.valueOf(dycProAgrDetailQryApiRspBO.getAgrInfo().getAgrId()));
                agreementFuncBO.setProDeliveryId(String.valueOf(dycProAgrDetailQryApiRspBO.getAgrInfo().getCreateUserId()));
                agreementFuncBO.setProDeliveryName(dycProAgrDetailQryApiRspBO.getAgrInfo().getCreateUserName());
                agreementFuncBO.setTradeMode(dycProAgrDetailQryApiRspBO.getAgrInfo().getTradeMode());
                resultAgreementInfosMap.put(dycProAgrDetailQryApiRspBO.getAgrInfo().getAgrId(), agreementFuncBO);
            }
        } else {
            throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1\uff0c\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void checkBuyAuth(DycProSaasOrderCreateOrderContextBO contextBO, List<Long> agrItemIds, List<Long> skuIds) {
        DycProCommPurchaseAuthByBuyReqBO dycProCommPurchaseAuthByBuyReqBO = new DycProCommPurchaseAuthByBuyReqBO();
        dycProCommPurchaseAuthByBuyReqBO.setAgrItemIds(agrItemIds);
        dycProCommPurchaseAuthByBuyReqBO.setSkuIds(skuIds);
        dycProCommPurchaseAuthByBuyReqBO.setOrgPath(contextBO.getOrgPath());
        DycProCommPurchaseAuthByBuyRspBO dycProCommPurchaseAuthByBuyRspBO = this.dycProCommPurchaseAuthByBuyService.qryPurchaseByBuy(dycProCommPurchaseAuthByBuyReqBO);
        if ("0000".equals(dycProCommPurchaseAuthByBuyRspBO.getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)dycProCommPurchaseAuthByBuyRspBO.getRows())) {
                throw new ZTBusinessException("\u4ee5\u4e0b\u660e\u7ec6" + dycProCommPurchaseAuthByBuyRspBO.getRows().stream().map(DycProCommPurchaseAuthByBuyBO::getSkuId).collect(Collectors.toList()) + "\u4e0d\u80fd\u6ca1\u6709\u8d2d\u4e70\u6743\u9650\uff01");
            }
        } else {
            throw new BaseBusinessException(dycProCommPurchaseAuthByBuyRspBO.getRespCode(), "\u8c03\u7528\u91c7\u4e70\u6743\u9650API\u5931\u8d25\uff1a" + dycProCommPurchaseAuthByBuyRspBO.getRespDesc());
        }
    }

    private void queryAndVerifyJdAddressInfo(DycProSaasOrderCreateOrderContextBO contextBO) {
        List supplierIdList = contextBO.getCommodityBos().stream().map(v -> String.valueOf(v.getSupplierId())).collect(Collectors.toList());
        if (supplierIdList.contains(this.environment.getProperty("SUPPLIER_JD_ID")) || supplierIdList.contains(this.environment.getProperty("SUPPLIER_JDVOP_ID"))) {
            if (Objects.isNull(contextBO.getAddressBo()) || StringUtils.isBlank((CharSequence)contextBO.getAddressBo().getContactAddress())) {
                throw new ZTBusinessException("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String hsn = "jd";
            DycProBaseJdAddressCheckReqBO dycProBaseJdAddressCheckReqBO = new DycProBaseJdAddressCheckReqBO();
            dycProBaseJdAddressCheckReqBO.setProvinceId(Integer.valueOf(contextBO.getAddressBo().getContactProvinceId()));
            dycProBaseJdAddressCheckReqBO.setCityId(Integer.valueOf(contextBO.getAddressBo().getContactCityId()));
            dycProBaseJdAddressCheckReqBO.setCountyId(Integer.valueOf(contextBO.getAddressBo().getContactCountyId()));
            dycProBaseJdAddressCheckReqBO.setTownId(Integer.valueOf(contextBO.getAddressBo().getContactTownId()));
            dycProBaseJdAddressCheckReqBO.setHsn(hsn);
            dycProBaseJdAddressCheckReqBO.setUrl(this.checkAreaUrl);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dycProBaseJdAddressCheckReqBO));
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u8bf7\u6c42\u5730\u5740:{}", (Object)this.checkAreaUrl);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u8bf7\u6c42hsn:{}", (Object)hsn);
            DycProBaseJdAddressCheckRspBO dycProBaseJdAddressCheckRspBO = DycProBaseCallEsbUtil.checkJdAddressInfo((DycProBaseJdAddressCheckReqBO)dycProBaseJdAddressCheckReqBO);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u51fa\u53c2: " + JSON.toJSONString((Object)dycProBaseJdAddressCheckRspBO));
            if (!dycProBaseJdAddressCheckRspBO.getSuccess().booleanValue()) {
                DycProBaseJdAddressQryReqBO dycProBaseJdAddressQryReqBO = new DycProBaseJdAddressQryReqBO();
                dycProBaseJdAddressQryReqBO.setAddress(contextBO.getAddressBo().getContactAddress());
                dycProBaseJdAddressCheckReqBO.setHsn(hsn);
                dycProBaseJdAddressCheckReqBO.setUrl(this.getJDAddressFromAddress);
                DycProBaseJdAddressQryRspBO dycProBaseJdAddressQryRspBO = DycProBaseCallEsbUtil.qryJdAddressInfo((DycProBaseJdAddressQryReqBO)dycProBaseJdAddressQryReqBO);
                if (!dycProBaseJdAddressQryRspBO.getSuccess().booleanValue()) {
                    throw new ZTBusinessException(dycProBaseJdAddressQryRspBO.getResultMessage());
                }
                contextBO.getAddressBo().setContactCountryId(dycProBaseJdAddressQryRspBO.getAddressInfoBO().getCountyId());
                contextBO.getAddressBo().setContactProvinceId(dycProBaseJdAddressQryRspBO.getAddressInfoBO().getProvinceId());
                contextBO.getAddressBo().setContactCityId(dycProBaseJdAddressQryRspBO.getAddressInfoBO().getCityId());
                contextBO.getAddressBo().setContactCountyId(dycProBaseJdAddressQryRspBO.getAddressInfoBO().getCountyId());
                contextBO.getAddressBo().setContactTownId(dycProBaseJdAddressQryRspBO.getAddressInfoBO().getTownId());
            }
        }
    }

    private void verifyParam(DycProSaasOrderCreateOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAddressBo()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010addressBo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceBo()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010invoiceBo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceAddressBo()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010invoiceAddressBo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityBos())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycProSaasOrderCommodityBO sku : reqBO.getCommodityBos()) {
            if (null == sku.getSalePrice()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos.salePrice\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == sku.getPurchaseCount()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos.purchaseCount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (BigDecimal.ZERO.compareTo(sku.getPurchaseCount()) > 0) {
                throw new ZTBusinessException("\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            if (null == sku.getUnitDigit()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos.unitDigit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getIsNoSupllier() || 0 == reqBO.getIsNoSupllier()) {
                if (null == sku.getSpId()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos.spId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != sku.getSkuId()) continue;
                throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos.skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != sku.getAgrItemId()) continue;
            throw new ZTBusinessException("\u5165\u53c2\u3010commodityBos.agrItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

