/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.base.config.thread.SaasThreadPool;
import com.tydic.dyc.mall.order.api.DycUocCancelBargainingService;
import com.tydic.dyc.mall.order.bo.DycUocCancelBargainingContextBO;
import com.tydic.dyc.mall.order.bo.DycUocCancelBargainingReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCancelBargainingRspBO;
import com.tydic.dyc.mall.order.bo.DycUocReceiverBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.UocCancelBargainingService;
import com.tydic.dyc.oc.service.bargaining.UocQryBargainingDetailService;
import com.tydic.dyc.oc.service.bargaining.UocQryBargainingItemService;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocCancelBargainingRspBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailReqBo;
import com.tydic.dyc.oc.service.bargaining.bo.UocQryBargainingDetailRspBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocCancelBargainingService"})
public class DycUocCancelBargainingServiceImpl
implements DycUocCancelBargainingService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCancelBargainingServiceImpl.class);
    @Autowired
    private UocCancelBargainingService uocCancelBargainingService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private UocQryBargainingDetailService uocQryBargainingDetailService;
    @Autowired
    private UocQryBargainingItemService uocQryBargainingItemService;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Value(value="${dealBargainingCancelApply.taskCode:uoc_bargaining_cancel_apply}")
    private String taskCode;
    @Value(value="${dealBargainingNotifySupplier.roleCodesStr:1,2,3}")
    private String roleCodesStr;
    @Autowired
    private SaasThreadPool saasThreadPool;

    @Override
    @PostMapping(value={"cancelBargaining"})
    public DycUocCancelBargainingRspBO cancelBargaining(@RequestBody DycUocCancelBargainingReqBO dycUocCancelBargainingReqBO) {
        this.verifyInputParam(dycUocCancelBargainingReqBO);
        DycUocCancelBargainingContextBO contextBo = new DycUocCancelBargainingContextBO();
        BeanUtils.copyProperties((Object)((Object)dycUocCancelBargainingReqBO), (Object)((Object)contextBo));
        UocCancelBargainingReqBo uocCancelBargainingReqBo = (UocCancelBargainingReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)contextBo)), UocCancelBargainingReqBo.class);
        UocCancelBargainingRspBo uocCancelBargainingRspBo = this.uocCancelBargainingService.cancelBargaining(uocCancelBargainingReqBo);
        if (!"0000".equals(uocCancelBargainingRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u7ec8\u6b62\u5931\u8d25");
        }
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(dycUocCancelBargainingReqBO.getTaskId());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("bargainingId", dycUocCancelBargainingReqBO.getBargainingId());
        variables.put("userId", dycUocCancelBargainingReqBO.getUserId());
        variables.put("userName", dycUocCancelBargainingReqBO.getName());
        variables.put("cancelFlag", "1");
        variables.put("quotationFlag", "0");
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
        UocQryBargainingDetailReqBo qryBargainingDetailReqBo = new UocQryBargainingDetailReqBo();
        qryBargainingDetailReqBo.setBargainingId(dycUocCancelBargainingReqBO.getBargainingId());
        UocQryBargainingDetailRspBo uocQryBargainingDetailRspBo = this.uocQryBargainingDetailService.qryBargainingDetail(qryBargainingDetailReqBo);
        this.sendMessage(dycUocCancelBargainingReqBO, uocQryBargainingDetailRspBo);
        this.pushHaveDone(dycUocCancelBargainingReqBO, uocQryBargainingDetailRspBo);
        return (DycUocCancelBargainingRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)uocCancelBargainingReqBo), DycUocCancelBargainingRspBO.class));
    }

    private void sendMessage(DycUocCancelBargainingReqBO reqBo, UocQryBargainingDetailRspBo uocQryBargainingDetailRspBo) {
        UocBargainingItemPageReqBo itemPageReqBo = new UocBargainingItemPageReqBo();
        itemPageReqBo.setBargainingId(reqBo.getBargainingId());
        itemPageReqBo.setInterfaceType("2");
        itemPageReqBo.setPageNo(-1);
        itemPageReqBo.setPageSize(-1);
        UocBargainingItemPageRspBo itemPageRspBo = this.uocQryBargainingItemService.qryBargainingItemPage(itemPageReqBo);
        AuthGetUserByRoleAndOrgReqBo roleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        roleAndOrgReqBo.setOrgIdWeb(Long.valueOf(Long.parseLong(uocQryBargainingDetailRspBo.getSupId())));
        roleAndOrgReqBo.setRoleCodes(Arrays.asList(this.roleCodesStr));
        log.info("\u89d2\u8272\u673a\u6784\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:" + JSON.toJSONString((Object)roleAndOrgReqBo));
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(roleAndOrgReqBo);
        log.info("\u89d2\u8272\u673a\u6784\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2:" + JSON.toJSONString((Object)userByRoleAndOrg));
        if (CollUtil.isNotEmpty((Collection)userByRoleAndOrg.getRows())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("taskCode", this.taskCode);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("bargainingNo", uocQryBargainingDetailRspBo.getBargainingNo());
            String quotationId = "";
            if (itemPageRspBo.getUocQryQuotationBo().getQuotationId() != null) {
                quotationId = String.valueOf(itemPageRspBo.getUocQryQuotationBo().getQuotationId());
            }
            dataMap.put("quotationId", quotationId);
            map.put("data", dataMap);
            map.put("sendId", 1L);
            map.put("sendName", "admin");
            ArrayList receiverIdList = new ArrayList();
            userByRoleAndOrg.getRows().forEach(x -> {
                DycUocReceiverBo bo1 = new DycUocReceiverBo();
                bo1.setReceiverId(x.getUserId() + "");
                bo1.setReceiverName(x.getCustName());
                bo1.setEMail(x.getCustEmail());
                receiverIdList.add(bo1);
            });
            map.put("receiverIdList", JSON.toJSONString(receiverIdList));
            this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
        } else {
            log.info("\u91c7\u8d2d\u5355\u4f4d-\u4e0b\u5355\u5458\u4e3b\u52a8\u7ec8\u6b62\u8bae\u4ef7,\u6839\u636e\u4f9b\u5e94\u5546\u89d2\u8272\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u4eba\u5458\uff0c\u4e0d\u89e6\u53d1\u901a\u77e5\uff01");
        }
    }

    private void pushHaveDone(DycUocCancelBargainingReqBO reqBo, UocQryBargainingDetailRspBo uocQryBargainingDetailRspBo) {
        if (StringUtils.isEmpty((String)uocQryBargainingDetailRspBo.getBargainingNo()) || "YJ_YBJ".equals(uocQryBargainingDetailRspBo.getBargainingState())) {
            // empty if block
        }
    }

    private void verifyInputParam(DycUocCancelBargainingReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getCancelReason())) {
            throw new ZTBusinessException("\u53d6\u6d88\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBargainingId()) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

