/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocSalOrdeDetailQryFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.api.DycBusiProcessVariableSetFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessVariableSetFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessVariableSetFuncRspBO;
import com.tydic.dyc.atom.pay.api.DycFscPayShouldPayCreateFunction;
import com.tydic.dyc.atom.pay.bo.DycFscPayShouldPayCreateFuncReqBO;
import com.tydic.dyc.atom.pay.bo.DycFscPayShouldPayCreateFuncRspBO;
import com.tydic.dyc.atom.pay.bo.DycFscShouldPayBO;
import com.tydic.dyc.base.constants.UocConstant;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceBySaleOrderService;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService;
import com.tydic.dyc.oc.service.domainservice.UocCalculateSaleOrderFeeService;
import com.tydic.dyc.oc.service.domainservice.UocShouldPayCalculateService;
import com.tydic.dyc.oc.service.domainservice.UocShouldPayCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceBySaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCalculateSaleOrderFeeServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderItemBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCalculateShouldBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateReqBO;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.selfrun.order.api.DycUocAcceptanceDeliveryOrderService;
import com.tydic.dyc.selfrun.order.bo.DycUocAcceptanceDeliveryOrderContextBO;
import com.tydic.dyc.selfrun.order.bo.DycUocAcceptanceDeliveryOrderReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocAcceptanceDeliveryOrderRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocAcceptanceShipOrderBO;
import com.tydic.dyc.umc.service.signcontractapply.DycUmcQuerySupplierListService;
import com.tydic.dyc.umc.service.signcontractapply.bo.DycUmcQuerySupplierListReqBO;
import com.tydic.dyc.umc.service.signcontractapply.bo.DycUmcQuerySupplierListRspBO;
import com.tydic.dyc.umc.service.signcontractapply.bo.SupplierSignContractBO;
import com.tydic.uec.ability.UecEvaluateCreateAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocAcceptanceDeliveryOrderService"})
public class DycUocAcceptanceDeliveryOrderServiceImpl
implements DycUocAcceptanceDeliveryOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocAcceptanceDeliveryOrderServiceImpl.class);
    @Autowired
    private UocArrvalAcceptanceService uocArrvalAcceptanceService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycUmcQuerySupplierListService dycUmcQuerySupplierListAbilityService;
    @Autowired
    private DycBusiProcessVariableSetFunction dycBusiProcessVariableSetFunction;
    @Autowired
    private UocShouldPayCalculateService uocShouldPayCalculateService;
    @Autowired
    private DycFscPayShouldPayCreateFunction dycFscPayShouldPayCreateFunction;
    @Autowired
    private UocShouldPayCreateService uocShouldPayCreateService;
    @Autowired
    private DycUocSalOrdeDetailQryFunction dycUocSalOrdeDetailQryFunction;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Autowired
    private UecEvaluateCreateAbilityService evaluateCreateAbilityService;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpoinUrl;
    @Resource(name="uocSyncPriceProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${uoc.insp.price.sync.tag:8}")
    private String priceSyncTag;
    @Value(value="${uoc.price.sync.topic:UOC_SYNC_PRICE_TOPIC}")
    private String priceSyncTopic;
    @Value(value="${uoc.price.sync.enable:false}")
    private boolean priceSyncEnable;
    @Value(value="${uoc.acceptanceSetBusiProcessVariables:true}")
    private boolean acceptanceSetBusiProcessVariables;
    @Value(value="${uoc.acceptanceDoPushShouldPay:true}")
    private boolean acceptanceDoPushShouldPay;
    @Value(value="${uoc.acceptanceFlowBusiProcess:true}")
    private boolean acceptanceFlowBusiProcess;
    @Value(value="${uoc.acceptanceGetSupplierSignContract:true}")
    private boolean acceptanceGetSupplierSignContract;
    @Value(value="${uoc.acceptanceGetSupplierSignContract:true}")
    private boolean acceptanceAcceptShipOrder;
    @Value(value="${uoc.acceptanceAcceptSaleOrder:false}")
    private boolean acceptanceAcceptSaleOrder;
    @Value(value="${uoc.acceptancePushTodo:true}")
    private boolean acceptancePushTodo;
    @Value(value="${uoc.acceptanceEvaluate:true}")
    private boolean acceptanceEvaluate;
    @Value(value="${uoc.acceptanceVerifyParam:true}")
    private boolean acceptanceVerifyParam;
    @Autowired
    private UocArrvalAcceptanceBySaleOrderService uocArrvalAcceptanceBySaleOrderService;
    @Value(value="${uoc.adjustBudgetExt:false}")
    private boolean adjustBudgetExt;
    @Autowired
    private UocCalculateSaleOrderFeeService uocCalculateSaleOrderFeeService;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Lazy
    @Autowired
    private DycUocAcceptanceDeliveryOrderService dycUocAcceptanceDeliveryOrderService;
    @Value(value="${uoc.agrEvaluateToDoPushFlag:false}")
    private boolean agrEvaluateToDoPushFlag;

    @Override
    @PostMapping(value={"acceptanceDeliveryOrder"})
    public DycUocAcceptanceDeliveryOrderRspBO acceptanceDeliveryOrder(@RequestBody DycUocAcceptanceDeliveryOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        DycUocAcceptanceDeliveryOrderContextBO contextBO = (DycUocAcceptanceDeliveryOrderContextBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocAcceptanceDeliveryOrderContextBO.class);
        this.getSupplierSignContract(contextBO);
        this.acceptShipOrder(contextBO);
        this.acceptSaleOrder(contextBO);
        this.doPushShouldPay(contextBO);
        this.setBusiProcessVariables(contextBO);
        this.flowBusiProcess(contextBO);
        this.invokPrice(contextBO);
        String saleOrderNo = this.adjustBudget(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getShipOrderList())) {
            for (DycUocAcceptanceShipOrderBO dycUocShipOrderInfoBO : reqBO.getShipOrderList()) {
                JSONObject ShipOrderInfo = new JSONObject();
                ShipOrderInfo.put("orderId", (Object)reqBO.getOrderId());
                ShipOrderInfo.put("shipOrderId", (Object)dycUocShipOrderInfoBO.getShipOrderId());
                ShipOrderInfo.put("inspFinish", (Object)reqBO.getInspFinish());
                ShipOrderInfo.put("userId", (Object)reqBO.getUserId());
                this.dycUocAcceptanceDeliveryOrderService.acceptanceDeliveryOrderForTodo(ShipOrderInfo);
            }
        }
        return new DycUocAcceptanceDeliveryOrderRspBO();
    }

    @Override
    @PostMapping(value={"acceptanceDeliveryOrderForTodo"})
    public DycUocAcceptanceDeliveryOrderRspBO acceptanceDeliveryOrderForTodo(@RequestBody JSONObject shipOrderInfo) {
        return new DycUocAcceptanceDeliveryOrderRspBO();
    }

    private String adjustBudget(DycUocAcceptanceDeliveryOrderReqBO reqBO) {
        String saleOrderNo = null;
        if (this.adjustBudgetExt && reqBO.getInspFinish().booleanValue()) {
            UocCalculateSaleOrderFeeServiceReqBo serviceReqBo = new UocCalculateSaleOrderFeeServiceReqBo();
            UocSaleOrderBO uocSaleOrderBO = new UocSaleOrderBO();
            uocSaleOrderBO.setOrderId(reqBO.getOrderId().toString());
            uocSaleOrderBO.setSaleOrderId(reqBO.getSaleOrderId());
            serviceReqBo.setOrderId(Long.valueOf(uocSaleOrderBO.getOrderId()));
            serviceReqBo.setSaleOrderId(uocSaleOrderBO.getSaleOrderId());
            UocCalculateSaleOrderFeeServiceRspBo serviceRspBo = this.uocCalculateSaleOrderFeeService.calculate(serviceReqBo);
            Map<Long, BigDecimal> realCountMap = serviceRspBo.getSaleItemList().stream().collect(Collectors.toMap(UocSaleOrderItemBO::getSaleOrderItemId, UocSaleOrderItemBO::getRealCount));
            UocGetSaleOrderDetailServiceReqBo saleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
            saleOrderDetailServiceReqBo.setSaleOrderId(uocSaleOrderBO.getSaleOrderId());
            saleOrderDetailServiceReqBo.setOrderId(Long.valueOf(uocSaleOrderBO.getOrderId()));
            UocGetSaleOrderDetailServiceRspBo salOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(saleOrderDetailServiceReqBo);
            if (!"0000".equals(salOrderDetail.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u8be6\u60c5\u5355\u62a5\u9519\uff1a" + salOrderDetail.getRespDesc());
            }
            saleOrderNo = salOrderDetail.getSaleOrderNo();
            for (UocGetSaleOrderDetailServiceRspItemBo each : salOrderDetail.getSaleOrderDetailServiceRspItemBoList()) {
                each.setPurchaseCount(realCountMap.get(each.getSaleOrderItemId()));
                each.setPurchaseFee(each.getPurchasePrice().multiply(each.getPurchaseCount()));
            }
        }
        return saleOrderNo;
    }

    private void doPushShouldPay(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.acceptanceDoPushShouldPay) {
            UocShouldPayCalculateReqBO uocShouldPayCalculateReqBO = new UocShouldPayCalculateReqBO();
            uocShouldPayCalculateReqBO.setObjId(contextBO.getInspOrderId());
            uocShouldPayCalculateReqBO.setOrderId(contextBO.getOrderId());
            uocShouldPayCalculateReqBO.setShouldPayType(UocConstant.SHOULD_PAY_TYPE.ACOUNT_DAY);
            uocShouldPayCalculateReqBO.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
            uocShouldPayCalculateReqBO.setPayNodeRule(UocConstant.PAY_NODE_RULE.ACCEPTANCE_DECLIVERY);
            UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncRspBO = this.uocShouldPayCalculateService.calculate(uocShouldPayCalculateReqBO);
            if (!CollectionUtils.isEmpty((Collection)dycUocCreateOrderShouldPayFuncRspBO.getShouldPayList())) {
                DycFscPayShouldPayCreateFuncReqBO dycFscPayShouldPayCreateFuncReqBO = this.fillFscShouldPayCreateAttr(dycUocCreateOrderShouldPayFuncRspBO);
                DycFscPayShouldPayCreateFuncRspBO dycFscPayShouldPayCreateFuncRspBO = this.dycFscPayShouldPayCreateFunction.dealShouldPayCreate(dycFscPayShouldPayCreateFuncReqBO);
                UocShouldPayCreateReqBO dycUocShouldPayCreateFuncReqBO = this.fillUocShouldPayAttr(dycUocCreateOrderShouldPayFuncRspBO, dycFscPayShouldPayCreateFuncRspBO);
                dycUocShouldPayCreateFuncReqBO.setObjectType(UocDicConstant.OBJ_TYPE.INSPECTION);
                this.uocShouldPayCreateService.create(dycUocShouldPayCreateFuncReqBO);
            }
            UocShouldPayCalculateReqBO uocShouldPayCalculateForConstraintReqBO = new UocShouldPayCalculateReqBO();
            uocShouldPayCalculateForConstraintReqBO.setObjId(contextBO.getInspOrderId());
            uocShouldPayCalculateForConstraintReqBO.setOrderId(contextBO.getOrderId());
            uocShouldPayCalculateForConstraintReqBO.setShouldPayType(UocConstant.SHOULD_PAY_TYPE.INSP);
            uocShouldPayCalculateForConstraintReqBO.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
            UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncForConstraintRspBO = this.uocShouldPayCalculateService.calculate(uocShouldPayCalculateForConstraintReqBO);
            if (!CollectionUtils.isEmpty((Collection)dycUocCreateOrderShouldPayFuncForConstraintRspBO.getShouldPayList())) {
                DycFscPayShouldPayCreateFuncReqBO dycFscPayShouldPayCreateFuncReqBO = this.fillFscShouldPayCreateAttr(dycUocCreateOrderShouldPayFuncForConstraintRspBO);
                DycFscPayShouldPayCreateFuncRspBO dycFscPayShouldPayCreateFuncRspBO = this.dycFscPayShouldPayCreateFunction.dealShouldPayCreate(dycFscPayShouldPayCreateFuncReqBO);
                UocShouldPayCreateReqBO dycUocShouldPayCreateFuncReqBO = this.fillUocShouldPayAttr(dycUocCreateOrderShouldPayFuncForConstraintRspBO, dycFscPayShouldPayCreateFuncRspBO);
                dycUocShouldPayCreateFuncReqBO.setObjectType(UocDicConstant.OBJ_TYPE.INSPECTION);
                this.uocShouldPayCreateService.create(dycUocShouldPayCreateFuncReqBO);
            }
        }
    }

    private DycFscPayShouldPayCreateFuncReqBO fillFscShouldPayCreateAttr(UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncRspBO) {
        ArrayList<DycFscShouldPayBO> fscShouldPayBOS = new ArrayList<DycFscShouldPayBO>();
        for (UocShouldPayCalculateShouldBO item : dycUocCreateOrderShouldPayFuncRspBO.getShouldPayList()) {
            DycFscShouldPayBO dycFscShouldPayBO = new DycFscShouldPayBO();
            dycFscShouldPayBO.setPayType(item.getPayType());
            dycFscShouldPayBO.setShouldPayType(item.getShouldPayType());
            dycFscShouldPayBO.setObjectId(item.getObjectId());
            dycFscShouldPayBO.setOrderId(item.getOrderId());
            dycFscShouldPayBO.setSaleVoucherId(item.getSaleOrderId());
            dycFscShouldPayBO.setObjectType(item.getObjectTypeReturn());
            dycFscShouldPayBO.setObjectNo(item.getObjectNo());
            dycFscShouldPayBO.setShouldPayAmount(item.getShouldPayAmount());
            dycFscShouldPayBO.setShouldPayDate(item.getShouldPayDate());
            dycFscShouldPayBO.setPayerId(item.getPayerId());
            dycFscShouldPayBO.setPayerName(item.getPayerName());
            dycFscShouldPayBO.setPayeeId(item.getPayeeId());
            dycFscShouldPayBO.setPayeeName(item.getPayeeName());
            dycFscShouldPayBO.setContractId(item.getContractId());
            dycFscShouldPayBO.setContractNo(item.getContractNo());
            dycFscShouldPayBO.setPenaltyRatio(item.getPenaltyRatio());
            fscShouldPayBOS.add(dycFscShouldPayBO);
        }
        DycFscPayShouldPayCreateFuncReqBO dycFscPayShouldPayCreateFuncReqBO = new DycFscPayShouldPayCreateFuncReqBO();
        dycFscPayShouldPayCreateFuncReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        return dycFscPayShouldPayCreateFuncReqBO;
    }

    private UocShouldPayCreateReqBO fillUocShouldPayAttr(UocShouldPayCalculateRspBO dycUocCreateOrderShouldPayFuncRspBO, DycFscPayShouldPayCreateFuncRspBO dycFscPayShouldPayCreateFuncRspBO) {
        HashMap map = new HashMap();
        dycFscPayShouldPayCreateFuncRspBO.getFscShouldPayRspBOs().forEach(item -> map.put(item.getPayerId().toString() + item.getPayeeId().toString(), item.getShouldPayId()));
        ArrayList<UocShouldPayCreateBo> uocShouldPayCreateBoList = new ArrayList<UocShouldPayCreateBo>();
        for (UocShouldPayCalculateShouldBO item2 : dycUocCreateOrderShouldPayFuncRspBO.getShouldPayList()) {
            UocShouldPayCreateBo dycUocShouldPayCreateFuncBO = (UocShouldPayCreateBo)JUtil.js((Object)item2, UocShouldPayCreateBo.class);
            dycUocShouldPayCreateFuncBO.setFscShouldPayId((Long)map.get(item2.getPayerId().toString() + item2.getPayeeId().toString()));
            uocShouldPayCreateBoList.add(dycUocShouldPayCreateFuncBO);
        }
        UocShouldPayCreateReqBO dycUocShouldPayCreateFuncReqBO = new UocShouldPayCreateReqBO();
        dycUocShouldPayCreateFuncReqBO.setUocShouldPayCreateBoList(uocShouldPayCreateBoList);
        return dycUocShouldPayCreateFuncReqBO;
    }

    private void flowBusiProcess(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.acceptanceFlowBusiProcess) {
            Map<Long, DycUocAcceptanceShipOrderBO> tempMap = contextBO.getShipOrderList().stream().collect(Collectors.toMap(DycUocAcceptanceShipOrderBO::getShipOrderId, dycUocAcceptanceShipOrderBO -> dycUocAcceptanceShipOrderBO));
            contextBO.getShipOrderInspStateMap().entrySet().forEach(entry -> {
                if (contextBO.getInspFinish().booleanValue() || ((Boolean)entry.getValue()).booleanValue()) {
                    DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
                    flowFuncReqBO.setTaskId(((DycUocAcceptanceShipOrderBO)tempMap.get(entry.getKey())).getTaskId());
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put("userId", contextBO.getUserId());
                    variables.put("userName", contextBO.getName());
                    flowFuncReqBO.setVariables(variables);
                    DycBusiProcessFlowFuncRspBO flowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
                    if (!"0000".equals(flowFuncRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u9a8c\u6536\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + flowFuncRspBO.getRespDesc());
                    }
                }
            });
        }
    }

    private void setBusiProcessVariables(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.acceptanceSetBusiProcessVariables && contextBO.getClosePennyDiff().booleanValue()) {
            DycBusiProcessVariableSetFuncReqBO dycBusiProcessVariableSetFuncReqBO = new DycBusiProcessVariableSetFuncReqBO();
            dycBusiProcessVariableSetFuncReqBO.setProcInstId(contextBO.getProcInstId());
            HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
            variableMap.put("shipCompleteflag", 1);
            dycBusiProcessVariableSetFuncReqBO.setVariableMap(variableMap);
            DycBusiProcessVariableSetFuncRspBO dycBusiProcessVariableSetFuncRspBO = this.dycBusiProcessVariableSetFunction.setProcessVariable(dycBusiProcessVariableSetFuncReqBO);
            if (!"0000".equals(dycBusiProcessVariableSetFuncRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8bbe\u7f6e\u6d41\u7a0b\u53c2\u6570\u5931\u8d25\uff1a" + dycBusiProcessVariableSetFuncRspBO.getRespDesc());
            }
        }
    }

    private void acceptShipOrder(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.acceptanceAcceptShipOrder) {
            UocArrvalAcceptanceReqBo uocArrvalAcceptanceReqBo = (UocArrvalAcceptanceReqBo)JSON.parseObject((String)JSON.toJSONString((Object)contextBO), UocArrvalAcceptanceReqBo.class);
            uocArrvalAcceptanceReqBo.setJsonObj(JSON.parseObject((String)JSON.toJSONString((Object)contextBO.getSupplierSignContractInfo())));
            UocArrvalAcceptanceRspBo uocArrvalAcceptanceRspBo = this.uocArrvalAcceptanceService.dealArrvalAcceptance(uocArrvalAcceptanceReqBo);
            if ("0000".equals(uocArrvalAcceptanceRspBo.getRespCode())) {
                contextBO.setShipOrderInspStateMap(uocArrvalAcceptanceRspBo.getShipOrderInspStateMap());
                contextBO.setInspOrderId(uocArrvalAcceptanceRspBo.getInspOrderId());
            } else {
                throw new ZTBusinessException("\u53d1\u8d27\u5355\u9a8c\u6536\u5931\u8d25\uff1a" + uocArrvalAcceptanceRspBo.getRespDesc());
            }
        }
    }

    private void acceptSaleOrder(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.acceptanceAcceptSaleOrder) {
            UocArrvalAcceptanceBySaleOrderServiceReqBo uocArrvalAcceptanceReqBo = (UocArrvalAcceptanceBySaleOrderServiceReqBo)JSON.parseObject((String)JSON.toJSONString((Object)contextBO), UocArrvalAcceptanceBySaleOrderServiceReqBo.class);
            uocArrvalAcceptanceReqBo.setJsonObj(JSON.parseObject((String)JSON.toJSONString((Object)contextBO.getSupplierSignContractInfo())));
            UocArrvalAcceptanceBySaleOrderRspBo uocArrvalAcceptanceRspBo = this.uocArrvalAcceptanceBySaleOrderService.dealArrvalAcceptance(uocArrvalAcceptanceReqBo);
            if ("0000".equals(uocArrvalAcceptanceRspBo.getRespCode())) {
                contextBO.setShipOrderInspStateMap(uocArrvalAcceptanceRspBo.getShipOrderInspStateMap());
                contextBO.setInspOrderId(uocArrvalAcceptanceRspBo.getInspOrderId());
            } else {
                throw new ZTBusinessException("\u9500\u552e\u5355\u9a8c\u6536\u5931\u8d25\uff1a" + uocArrvalAcceptanceRspBo.getRespDesc());
            }
        }
    }

    private void getSupplierSignContract(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.acceptanceGetSupplierSignContract) {
            DycUmcQuerySupplierListReqBO dycUmcQuerySupplierListAbilityReqBO = new DycUmcQuerySupplierListReqBO();
            dycUmcQuerySupplierListAbilityReqBO.setSupplierIds(Collections.singletonList(contextBO.getSupplierId()));
            DycUmcQuerySupplierListRspBO dycUmcQuerySupplierListAbilityRspBO = this.dycUmcQuerySupplierListAbilityService.querySupplierList(dycUmcQuerySupplierListAbilityReqBO);
            if ("0000".equals(dycUmcQuerySupplierListAbilityRspBO.getRespCode())) {
                if (!CollectionUtils.isEmpty((Collection)dycUmcQuerySupplierListAbilityRspBO.getSignContractBOS())) {
                    contextBO.setSupplierSignContractInfo((SupplierSignContractBO)dycUmcQuerySupplierListAbilityRspBO.getSignContractBOS().get(0));
                }
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u7b7e\u7ea6\u4fe1\u606f\u5931\u8d25\uff1a" + dycUmcQuerySupplierListAbilityRspBO.getRespDesc());
            }
        }
    }

    private void verifyParam(DycUocAcceptanceDeliveryOrderReqBO reqBO) {
        if (this.acceptanceVerifyParam) {
            if (null == reqBO) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getOrderId()) {
                throw new ZTBusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getSaleOrderId()) {
                throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getClosePennyDiff()) {
                throw new ZTBusinessException("\u662f\u5426\u5173\u95ed\u5c3e\u5dee\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getSupplierId()) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getUserId()) {
                throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getName())) {
                throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void invokPrice(DycUocAcceptanceDeliveryOrderContextBO contextBO) {
        if (this.priceSyncEnable) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("inspOrderId", (Object)contextBO.getInspOrderId());
            jsonObject.put("saleOrderId", (Object)contextBO.getSaleOrderId());
            jsonObject.put("orderId", (Object)contextBO.getOrderId());
            log.info("\u7535\u5546\u9a8c\u6536\u8c03\u7528\u4e00\u7269\u4e00\u7801\u5f00\u59cb");
            this.proxyMessageProducer.send(new ProxyMessage(this.priceSyncTopic, this.priceSyncTag, JSON.toJSONString((Object)jsonObject)));
        }
    }
}

