/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocSalOrdeDetailQryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.estore.api.DycUocDsAcceptanceFunction;
import com.tydic.dyc.atom.estore.bo.DycUocDsAcceptanceFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocDsAcceptanceFuncRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocEcArrvalAcceptanceService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.UocQryOrderTaskInstanceListService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocAutoInspExpireOrderService;
import com.tydic.dyc.selfrun.order.bo.DycUocAutoInspExpireOrderReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocAutoInspExpireOrderRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocAutoInspExpireOrderService"})
public class DycUocAutoInspExpireOrderServiceImpl
implements DycUocAutoInspExpireOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocAutoInspExpireOrderServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocEcArrvalAcceptanceService uocEcArrvalAcceptanceService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private DycUocDsAcceptanceFunction dycUocDsAcceptanceFunction;
    @Autowired
    private UocQryOrderTaskInstanceListService uocQryOrderTaskInstanceListService;
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Autowired
    private DycUocSalOrdeDetailQryFunction dycUocSalOrdeDetailQryFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Lazy
    @Autowired
    private DycUocAutoInspExpireOrderService dycUocAutoInspExpireOrderService;

    @Override
    @PostMapping(value={"dealAutoInspExpireOrder"})
    public DycUocAutoInspExpireOrderRspBO dealAutoInspExpireOrder(@RequestBody DycUocAutoInspExpireOrderReqBO reqBO) {
        log.info("\u81ea\u52a8\u9a8c\u6536\u670d\u52a1\u5165\u53c2\uff1a", (Object)reqBO.toString());
        DycUocAutoInspExpireOrderRspBO rspBO = new DycUocAutoInspExpireOrderRspBO();
        UocProOrderEffectiveListPageQueryReqBo pageQueryReqBo = new UocProOrderEffectiveListPageQueryReqBo();
        pageQueryReqBo.setBusinessTypeCode(UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString());
        pageQueryReqBo.setEffectiveCode("4");
        UocProOrderEffectiveListPageQueryRspBo uocProOrderEffectiveListPageQueryRspBo = this.uocProOrderEffectivePageQueryService.queryOrderEffectiveListPage(pageQueryReqBo);
        Long maxAging = uocProOrderEffectiveListPageQueryRspBo.getRows().stream().max(Comparator.comparingLong(UocProOrderEffectiveInfoBo::getAging)).map(UocProOrderEffectiveInfoBo::getAging).orElse(0L);
        Map<String, Long> effectiveMap = uocProOrderEffectiveListPageQueryRspBo.getRows().stream().collect(Collectors.toMap(UocProOrderEffectiveInfoBo::getSupplierNo, UocProOrderEffectiveInfoBo::getAging));
        DycUocSalOrderListQryReqBO salOrderListQryReqBO = new DycUocSalOrderListQryReqBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycUocSalOrderListQryRspBO qryRspBO = new DycUocSalOrderListQryRspBO();
        salOrderListQryReqBO.setOrderSourceList(Arrays.asList(UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString()));
        salOrderListQryReqBO.setSaleOrderStates(Arrays.asList("XS_DH_DH"));
        salOrderListQryReqBO.setIsAfterServingFlag(UocDicConstant.IS_AFTER_SERVING_FLAG.NO);
        salOrderListQryReqBO.setIsAllAfteredFlag(UocDicConstant.IS_ALL_AFTERED_FLAG.NO);
        LocalDate currentDate = LocalDate.now();
        LocalTime midnight = LocalTime.MIDNIGHT;
        LocalDateTime now = LocalDateTime.of(currentDate, midnight);
        LocalDateTime autoInspTime = now.minus(maxAging, ChronoUnit.MILLIS);
        LocalDateTime autoInspOneDayAgo = autoInspTime.minus(1L, ChronoUnit.DAYS);
        salOrderListQryReqBO.setAutoInspOneDayTime(Date.from(autoInspOneDayAgo.atZone(ZoneId.systemDefault()).toInstant()));
        queryFuncReqBO.setReqParams(JSON.parseObject((String)JSON.toJSONString((Object)((Object)salOrderListQryReqBO))).toJSONString());
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
        qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        for (int i = 1; i <= total; ++i) {
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            salOrderListQryReqBO.setPageNo(i);
            queryFuncReqBO.setReqParams(JSON.parseObject((String)JSON.toJSONString((Object)((Object)salOrderListQryReqBO))).toJSONString());
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
            List<DycUocSaleOrderInfoBO> saleOrderInfoBOList = qryRspBO.getRows();
            saleOrderInfoBOList = saleOrderInfoBOList.stream().filter(item -> {
                log.info("\u8ba2\u5355{}\u7684\u5230\u8d27\u65f6\u95f4\u4e3a{}", (Object)item.getSaleOrderNo(), (Object)item.getLastArriveTime());
                Long nowMills = System.currentTimeMillis();
                if (ObjectUtil.isEmpty((Object)item.getLastArriveTime())) {
                    return false;
                }
                Long aging = (Long)effectiveMap.get(item.getSupId());
                if (ObjectUtil.isEmpty((Object)aging)) {
                    aging = (Long)effectiveMap.get("0");
                }
                long timeDiff = aging + item.getLastArriveTime().getTime() - nowMills;
                log.info("\u65f6\u95f4\u5dee\uff1a{}", (Object)timeDiff);
                if (timeDiff >= 0L) {
                    return false;
                }
                log.info("\u8ba2\u5355\uff1a{} +  \u5230\u8d27\u65f6\u95f4: + {} + \u8d85\u65f6", (Object)item.getSaleOrderNo(), (Object)item.getLastArriveTime());
                return true;
            }).collect(Collectors.toList());
            for (DycUocSaleOrderInfoBO saleOrderInfoBO : saleOrderInfoBOList) {
                log.info("\u8ba2\u5355{}\u81ea\u52a8\u9a8c\u6536", (Object)saleOrderInfoBO.getSaleOrderNo());
                DycUocDsAcceptanceFuncReqBO dycUocDsAcceptanceFuncReqBO = new DycUocDsAcceptanceFuncReqBO();
                dycUocDsAcceptanceFuncReqBO.setOrderId(saleOrderInfoBO.getOrderId());
                dycUocDsAcceptanceFuncReqBO.setSaleOrderNoExt(saleOrderInfoBO.getOutOrderId());
                dycUocDsAcceptanceFuncReqBO.setPurchaseId(Long.valueOf(saleOrderInfoBO.getPurchaseOrgId()));
                dycUocDsAcceptanceFuncReqBO.setSupplierId(Long.valueOf(saleOrderInfoBO.getSupId()));
                dycUocDsAcceptanceFuncReqBO.setSaleOrderId(saleOrderInfoBO.getSaleOrderId());
                try {
                    if (!DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(saleOrderInfoBO.getSupId())) {
                        DycUocDsAcceptanceFuncRspBO dycUocDsAcceptanceFuncRspBO = this.dycUocDsAcceptanceFunction.dealDsAcceptance(dycUocDsAcceptanceFuncReqBO);
                    }
                    UocEcArrvalAcceptanceReqBo allAcceptanceSubmitFuncReqBO = new UocEcArrvalAcceptanceReqBo();
                    allAcceptanceSubmitFuncReqBO.setSaleOrderId(saleOrderInfoBO.getSaleOrderId());
                    allAcceptanceSubmitFuncReqBO.setOrderId(saleOrderInfoBO.getOrderId());
                    allAcceptanceSubmitFuncReqBO.setTraceId(reqBO.getTraceId());
                    allAcceptanceSubmitFuncReqBO.setUserId(Long.valueOf(1L));
                    allAcceptanceSubmitFuncReqBO.setName("admin");
                    allAcceptanceSubmitFuncReqBO.setTaskId(saleOrderInfoBO.getBusiTaskInstBos().get(0).getTaskId());
                    UocEcArrvalAcceptanceRspBo uocEcArrvalAcceptanceRspBo = this.uocEcArrvalAcceptanceService.dealEcArrvalAcceptance(allAcceptanceSubmitFuncReqBO);
                    if (!"0000".equals(uocEcArrvalAcceptanceRspBo.getRespCode())) {
                        log.info("\u8ba2\u5355{}\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a{}", (Object)saleOrderInfoBO.getSaleOrderNo(), (Object)uocEcArrvalAcceptanceRspBo.getRespDesc());
                        continue;
                    }
                    DycBusiProcessFlowFuncReqBO flowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
                    flowFuncReqBO.setTaskId(saleOrderInfoBO.getBusiTaskInstBos().get(0).getTaskId());
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("userId", "1");
                    variables.put("userName", "admin");
                    variables.put("orderAcceptanceFlag", "1");
                    flowFuncReqBO.setVariables(variables);
                    DycBusiProcessFlowFuncRspBO flowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(flowFuncReqBO);
                    if (!CollectionUtils.isEmpty(saleOrderInfoBO.getShipOrderIdList())) {
                        for (String shipOrderId : saleOrderInfoBO.getShipOrderIdList()) {
                            try {
                                JSONObject shipOrderInfo = new JSONObject();
                                shipOrderInfo.put("orderId", (Object)saleOrderInfoBO.getOrderId());
                                shipOrderInfo.put("shipOrderId", (Object)Long.parseLong(shipOrderId));
                                shipOrderInfo.put("userId", (Object)1L);
                                this.dycUocAutoInspExpireOrderService.dealAutoInspExpireOrderForTodoShipInfo(shipOrderInfo);
                            }
                            catch (Exception e) {
                                log.error("\u81ea\u52a8\u9a8c\u6536\u53d1\u9001\u5f85\u9a8c\u6536\u5df2\u529e\u62a5\u9519\uff1a", (Throwable)e);
                            }
                        }
                    }
                    if (ObjectUtil.isNotEmpty(saleOrderInfoBO.getShipOrderIdList())) {
                        try {
                            JSONObject saleOrderInfo = new JSONObject();
                            saleOrderInfo.put("orderId", (Object)saleOrderInfoBO.getOrderId());
                            saleOrderInfo.put("saleOrderId", (Object)saleOrderInfoBO.getSaleOrderId());
                            saleOrderInfo.put("userId", (Object)1L);
                            this.dycUocAutoInspExpireOrderService.dealAutoInspExpireOrderForTodoSaleInfo(saleOrderInfo);
                        }
                        catch (Exception e) {
                            log.error("\u81ea\u52a8\u9a8c\u6536\u53d1\u8bc4\u4ef7\u901a\u77e5\u5f85\u529e\u62a5\u9519\uff1a", (Throwable)e);
                        }
                    }
                    this.buryPoint(saleOrderInfoBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return rspBO;
    }

    @Override
    @PostMapping(value={"dealAutoInspExpireOrderForTodoShipInfo"})
    public DycUocAutoInspExpireOrderRspBO dealAutoInspExpireOrderForTodoShipInfo(@RequestBody JSONObject shipOrderInfo) {
        return new DycUocAutoInspExpireOrderRspBO();
    }

    @Override
    @PostMapping(value={"dealAutoInspExpireOrderForTodoSaleInfo"})
    public DycUocAutoInspExpireOrderRspBO dealAutoInspExpireOrderForTodoSaleInfo(@RequestBody JSONObject saleOrderInfo) {
        return new DycUocAutoInspExpireOrderRspBO();
    }

    private void buryPoint(DycUocSaleOrderInfoBO bo) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        List<String> inspOrderId = bo.getInspOrderId();
        for (String string : inspOrderId) {
            jsonObject.put("inspOrderId", (Object)string);
            jsonObject.put("orderId", (Object)bo.getOrderId());
            list.add(jsonObject);
        }
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        for (JSONObject j : list) {
            DycBuriedPointCallFuncBo bo1 = new DycBuriedPointCallFuncBo();
            bo1.setIdent("ADD");
            bo1.setDycBusiCode("acceptanceOrderSync");
            bo1.setDycCenterCode("UOC");
            bo1.setData((Object)j);
            buildsList.add(bo1);
        }
        JSONObject jSONObject = new JSONObject();
        ArrayList<JSONObject> list2 = new ArrayList<JSONObject>();
        List<String> ShipOrderId = bo.getShipOrderIdList();
        for (String b : ShipOrderId) {
            jSONObject.put("shipOrderId", (Object)b);
            jSONObject.put("orderId", (Object)bo.getOrderId());
            list2.add(jSONObject);
        }
        for (JSONObject j : list2) {
            DycBuriedPointCallFuncBo bo2 = new DycBuriedPointCallFuncBo();
            bo2.setIdent("UPDATA");
            bo2.setDycBusiCode("sendOrderSync");
            bo2.setDycCenterCode("UOC");
            bo2.setData((Object)j);
            buildsList.add(bo2);
        }
        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put("saleOrderId", (Object)bo.getSaleOrderId());
        jsonObject3.put("orderId", (Object)bo.getOrderId());
        DycBuriedPointCallFuncBo bo3 = new DycBuriedPointCallFuncBo();
        bo3.setIdent("UPDATA");
        bo3.setDycBusiCode("saleOrderSync");
        bo3.setDycCenterCode("UOC");
        bo3.setData((Object)jsonObject3);
        buildsList.add(bo3);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u81ea\u52a8\u5230\u8d27\u9a8c\u6536,\u65b0\u589e\u9a8c\u6536\u5355\u8fdb\u884c\u57cb\u70b9\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }

    private void sendHaveDone(DycUocSaleOrderInfoBO dycUocSaleOrderInfoBO) {
    }
}

