/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocSalOrdeDetailQryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocDeliverCommodityService;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverCommodityContextBO;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverCommodityReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverCommodityRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverDetailBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocDeliverCommodityService"})
public class DycUocDeliverCommodityServiceImpl
implements DycUocDeliverCommodityService {
    private static final Logger log = LoggerFactory.getLogger(DycUocDeliverCommodityServiceImpl.class);
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private UocSaleShipOrderService uocSaleShipOrderService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;
    @Autowired
    private DycUocSalOrdeDetailQryFunction dycUocSalOrdeDetailQryFunction;

    @Override
    @PostMapping(value={"deliverCommodity"})
    public DycUocDeliverCommodityRspBO deliverCommodity(@RequestBody DycUocDeliverCommodityReqBO reqBO) {
        this.verifyParam(reqBO);
        DycUocDeliverCommodityContextBO contextBO = (DycUocDeliverCommodityContextBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocDeliverCommodityContextBO.class));
        this.createShipOrder(contextBO);
        this.flowBusiProcess(contextBO);
        this.buryPoint(contextBO);
        DycUocDeliverCommodityRspBO rspBO = new DycUocDeliverCommodityRspBO();
        rspBO.setShipOrderId(contextBO.getShipOrderId());
        return rspBO;
    }

    private void createShipOrder(DycUocDeliverCommodityContextBO contextBO) {
        UocSaleShipOrderReqBo uocSaleShipOrderReqBo = (UocSaleShipOrderReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contextBO)), UocSaleShipOrderReqBo.class);
        UocSaleShipOrderRspBo uocSaleShipOrderRspBo = this.uocSaleShipOrderService.dealImplShipOrder(uocSaleShipOrderReqBo);
        if (!"0000".equals(uocSaleShipOrderRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25\uff1a" + uocSaleShipOrderRspBo.getRespDesc());
        }
        contextBO.setShipOrderId(uocSaleShipOrderRspBo.getShipOrderId());
        contextBO.setFinish(uocSaleShipOrderRspBo.getFinish());
        contextBO.setShipOrderNo(uocSaleShipOrderRspBo.getShipOrderNo());
    }

    private void flowBusiProcess(DycUocDeliverCommodityContextBO contextBO) {
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(contextBO.getTaskId());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("shipOrderId", contextBO.getShipOrderId());
        variables.put("shipStartflag", 1);
        variables.put("needArrivalProcess", 1);
        variables.put("userId", contextBO.getUserId());
        variables.put("userName", contextBO.getName());
        variables.put("saleOrderId", contextBO.getSaleOrderId());
        variables.put("saleOrderNo", contextBO.getSaleOrderNo());
        variables.put("shipOrderNo", contextBO.getShipOrderNo());
        variables.put("arrivalDate", contextBO.getEstimateArrivalTime());
        variables.put("purUserId", contextBO.getPurUserId());
        variables.put("supId", contextBO.getSupId());
        if (contextBO.getFinish().booleanValue()) {
            variables.put("shipCompleteflag", 1);
        }
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u53d1\u8d27\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private void verifyParam(DycUocDeliverCommodityReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1id\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getShipCompanyNo())) {
            throw new ZTBusinessException("\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getShipName())) {
            throw new ZTBusinessException("\u53d1\u8d27\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getShipPhone())) {
            throw new ZTBusinessException("\u53d1\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShipTime()) {
            throw new ZTBusinessException("\u53d1\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBO.getEstimateArrivalTime()) {
            throw new ZTBusinessException("\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getShipOrderItemBoList())) {
            throw new ZTBusinessException("\u53d1\u8d27\u660e\u7ec6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty(reqBO.getShipOrderItemBoList())) {
            for (DycUocDeliverDetailBO dycUocDeliverDetailBO : reqBO.getShipOrderItemBoList()) {
                if (null == dycUocDeliverDetailBO.getSendCount()) {
                    throw new ZTBusinessException("\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
                }
                if (dycUocDeliverDetailBO.getSendCount().compareTo(BigDecimal.ZERO) != 0) continue;
                throw new ZTBusinessException("\u53d1\u8d27\u6570\u91cf\u4e3a0");
            }
        }
    }

    private void buryPoint(DycUocDeliverCommodityContextBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderId", (Object)contextBO.getOrderId());
        jsonObject.put("shipOrderId", (Object)contextBO.getShipOrderId());
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
        bo.setIdent("ADD");
        bo.setDycBusiCode("sendOrderSync");
        bo.setDycCenterCode("UOC");
        bo.setData((Object)jsonObject);
        buildsList.add(bo);
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("saleOrderId", (Object)contextBO.getSaleOrderId());
        jsonObject1.put("orderId", (Object)contextBO.getOrderId());
        DycBuriedPointCallFuncBo bo1 = new DycBuriedPointCallFuncBo();
        bo1.setIdent("UPDATA");
        bo1.setDycBusiCode("saleOrderSync");
        bo1.setDycCenterCode("UOC");
        bo1.setData((Object)jsonObject1);
        buildsList.add(bo1);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u65b0\u589e\u53d1\u8d27\u5355,\u53d8\u66f4\u9500\u552e\u5355\u540e\u8fdb\u884c\u57cb\u70b9\uff08\u65b0\u589e\uff09\uff09\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }
}

