/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.selfrun.order.api.DycUocOverTimeToArrivalRegisterService;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliveryOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOverTimeToArrivalRegisterReqBo;
import com.tydic.dyc.selfrun.order.bo.DycUocOverTimeToArrivalRegisterRspBo;
import com.tydic.dyc.selfrun.order.bo.DycUocQryDeliveryOrderListReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocQryDeliveryOrderListRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocOverTimeToArrivalRegisterService"})
public class DycUocOverTimeToArrivalRegisterServiceImpl
implements DycUocOverTimeToArrivalRegisterService {
    private static final Logger log = LoggerFactory.getLogger(DycUocOverTimeToArrivalRegisterServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Lazy
    @Autowired
    private DycUocOverTimeToArrivalRegisterService dycUocOverTimeToArrivalRegisterService;

    @Override
    @PostMapping(value={"dealOverTimeArrivalRegister"})
    public DycUocOverTimeToArrivalRegisterRspBo dealOverTimeArrivalRegister(@RequestBody DycUocOverTimeToArrivalRegisterReqBo reqBo) {
        log.info("\u672a\u5230\u8d27\u767b\u8bb0\u5904\u7406\u5165\u53c2" + reqBo.getShardingParameter());
        List<DycUocDeliveryOrderInfoBO> dycUocShipOrderInfoBOS = this.qryShipOrderList(reqBo.getShardingParameter());
        for (DycUocDeliveryOrderInfoBO dycUocShipOrderInfoBO : dycUocShipOrderInfoBOS) {
            JSONObject ShipOrderInfo = new JSONObject();
            ShipOrderInfo.put("orderId", (Object)dycUocShipOrderInfoBO.getOrderId());
            ShipOrderInfo.put("shipOrderId", (Object)dycUocShipOrderInfoBO.getDeliveryOrderId());
            ShipOrderInfo.put("shipTime", (Object)reqBo.getShardingParameter());
            ShipOrderInfo.put("userId", (Object)1L);
            this.dycUocOverTimeToArrivalRegisterService.dealOverTimeArrivalRegisterForTodo(ShipOrderInfo);
        }
        return new DycUocOverTimeToArrivalRegisterRspBo();
    }

    @Override
    @PostMapping(value={"dealOverTimeArrivalRegisterForTodo"})
    public DycUocOverTimeToArrivalRegisterRspBo dealOverTimeArrivalRegisterForTodo(@RequestBody JSONObject shipOrderInfo) {
        return new DycUocOverTimeToArrivalRegisterRspBo();
    }

    private List<DycUocDeliveryOrderInfoBO> qryShipOrderList(String time) {
        DycUocQryDeliveryOrderListReqBO deliveryOrderListReqBO = new DycUocQryDeliveryOrderListReqBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycUocQryDeliveryOrderListRspBO qryRspBO = new DycUocQryDeliveryOrderListRspBO();
        deliveryOrderListReqBO.setTacheCodes(Arrays.asList("ASHIP0001", "NSHIP0001"));
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)deliveryOrderListReqBO)));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        qryRspBO = (DycUocQryDeliveryOrderListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocQryDeliveryOrderListRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        ArrayList<DycUocDeliveryOrderInfoBO> uocShipOrderInfoBOList = new ArrayList<DycUocDeliveryOrderInfoBO>();
        for (int i = 1; i <= total; ++i) {
            deliveryOrderListReqBO.setPageNo(i);
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)deliveryOrderListReqBO)));
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocQryDeliveryOrderListRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocQryDeliveryOrderListRspBO.class));
            List<DycUocDeliveryOrderInfoBO> shipOrderInfoBOList = qryRspBO.getRows();
            shipOrderInfoBOList = shipOrderInfoBOList.stream().filter(obj -> {
                Long startTime = Long.parseLong(time) * 24L * 60L * 60L * 1000L;
                Long nowMills = System.currentTimeMillis();
                Long createTime = obj.getDeliveryTime().getTime();
                Long endTime = (Long.parseLong(time) + 1L) * 24L * 60L * 60L * 1000L;
                Long presentTime = nowMills - createTime;
                if (startTime <= presentTime && presentTime < endTime) {
                    log.info("\u8ba2\u5355\uff1a{} +  \u8d85\u65f6: + {} + \u5929\u672a\u5230\u8d27\u767b\u8bb0", (Object)obj.getSaleOrderNo(), (Object)time);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            uocShipOrderInfoBOList.addAll(shipOrderInfoBOList);
        }
        return uocShipOrderInfoBOList;
    }
}

