/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.selfrun.order.api.DycUocOverTimeToPayService;
import com.tydic.dyc.selfrun.order.bo.DycUocOverTimeToPayReqBo;
import com.tydic.dyc.selfrun.order.bo.DycUocOverTimeToPayRspBo;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocOverTimeToPayService"})
public class DycUocOverTimeToPayServiceImpl
implements DycUocOverTimeToPayService {
    private static final Logger log = LoggerFactory.getLogger(DycUocOverTimeToPayServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Lazy
    @Autowired
    private DycUocOverTimeToPayService dycUocGemiSendMessageAtomFunction;

    @Override
    @PostMapping(value={"dealOverTimePay"})
    public DycUocOverTimeToPayRspBo dealOverTimePay(@RequestBody DycUocOverTimeToPayReqBo reqBO) {
        log.info("\u8d85\u8fc7\u65f6\u9650\u672a\u4ed8\u6b3e\u5165\u53c2" + reqBO.getShardingParameter());
        List<DycUocSaleOrderInfoBO> dycUocSaleOrderInfoBOS = this.qrySaleOrderList(reqBO.getShardingParameter());
        dycUocSaleOrderInfoBOS.forEach(obj -> {
            JSONObject saleOrderInfo = new JSONObject();
            saleOrderInfo.put("orderId", (Object)obj.getOrderId());
            saleOrderInfo.put("saleOrderId", (Object)obj.getSaleOrderId());
            saleOrderInfo.put("warnTime", (Object)reqBO.getShardingParameter());
            saleOrderInfo.put("userId", (Object)1L);
            this.dycUocGemiSendMessageAtomFunction.dealOverTimePayForTodo(saleOrderInfo);
        });
        return new DycUocOverTimeToPayRspBo();
    }

    @Override
    @PostMapping(value={"dealOverTimePayForTodo"})
    public DycUocOverTimeToPayRspBo dealOverTimePayForTodo(@RequestBody JSONObject saleOrderInfo) {
        return new DycUocOverTimeToPayRspBo();
    }

    private List<DycUocSaleOrderInfoBO> qrySaleOrderList(String time) {
        DycUocSalOrderListQryReqBO salOrderListQryReqBO = new DycUocSalOrderListQryReqBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycUocSalOrderListQryRspBO qryRspBO = new DycUocSalOrderListQryRspBO();
        salOrderListQryReqBO.setBusiProcStateList(Arrays.asList("A0007", "A0008", "N0004", "N0005", "E0003", "E0004"));
        queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
        qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        ArrayList<DycUocSaleOrderInfoBO> uocSaleOrderInfoBOList = new ArrayList<DycUocSaleOrderInfoBO>();
        for (int i = 1; i <= total; ++i) {
            salOrderListQryReqBO.setPageNo(i);
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
            List<DycUocSaleOrderInfoBO> saleOrderInfoBOList = qryRspBO.getRows();
            saleOrderInfoBOList = saleOrderInfoBOList.stream().filter(obj -> {
                Long startTime = Long.parseLong(time) * 24L * 60L * 60L * 1000L;
                Long nowMills = System.currentTimeMillis();
                Long createTime = obj.getBusiTaskInstBos().get(0).getCreateTime().getTime();
                Long endTime = (Long.parseLong(time) + 1L) * 24L * 60L * 60L * 1000L;
                Long presentTime = nowMills - createTime;
                if (startTime <= presentTime && presentTime < endTime) {
                    log.info("\u8ba2\u5355\uff1a{} +  \u8d85\u65f6: + {} + \u5929\u672a\u4ed8\u6b3e", (Object)obj.getSaleOrderNo(), (Object)time);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            uocSaleOrderInfoBOList.addAll(saleOrderInfoBOList);
        }
        return uocSaleOrderInfoBOList;
    }
}

