/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.selfrun.order.api.DycUocOvertimeDeliveService;
import com.tydic.dyc.selfrun.order.bo.DycUocOvertimeOrderReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOvertimeOrderRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocOvertimeDeliveService"})
public class DycUocOvertimeDeliveServiceImpl
implements DycUocOvertimeDeliveService {
    private static final Logger log = LoggerFactory.getLogger(DycUocOvertimeDeliveServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Lazy
    @Autowired
    private DycUocOvertimeDeliveService dycUocOvertimeDeliveService;

    @Override
    @PostMapping(value={"overtimeDelive"})
    public DycUocOvertimeOrderRspBO overtimeDelive(@RequestBody DycUocOvertimeOrderReqBO reqBO) {
        log.info("\u672a\u53d1\u8d27\u5165\u53c2" + reqBO.getShardingParameter());
        List<DycUocSaleOrderInfoBO> dycUocSaleOrderInfoBOS = this.qrySaleOrderList(reqBO.getShardingParameter());
        dycUocSaleOrderInfoBOS.forEach(obj -> {
            JSONObject saleOrderInfo = new JSONObject();
            saleOrderInfo.put("orderId", (Object)obj.getOrderId());
            saleOrderInfo.put("saleOrderId", (Object)obj.getSaleOrderId());
            saleOrderInfo.put("warnTime", (Object)reqBO.getShardingParameter());
            saleOrderInfo.put("userId", (Object)1L);
            this.dycUocOvertimeDeliveService.overtimeDeliveForTodo(saleOrderInfo);
        });
        return new DycUocOvertimeOrderRspBO();
    }

    @Override
    @PostMapping(value={"overtimeDeliveForTodo"})
    public DycUocOvertimeOrderRspBO overtimeDeliveForTodo(@RequestBody JSONObject saleOrderInfo) {
        return new DycUocOvertimeOrderRspBO();
    }

    private List<DycUocSaleOrderInfoBO> qrySaleOrderList(String time) {
        DycUocSalOrderListQryReqBO salOrderListQryReqBO = new DycUocSalOrderListQryReqBO();
        DycGeneralQueryFuncReqBO queryFuncReqBO = new DycGeneralQueryFuncReqBO();
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = new DycGeneralQueryFuncRspBO();
        DycUocSalOrderListQryRspBO qryRspBO = new DycUocSalOrderListQryRspBO();
        salOrderListQryReqBO.setSaleOrderStates(Arrays.asList("XS_FH_DFH"));
        salOrderListQryReqBO.setBusiProcStateList(Arrays.asList("A0009", "N0006"));
        queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
        queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
        qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        Integer total = qryRspBO.getRecordsTotal() % 10 == 0 ? qryRspBO.getRecordsTotal() / 10 : qryRspBO.getRecordsTotal() / 10 + 1;
        ArrayList<DycUocSaleOrderInfoBO> uocSaleOrderInfoBOList = new ArrayList<DycUocSaleOrderInfoBO>();
        for (int i = 1; i <= total; ++i) {
            salOrderListQryReqBO.setPageNo(i);
            queryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
            queryFuncReqBO.setReqParams(JSON.toJSONString((Object)((Object)salOrderListQryReqBO)));
            dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(queryFuncReqBO);
            qryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
            List<DycUocSaleOrderInfoBO> saleOrderInfoBOList = qryRspBO.getRows();
            saleOrderInfoBOList = saleOrderInfoBOList.stream().filter(obj -> {
                Long startTime = Long.parseLong(time) * 24L * 60L * 60L * 1000L;
                Long nowMills = System.currentTimeMillis();
                Long sendTime = obj.getSendTime();
                Long endTime = (Long.parseLong(time) + 1L) * 24L * 60L * 60L * 1000L;
                Long presentTime = sendTime - nowMills;
                if (startTime <= presentTime && presentTime < endTime) {
                    log.info("\u8ba2\u5355\uff1a{} +  \u4ea4\u8d27\u65e5\u671f\u524d3\u5929\u672a\u53d1\u8d27\uff0c\u8981\u53d1\u6d88\u606f", (Object)obj.getSaleOrderNo());
                    return true;
                }
                log.info("\u8ba2\u5355\uff1a{} +  \u4ea4\u8d27\u65e5\u671f:{}\uff0c\u4e0d\u53d1\u6d88\u606f\uff0c\u8ba1\u7b97\u540e\u65f6\u95f4\u6233:{}", new Object[]{obj.getSaleOrderNo(), sendTime, presentTime});
                return false;
            }).collect(Collectors.toList());
            uocSaleOrderInfoBOList.addAll(saleOrderInfoBOList);
        }
        return uocSaleOrderInfoBOList;
    }
}

