/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.ability.api.CfcAppModeConfigQryListPageAbilityService;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycGeneralTabsCountQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycCommonTabsCountBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncRspBO;
import com.tydic.dyc.base.bo.DycCommonButtonRspBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabButtonConfBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabIdConfBo;
import com.tydic.dyc.base.bo.DycCommonUocTabCountsBO;
import com.tydic.dyc.base.conf.CommonListQueryProperties;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.service.domainservice.UocTacheButtonQryService;
import com.tydic.dyc.oc.service.order.UocProOrderButtonSettingsService;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.UocProOrderEvaluatePageQueryService;
import com.tydic.dyc.selfrun.order.api.DycUocSalOrderInfoListQryService;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderInfoListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSalOrderInfoListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSaleOrderInfoNewBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocSalOrderInfoListQryService"})
public class DycUocSalOrderInfoListQryServiceImpl
implements DycUocSalOrderInfoListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUocSalOrderInfoListQryServiceImpl.class);
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";
    public static final String DEFAULT = "DEFAULT";
    public static final Long ID = 1L;
    private static final String ELC = "2";
    private static final String EFFECTIVE_CODE_STOCK = "1";
    private static final String EFFECTIVE_CODE_PAY = "2";
    private static final String EFFECTIVE_CODE_INSP = "4";
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocTacheButtonQryService uocTacheButtonQryService;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    @Value(value="#{'${button.form.params.sale:orderId,saleOrderId,orderSource,busiTaskInstBos.taskId:taskId,busiTaskInstBos.tacheCode:tacheCode,auditTaskInstBos.taskId:auditTaskId,auditOrderBoList.auditOrderId:auditOrderId}'.split(',')}")
    private List<String> buttonFormParams;
    @Value(value="${uoc.routingMenuCode}")
    private String routingMenuCode;
    @Autowired
    private UocProOrderButtonSettingsService uocProOrderButtonSettingsService;
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    @Autowired
    private UocProOrderEvaluatePageQueryService uocProOrderEvaluatePageQueryService;
    @Autowired
    private DycGeneralTabsCountQueryFunction dycGeneralTabsCountQueryFunction;
    private static final Integer SYSTEM_AUTOMATIC_PRAISE = 1;
    private static final Integer ALLOW_EVA = 1;
    private static final Integer NOT_ALLOW_EVA = 0;
    @Autowired
    private CfcAppModeConfigQryListPageAbilityService cfcAppModeConfigQryListPageAbilityService;
    @Autowired
    private CommonListQueryProperties properties;

    @Override
    @PostMapping(value={"qrySalOrderList"})
    public DycUocSalOrderInfoListQryRspBO qrySalOrderList(@RequestBody DycUocSalOrderInfoListQryReqBO reqBO) {
        this.validateArg(reqBO);
        this.setAuthUser(reqBO);
        DycUocSalOrderInfoListQryRspBO rspBO = this.qryEsData(reqBO);
        this.setButtons(reqBO, rspBO);
        this.setTabCount(reqBO, rspBO);
        return rspBO;
    }

    private void setAuthUser(DycUocSalOrderInfoListQryReqBO reqBO) {
        if (null != reqBO.getUserId() && ObjectUtil.notEqual((Object)reqBO.getUserId(), (Object)ID) && !"30501".equals(reqBO.getTabId())) {
            if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                if (StringUtils.isNotBlank((CharSequence)this.routingMenuCode) && Arrays.asList(this.routingMenuCode.split(";")).contains(reqBO.getMenuCode())) {
                    reqBO.setAgreementCode(1);
                    reqBO.setTradeMode("lcpAgrMatchingOrderQuery".equals(reqBO.getMenuCode()) || "lcpAgrMyMatchingSalesOrder".equals(reqBO.getMenuCode()) ? 2 : 1);
                }
            } else if (EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt())) {
                reqBO.setPurUserId(reqBO.getUserId().toString());
            } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                if (null == reqBO.getSupplierId() || reqBO.getSupplierId().equals("")) {
                    reqBO.setSupplierId(reqBO.getSupId().toString());
                } else {
                    reqBO.setSupplierId(reqBO.getSupId().toString().equals(reqBO.getSupplierId()) ? reqBO.getSupId().toString() : "*");
                }
            }
        }
        if (reqBO.getObjBusiType() != null) {
            ArrayList<String> auditDealResultQryKeys = new ArrayList<String>();
            String auditDealResultQryKey3 = reqBO.getUserId() + "_" + reqBO.getObjBusiType();
            String auditDealResultQryKey1 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 0;
            String auditDealResultQryKey2 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 1;
            if (!CollectionUtils.isEmpty(reqBO.getAuditOrderStatusQry()) && reqBO.getAuditOrderStatusQry().size() > 0) {
                String auditDealResultQryKey = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + reqBO.getAuditOrderStatusQry().get(0);
                auditDealResultQryKeys.add(auditDealResultQryKey);
            } else if (reqBO.getTabId().equals("30014") || reqBO.getTabId().equals("30114") || reqBO.getTabId().equals("30017") || reqBO.getTabId().equals("30011")) {
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            } else if (reqBO.getTabId().equals("30015") || reqBO.getTabId().equals("30115") || reqBO.getTabId().equals("30018") || reqBO.getTabId().equals("30012")) {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
            } else {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            }
            reqBO.setAuditDealResultQryKeys(auditDealResultQryKeys);
            if (null != reqBO.getUserId() && ObjectUtil.notEqual((Object)reqBO.getUserId(), (Object)ID)) {
                if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                    reqBO.setProId(null);
                } else if (EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt())) {
                    reqBO.setPurUserId(null);
                } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                    if (null == reqBO.getSupplierId() || reqBO.getSupplierId().equals("")) {
                        reqBO.setSupplierId(reqBO.getSupId().toString());
                    } else {
                        reqBO.setSupplierId(reqBO.getSupId().toString().equals(reqBO.getSupplierId()) ? reqBO.getSupId().toString() : "*");
                    }
                }
            }
        }
        if ("30501".equals(reqBO.getTabId())) {
            reqBO.setProDeliveryId(String.valueOf(reqBO.getUserId()));
        }
    }

    private void validateArg(DycUocSalOrderInfoListQryReqBO reqBo) {
        List<DycCommonUmcTabIdConfBo> theTabConf;
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new BaseBusinessException("B00001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBo.getTabIdConfList())) {
            throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycCommonUmcTabIdConfBo tabIdConfBo : reqBo.getTabIdConfList()) {
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getTabId())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[tabId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getTabName())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[tabName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getDefaultFlag())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[defaultFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getQuantityFlag())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[quantityFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getSort())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[sort]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getParamJson())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[paramJson]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isNotEmpty((Object)tabIdConfBo.getUmcTacheButtonList())) continue;
            for (DycCommonUmcTabButtonConfBo btn : tabIdConfBo.getUmcTacheButtonList()) {
                if (ObjectUtil.isEmpty((Object)btn)) {
                    throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[umcTacheButtonList]\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)btn.getBtnCode())) {
                    throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[umcTacheButtonList]\u4e2d\u5bf9\u8c61[btnCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)btn.getBtnName())) continue;
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[umcTacheButtonList]\u4e2d\u5bf9\u8c61[btnName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        List defaultTabList = reqBo.getTabIdConfList().stream().filter(item -> CommonListQueryProperties.DEFAULT_FLAG_YES.equals(item.getDefaultFlag())).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(defaultTabList)) {
            throw new BaseBusinessException("B00002", "\u8be5\u83dc\u5355\u4e0b\uff0c\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u9875\u7b7e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (defaultTabList.size() > 1) {
            throw new BaseBusinessException("B00002", "\u8be5\u83dc\u5355\u4e0b\uff0c\u914d\u7f6e\u4e86\u591a\u4e2a\u9ed8\u8ba4\u9875\u7b7e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTabId())) {
            reqBo.setTabId(((DycCommonUmcTabIdConfBo)defaultTabList.get(0)).getTabId());
        }
        if (ObjectUtil.isEmpty(theTabConf = reqBo.getTabIdConfList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId()))) {
            throw new BaseBusinessException("B00002", "\u8be5\u9875\u7b7eid(" + reqBo.getTabId() + ")\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    private DycUocSalOrderInfoListQryRspBO qryEsData(DycUocSalOrderInfoListQryReqBO reqBo) {
        JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)));
        List<DycCommonUmcTabIdConfBo> theTabConfList = reqBo.getTabIdConfList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId());
        if (ObjectUtil.isNotEmpty((Object)theTabConfList.get(0).getParamJson())) {
            reqBoJsonObj.putAll((Map)JSON.parseObject((String)theTabConfList.get(0).getParamJson()));
        }
        reqBoJsonObj.remove((Object)"tabIdConfList");
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        return (DycUocSalOrderInfoListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderInfoListQryRspBO.class));
    }

    private void setButtons(DycUocSalOrderInfoListQryReqBO reqBo, DycUocSalOrderInfoListQryRspBO rspBO) {
        List theTabBtnList = reqBo.getTabIdConfList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId()).get(0).getUmcTacheButtonList();
        if (ObjectUtil.isNotEmpty((Object)theTabBtnList)) {
            Map<String, List<DycCommonUmcTabButtonConfBo>> saleStatusMap = theTabBtnList.stream().collect(Collectors.groupingBy(DycCommonUmcTabButtonConfBo::getTacheCode));
            for (DycUocSaleOrderInfoNewBO saleOrder : rspBO.getRows()) {
                HashSet<DycCommonButtonRspBo> buttons = new HashSet<DycCommonButtonRspBo>();
                List<DycCommonUmcTabButtonConfBo> uocButtonFuncBos = saleStatusMap.get(saleOrder.getBusiTaskInstBos().get(0).getTacheCode());
                if (ObjectUtil.isNotEmpty(uocButtonFuncBos)) {
                    for (DycCommonUmcTabButtonConfBo uocButtonFuncBo : uocButtonFuncBos) {
                        DycCommonButtonRspBo btn = new DycCommonButtonRspBo();
                        buttons.add(btn);
                        btn.setBtnCode(uocButtonFuncBo.getBtnCode());
                        btn.setBtnName(uocButtonFuncBo.getBtnName());
                        if (!ObjectUtil.isNotEmpty((Object)saleOrder.getBusiTaskInstBos().get(0).getFormUrl()) || !ObjectUtil.isNotEmpty((Object)saleOrder.getBusiTaskInstBos().get(0).getTacheCode()) || !saleOrder.getBusiTaskInstBos().get(0).getTacheCode().equals(uocButtonFuncBo.getFormTacheCode())) continue;
                        btn.setUri(this.getBtnUrl(reqBo.getReflected(), saleOrder.getBusiTaskInstBos().get(0).getFormUrl(), uocButtonFuncBo.getFormParam()));
                    }
                }
                saleOrder.setButtons(new ArrayList<DycCommonButtonRspBo>(buttons));
            }
        }
    }

    private String getBtnUrl(Boolean reflected, String dataFormUrl, String formParam) {
        String url = "";
        if (reflected != null && reflected.booleanValue()) {
            url = this.properties.getButtonUrlPrefix() + dataFormUrl;
        } else {
            String fromUrl = dataFormUrl;
            if (fromUrl.endsWith(".html")) {
                fromUrl = fromUrl.substring(0, fromUrl.length() - 5);
            }
            url = this.properties.getButtonUrlPrefixReal() + fromUrl;
        }
        if (StringUtils.isNotBlank((CharSequence)formParam)) {
            return url + "?" + formParam;
        }
        return url;
    }

    private void setTabCount(DycUocSalOrderInfoListQryReqBO reqBo, DycUocSalOrderInfoListQryRspBO rspBO) {
        ArrayList<DycGeneralTabsCountQueryBO> countList = new ArrayList<DycGeneralTabsCountQueryBO>();
        List<DycCommonUmcTabIdConfBo> tabIdConfList = reqBo.getTabIdConfList();
        for (DycCommonUmcTabIdConfBo tab : tabIdConfList) {
            if (!CommonListQueryProperties.QUANTITY_FLAG_YES.equals(tab.getQuantityFlag())) continue;
            DycGeneralTabsCountQueryBO cBo = new DycGeneralTabsCountQueryBO();
            cBo.setTabId(tab.getTabId());
            cBo.setTabName(tab.getTabName());
            if (reqBo.getTabId().equals(tab.getTabId())) {
                JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)));
                reqBoJsonObj.putAll((Map)JSONObject.parseObject((String)tab.getParamJson()));
                cBo.setParamJsonStr(reqBoJsonObj.toJSONString());
            } else {
                cBo.setParamJsonStr(tab.getParamJson());
            }
            countList.add(cBo);
        }
        DycGeneralTabsCountQueryFuncReqBO countReqBo = new DycGeneralTabsCountQueryFuncReqBO();
        countReqBo.setDycGeneralTabsCountQueryBOS(countList);
        DycGeneralTabsCountQueryFuncRspBO tabsCountRsp = this.dycGeneralTabsCountQueryFunction.getTabsCount(countReqBo);
        if ("0000".equals(tabsCountRsp.getRespCode())) {
            ArrayList<DycCommonUocTabCountsBO> tabCountList = new ArrayList<DycCommonUocTabCountsBO>();
            for (DycCommonTabsCountBO dycCommonTabsCountBO : tabsCountRsp.getTabCountList()) {
                DycCommonUocTabCountsBO rspCountBo = new DycCommonUocTabCountsBO();
                rspCountBo.setTabCount(dycCommonTabsCountBO.getTabCount());
                rspCountBo.setTabNameCount(dycCommonTabsCountBO.getTabNameCount());
                rspCountBo.setTabId(Long.valueOf(dycCommonTabsCountBO.getTabId().intValue()));
                rspCountBo.setTabName(dycCommonTabsCountBO.getTabName());
                tabCountList.add(rspCountBo);
            }
            rspBO.setTabCountList(tabCountList);
        }
    }
}

