/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycBusiProcessDeleteFunction;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessDeleteFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService;
import com.tydic.dyc.oc.service.domainservice.UocProcInsTerminateDomainService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateDomainReqBo;
import com.tydic.dyc.oc.service.order.UocCancelOrderService;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceReqCancelBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocStockExpireCancelWholeOrderService;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderCommodityInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocStockExpireCancelOrderReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocStockExpireCancelOrderRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocStockExpireCancelWholeOrderService"})
public class DycUocStockExpireCancelWholeOrderServiceImpl
implements DycUocStockExpireCancelWholeOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocStockExpireCancelWholeOrderServiceImpl.class);
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocCancelOrderService uocCancelOrderService;
    @Autowired
    private UocCancelSaleOrderService uocCancelSaleOrderService;
    @Autowired
    private DycBusiProcessDeleteFunction dycBusiProcessDeleteFunction;
    @Autowired
    private UocProcInsTerminateDomainService uocProcInsTerminateDomainService;
    private static final String EFFECTIVE_CODE_STOCK = "1";

    @Override
    @PostMapping(value={"dealStockExpireCancelWholeOrder"})
    public DycUocStockExpireCancelOrderRspBO dealStockExpireCancelWholeOrder(@RequestBody DycUocStockExpireCancelOrderReqBO reqBO) {
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)"881184533233897472");
        jsonObject.put("objBusiType", (Object)"3");
        jsonObject.put("tacheCodes", Collections.singletonList("W001"));
        dycGeneralQueryFuncReqBO.setReqParams(jsonObject.toJSONString());
        log.info("\u6574\u5355\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycGeneralQueryFuncReqBO));
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocOrderListQryRspBO rspBO = (DycUocOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocOrderListQryRspBO.class));
        if (rspBO.getRecordsTotal() > 0) {
            Map<String, Map<String, Long>> effConfMap = this.getConf();
            int total = rspBO.getRecordsTotal() % 10 == 0 ? rspBO.getRecordsTotal() / 10 : rspBO.getRecordsTotal() / 10 + 1;
            for (int i = 1; i <= total; ++i) {
                dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
                jsonObject.put("pageNo", (Object)i);
                jsonObject.put("pageSize", (Object)20);
                dycGeneralQueryFuncReqBO.setReqParams(jsonObject.toJSONString());
                DycGeneralQueryFuncRspBO dycGeneralQueryRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
                DycUocOrderListQryRspBO dycUocOrderListQryRspBO = (DycUocOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryRspBO.getRspJsonStr(), DycUocOrderListQryRspBO.class));
                for (DycUocOrderInfoBO row : dycUocOrderListQryRspBO.getRows()) {
                    List<DycUocOrderCommodityInfoBO> commodityInfos = row.getCommodityInfos();
                    Long stockAging = this.getStockAging(effConfMap, commodityInfos);
                    if (System.currentTimeMillis() <= row.getCreateTime().getTime() + stockAging || !"W001".equals(row.getBusiTaskInstBos().get(0).getTacheCode())) continue;
                    log.info("\u6574\u5355\u81ea\u52a8\u53d6\u6d88\uff1a{}", (Object)JSON.toJSONString((Object)row));
                    this.dealCancelWholeOrder(reqBO, row);
                }
            }
        }
        return new DycUocStockExpireCancelOrderRspBO();
    }

    private void dealCancelWholeOrder(DycUocStockExpireCancelOrderReqBO reqBO, DycUocOrderInfoBO row) {
        UocCancelOrderServiceReqBo uocCancelOrderServiceReqBo = new UocCancelOrderServiceReqBo();
        uocCancelOrderServiceReqBo.setTraceId(reqBO.getTraceId());
        ArrayList<UocCancelOrderServiceReqCancelBo> cancelList = new ArrayList<UocCancelOrderServiceReqCancelBo>();
        UocCancelOrderServiceReqCancelBo dycUocCancelOrderFuncReqCancelBo = new UocCancelOrderServiceReqCancelBo();
        dycUocCancelOrderFuncReqCancelBo.setOrderId(row.getOrderId());
        dycUocCancelOrderFuncReqCancelBo.setCancelReason("\u9884\u5360\u5e93\u5b58\u65f6\u9650\u5230\u671f\u8ba2\u5355\u53d6\u6d88");
        cancelList.add(dycUocCancelOrderFuncReqCancelBo);
        uocCancelOrderServiceReqBo.setCancelList(cancelList);
        UocCancelOrderServiceRspBo uocCancelOrderServiceRspBo = this.uocCancelOrderService.cancelOrder(uocCancelOrderServiceReqBo);
        if (!"0000".equals(uocCancelOrderServiceRspBo.getRespCode())) {
            return;
        }
        for (UocCancelOrderBo uocCancelOrderBo : uocCancelOrderServiceRspBo.getUocCancelOrderBoList()) {
            try {
                UocCancelSaleOrderServiceReqBo uocCancelSaleOrderServiceReqBo = new UocCancelSaleOrderServiceReqBo();
                uocCancelSaleOrderServiceReqBo.setCancelReason("\u9884\u5360\u5e93\u5b58\u65f6\u9650\u5230\u671f\u8ba2\u5355\u53d6\u6d88");
                uocCancelSaleOrderServiceReqBo.setOrderId(uocCancelOrderBo.getOrderId());
                uocCancelSaleOrderServiceReqBo.setSaleOrderId(uocCancelOrderBo.getSaleOrderId());
                uocCancelSaleOrderServiceReqBo.setTraceId(reqBO.getTraceId());
                uocCancelSaleOrderServiceReqBo.setUserId(Long.valueOf(1L));
                uocCancelSaleOrderServiceReqBo.setName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                this.uocCancelSaleOrderService.cancelSaleOrder(uocCancelSaleOrderServiceReqBo);
                DycBusiProcessDeleteFuncReqBO processDeleteFuncReqBO = new DycBusiProcessDeleteFuncReqBO();
                processDeleteFuncReqBO.setProcInstId(uocCancelOrderBo.getProcInstId());
                this.dycBusiProcessDeleteFunction.deleteBusiProcess(processDeleteFuncReqBO);
                UocProcInsTerminateDomainReqBo uocProcInsTerminateDomainReqBo = new UocProcInsTerminateDomainReqBo();
                uocProcInsTerminateDomainReqBo.setOrderId(uocCancelOrderBo.getOrderId());
                uocProcInsTerminateDomainReqBo.setObjId(uocCancelOrderBo.getSaleOrderId());
                uocProcInsTerminateDomainReqBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocProcInsTerminateDomainReqBo.setTraceId(reqBO.getTraceId());
                uocProcInsTerminateDomainReqBo.setUserId(Long.valueOf(1L));
                uocProcInsTerminateDomainReqBo.setName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                this.uocProcInsTerminateDomainService.dealProcInsTerminate(uocProcInsTerminateDomainReqBo);
            }
            catch (Exception exception) {}
        }
        try {
            DycBusiProcessDeleteFuncReqBO processDeleteFuncReqBO = new DycBusiProcessDeleteFuncReqBO();
            processDeleteFuncReqBO.setProcInstId(row.getBusiProcId());
            this.dycBusiProcessDeleteFunction.deleteBusiProcess(processDeleteFuncReqBO);
            UocProcInsTerminateDomainReqBo terminateDomainReqBo = new UocProcInsTerminateDomainReqBo();
            terminateDomainReqBo.setOrderId(row.getOrderId());
            terminateDomainReqBo.setObjId(row.getOrderId());
            terminateDomainReqBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
            terminateDomainReqBo.setTraceId(reqBO.getTraceId());
            terminateDomainReqBo.setUserId(Long.valueOf(1L));
            terminateDomainReqBo.setName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            this.uocProcInsTerminateDomainService.dealProcInsTerminate(terminateDomainReqBo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Long getStockAging(Map<String, Map<String, Long>> effConfMap, List<DycUocOrderCommodityInfoBO> commodityInfos) {
        return ((DycUocOrderCommodityInfoBO)commodityInfos.stream().peek(commodityInfo -> {
            Map stockEffMap;
            if (!CollectionUtils.isEmpty((Map)effConfMap) && StringUtils.isNotBlank((CharSequence)commodityInfo.getSupplierId()) && null != (stockEffMap = (Map)effConfMap.get(EFFECTIVE_CODE_STOCK + commodityInfo.getSkuSource()))) {
                Long time = (Long)stockEffMap.get(commodityInfo.getSupplierId());
                if (null == time) {
                    time = (Long)stockEffMap.get("0");
                }
                commodityInfo.setStockAging(time);
            }
        }).sorted(Comparator.comparing(DycUocOrderCommodityInfoBO::getStockAging)).collect(Collectors.toList()).get(0)).getStockAging();
    }

    private Map<String, Map<String, Long>> getConf() {
        UocProOrderEffectiveListPageQueryReqBo dycUocProOrderEffectiveListPageQueryFuncReqBo = new UocProOrderEffectiveListPageQueryReqBo();
        dycUocProOrderEffectiveListPageQueryFuncReqBo.setPageNo(-1);
        dycUocProOrderEffectiveListPageQueryFuncReqBo.setPageSize(-1);
        UocProOrderEffectiveListPageQueryRspBo dycUocProOrderEffectiveListPageQueryFuncRspBo = this.uocProOrderEffectivePageQueryService.queryOrderEffectiveListPage(dycUocProOrderEffectiveListPageQueryFuncReqBo);
        if (CollectionUtils.isEmpty((Collection)dycUocProOrderEffectiveListPageQueryFuncRspBo.getRows())) {
            return new HashMap<String, Map<String, Long>>();
        }
        Map<String, List<UocProOrderEffectiveInfoBo>> effListMap = dycUocProOrderEffectiveListPageQueryFuncRspBo.getRows().stream().collect(Collectors.groupingBy(e -> e.getEffectiveCode() + e.getBusinessTypeCode()));
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        effListMap.forEach((key, value) -> map.put((String)key, value.stream().collect(Collectors.toMap(UocProOrderEffectiveInfoBo::getSupplierNo, UocProOrderEffectiveInfoBo::getAging))));
        return map;
    }
}

