/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.oc.service.domainservice.UocCreateApprovalOrderService;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocSupplierConfirmService;
import com.tydic.dyc.selfrun.order.bo.DycUocSupplierConfirmReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocSupplierConfirmRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocSupplierConfirmService"})
public class DycUocSupplierConfirmServiceImpl
implements DycUocSupplierConfirmService {
    private static final Logger log = LoggerFactory.getLogger(DycUocSupplierConfirmServiceImpl.class);
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private UocSaleOrderRefuseService uocSaleOrderRefuseService;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;
    @Autowired
    private UocCreateApprovalOrderService uocCreateApprovalOrderService;
    @Value(value="${process.sysCode:DYC}")
    private String processSysCode;
    @Value(value="${uoc.releaseBudget:false}")
    private boolean releaseBudget;
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Value(value="${auditPrcessKeyMock:NO_AGREEMENT_ORDER_AUDIT_FLOW}")
    private String auditPrcessKeyMock;
    @Value(value="${auditOrgIdKey:custom_org_id}")
    private String auditOrgIdKey;
    @Value(value="${relevantDeptIdKey:relevantDeptId}")
    private String relevantDeptIdKey;

    @Override
    @PostMapping(value={"supplierConfirm"})
    public DycUocSupplierConfirmRspBO supplierConfirm(@RequestBody DycUocSupplierConfirmReqBO reqBO) {
        this.verifyParam(reqBO);
        UocSaleOrderRefuseReqBo uocSaleOrderRefuseReqBo = (UocSaleOrderRefuseReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UocSaleOrderRefuseReqBo.class);
        UocSaleOrderRefuseRspBo uocSaleOrderRefuseRspBo = this.uocSaleOrderRefuseService.dealSaleOrderRefuse(uocSaleOrderRefuseReqBo);
        if (!"0000".equals(uocSaleOrderRefuseRspBo.getRespCode())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u786e\u8ba4/\u62d2\u5355\u5931\u8d25\uff1a" + uocSaleOrderRefuseRspBo.getRespDesc());
        }
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(reqBO.getTaskId());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("confirmResult", String.valueOf(reqBO.getConfirmResult()));
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        if (!"0000".equals(saleOrderDetail.getRespCode())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff1a" + saleOrderDetail.getRespDesc());
        }
        variables.put("userId", saleOrderDetail.getCreateOperId());
        variables.put("userName", saleOrderDetail.getCreateOperName());
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
        this.buryPoint(reqBO);
        return new DycUocSupplierConfirmRspBO();
    }

    private void verifyParam(DycUocSupplierConfirmReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getConfirmResult()) {
            throw new ZTBusinessException("\u786e\u8ba4\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void buryPoint(DycUocSupplierConfirmReqBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrderId", (Object)contextBO.getSaleOrderId());
        jsonObject.put("orderId", (Object)contextBO.getOrderId());
        ArrayList<DycBuriedPointCallFuncBo> buildsList = new ArrayList<DycBuriedPointCallFuncBo>();
        DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
        bo.setIdent("UPDATA");
        bo.setDycCenterCode("UOC");
        bo.setDycBusiCode("saleOrderSync");
        bo.setData((Object)jsonObject);
        buildsList.add(bo);
        funcReqBo.setBusiList(buildsList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u4f9b\u5e94\u5546\u786e\u8ba4\u9500\u552e\u5355\u540e\u8fdb\u884c\u57cb\u70b9\uff08\u53d8\u66f4\uff09\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25" + funcRspBo.getRespDesc());
        }
    }
}

