/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.supplier.transf.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.supplier.transf.util.WatermarkInfoBO;
import java.io.IOException;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class PdfUtil {
    public static void addTextWatermark(PdfWriter pdfWriter, List<WatermarkInfoBO> watermarkInfoList, float opacity, int alignment, BaseColor color, BaseFont baseFont, float size) {
        if (pdfWriter == null) {
            throw new ZTBusinessException("\u6240\u4f20PdfWriter\u5bf9\u8c61\u4e3anull");
        }
        try {
            if (baseFont == null) {
                baseFont = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            pdfWriter.setPageEvent((PdfPageEvent)new TextWaterMarkPdfPageEvent(watermarkInfoList, opacity, alignment, color, baseFont, size));
        }
        catch (DocumentException | IOException e) {
            throw new ZTBusinessException("\u8bbe\u7f6e\u6c34\u5370\u51fa\u9519");
        }
    }

    public static void addTableToDoc(Document document, PdfPTable table) {
        try {
            document.add((Element)table);
        }
        catch (DocumentException e) {
            throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519");
        }
    }

    public static void addTableListToDoc(Document document, List<PdfPTable> tableList) {
        if (CollectionUtils.isEmpty(tableList)) {
            return;
        }
        tableList.forEach(table -> {
            try {
                document.add((Element)table);
            }
            catch (DocumentException e) {
                throw new ZTBusinessException("pdf\u8ffd\u52a0table\u51fa\u9519");
            }
        });
    }

    public static void addCellToTable(PdfPTable table, String content, Font font, Integer horizontalAlignment, Integer verticalAlignment, Float fixedHeight, Integer colspan, Integer border) {
        PdfPCell cell = new PdfPCell(new Phrase(content, font));
        if (fixedHeight != null) {
            cell.setFixedHeight(fixedHeight.floatValue());
        }
        if (horizontalAlignment != null) {
            cell.setHorizontalAlignment(horizontalAlignment.intValue());
        }
        if (verticalAlignment != null) {
            cell.setVerticalAlignment(verticalAlignment.intValue());
        }
        if (colspan != null) {
            cell.setColspan(colspan.intValue());
        }
        if (border != null) {
            cell.setBorder(border.intValue());
        }
        table.addCell(cell);
    }

    private static class TextWaterMarkPdfPageEvent
    extends PdfPageEventHelper {
        private List<WatermarkInfoBO> watermarkInfoList;
        private String waterMarkText;
        private float x;
        private float y;
        private float opacity;
        private int alignment;
        private float rotation;
        private BaseColor color;
        private BaseFont baseFont;
        private float size;

        public TextWaterMarkPdfPageEvent(List<WatermarkInfoBO> watermarkInfoList, String waterMarkText, float x, float y, float rotation, float opacity, int alignment, BaseColor color, BaseFont baseFont, float size) {
            this.watermarkInfoList = watermarkInfoList;
            this.waterMarkText = waterMarkText;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.opacity = opacity;
            this.alignment = alignment;
            this.color = color;
            this.baseFont = baseFont;
            this.size = size;
        }

        public TextWaterMarkPdfPageEvent(List<WatermarkInfoBO> watermarkInfoList, float opacity, int alignment, BaseColor color, BaseFont baseFont, float size) {
            this.watermarkInfoList = watermarkInfoList;
            this.opacity = opacity;
            this.alignment = alignment;
            this.color = color;
            this.baseFont = baseFont;
            this.size = size;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfContentByte waterMar = writer.getDirectContentUnder();
            waterMar.beginText();
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(this.opacity);
            waterMar.setFontAndSize(this.baseFont, this.size);
            waterMar.setGState(gs);
            if (!CollectionUtils.isEmpty(this.watermarkInfoList)) {
                this.watermarkInfoList.forEach(watermarkInfoBO -> waterMar.showTextAligned(this.alignment, watermarkInfoBO.getWaterMarkText(), (float)watermarkInfoBO.getX().intValue(), (float)watermarkInfoBO.getY().intValue(), (float)watermarkInfoBO.getRotation().intValue()));
            } else {
                waterMar.showTextAligned(this.alignment, this.waterMarkText, this.x, this.y, this.rotation);
            }
            waterMar.setColorFill(this.color);
            waterMar.endText();
            waterMar.stroke();
        }
    }
}

