/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.agr.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agrchange.AgrCreateAgrItemChngService;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrItemChngListService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrItemChngListReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrItemChngListRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.zone.agr.api.DycAgrSaveAgrItemChngService;
import com.tydic.dyc.zone.agr.bo.DycAgrSaveAgrItemChngReqBO;
import com.tydic.dyc.zone.agr.bo.DycAgrSaveAgrItemChngRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.zone.agr.api.DycAgrSaveAgrItemChngService"})
public class DycAgrSaveAgrItemChngServiceImpl
implements DycAgrSaveAgrItemChngService {
    private static final Logger log = LoggerFactory.getLogger(DycAgrSaveAgrItemChngServiceImpl.class);
    @Autowired
    private AgrCreateAgrItemChngService agrCreateAgrItemChngService;
    @Autowired
    private AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    private AgrGetAgrItemChngListService agrGetAgrItemChngListService;

    @Override
    @PostMapping(value={"saveAgrItemChng"})
    public DycAgrSaveAgrItemChngRspBO saveAgrItemChng(@RequestBody DycAgrSaveAgrItemChngReqBO dycAgrSaveAgrItemChngReqBO) {
        if (CollectionUtils.isEmpty(dycAgrSaveAgrItemChngReqBO.getAgrItemChng())) {
            return new DycAgrSaveAgrItemChngRspBO();
        }
        this.validPuplicate(dycAgrSaveAgrItemChngReqBO);
        log.info("\u660e\u7ec6\u53d8\u66f4\u5165\u53c2\u4e3a\uff1a" + JSONObject.toJSONString((Object)((Object)dycAgrSaveAgrItemChngReqBO)));
        AgrCreateAgrItemChngReqBO reqBO = (AgrCreateAgrItemChngReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)dycAgrSaveAgrItemChngReqBO)), AgrCreateAgrItemChngReqBO.class);
        log.info("\u8c03\u7528\u534f\u8bae\u4fdd\u5b58\u660e\u7ec6\u53d8\u66f4\u5165\u53c2\u4e3a\uff1a" + JSONObject.toJSONString((Object)reqBO));
        AgrCreateAgrItemChngRspBO rspBO = this.agrCreateAgrItemChngService.createAgrItemChng(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        return (DycAgrSaveAgrItemChngRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rspBO), DycAgrSaveAgrItemChngRspBO.class));
    }

    private void validPuplicate(DycAgrSaveAgrItemChngReqBO dycAgrSaveAgrItemChngReqBO) {
        ArrayList uniqueKeys = new ArrayList();
        ArrayList materialCodes = new ArrayList();
        HashMap uniqueKeyMap = new HashMap();
        dycAgrSaveAgrItemChngReqBO.getAgrItemChng().forEach(dycAgrItemChngBO -> {
            if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(dycAgrItemChngBO.getItemChngType()) && dycAgrItemChngBO.getAgrItemChngId() == null) {
                String key = dycAgrItemChngBO.getCommodityTypeName() + "_" + dycAgrItemChngBO.getMaterialCode();
                if (uniqueKeyMap.get(key) != null) {
                    throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                }
                uniqueKeyMap.put(key, dycAgrItemChngBO);
                uniqueKeys.add(key);
                materialCodes.add(dycAgrItemChngBO.getMaterialCode());
            }
        });
        if (uniqueKeys.size() > 0) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(1));
            agrGetAgrItemListReqBO.setAgrId(dycAgrSaveAgrItemChngReqBO.getAgrId());
            agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25" + agrGetAgrItemListRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
            }
        }
        if (materialCodes.size() > 0) {
            AgrGetAgrItemChngListReqBO agrGetAgrItemChngListReqBO = new AgrGetAgrItemChngListReqBO();
            agrGetAgrItemChngListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemChngListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemChngListReqBO.setAgrId(dycAgrSaveAgrItemChngReqBO.getAgrId());
            agrGetAgrItemChngListReqBO.setChngApplyId(dycAgrSaveAgrItemChngReqBO.getChngApplyId());
            agrGetAgrItemChngListReqBO.setMaterialCodes(materialCodes);
            AgrGetAgrItemChngListRspBO rspBO = this.agrGetAgrItemChngListService.getAgrItemChngList(agrGetAgrItemChngListReqBO);
            if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
                rspBO.getRows().forEach(agrItemChngBo -> {
                    String uniqueKey = agrItemChngBo.getCommodityTypeName() + "_" + agrItemChngBo.getMaterialCode();
                    if (uniqueKeyMap.get(uniqueKey) != null) {
                        throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                    }
                });
            }
        }
    }
}

