/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.repository.dictionary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.base.core.dictionary.bo.DictDataBo;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.smc.dao.SmcDictConfigMapper;
import com.tydic.dyc.smc.dao.SmcDictDataMapper;
import com.tydic.dyc.smc.po.SmcDictConfigPo;
import com.tydic.dyc.smc.po.SmcDictDataPo;
import com.tydic.dyc.smc.repository.dictionary.api.SmcDictDataRepository;
import com.tydic.dyc.smc.repository.dictionary.bo.SmcDictDataDo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmcDictDataRepositoryImpl
extends ServiceImpl<SmcDictDataMapper, SmcDictDataPo>
implements SmcDictDataRepository {
    private static final Logger log = LoggerFactory.getLogger(SmcDictDataRepositoryImpl.class);
    @Autowired
    private SmcDictDataMapper smcDictDataMapper;
    @Autowired
    private SmcDictConfigMapper smcDictConfigMapper;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${dict.cache.enable-redis}")
    private String cacheFlag;

    @PostConstruct
    public void init() {
        if ("true".equals(this.cacheFlag)) {
            this.loadingDictDataCache(null);
        }
    }

    @Override
    public SmcDictDataPo getOneDictData(SmcDictDataDo smcDictDataDo) {
        SmcDictDataPo smcDictDataPo = (SmcDictDataPo)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SmcDictDataPo.class).eq(SmcDictDataPo::getBusiCenter, (Object)smcDictDataDo.getBusiCenter())).eq(SmcDictDataPo::getPCode, (Object)smcDictDataDo.getPCode())).eq(SmcDictDataPo::getCode, (Object)smcDictDataDo.getCode()));
        return smcDictDataPo;
    }

    @Override
    public void refreshByCenterAndPCode(String busiCenter, String pCode) {
        List newDictDataList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SmcDictDataPo.class).eq(SmcDictDataPo::getBusiCenter, (Object)busiCenter)).eq(SmcDictDataPo::getPCode, (Object)pCode)).eq(SmcDictDataPo::getStatus, (Object)1));
        List CacheDictDataList = JSONArray.parseArray((String)JSON.toJSONString((Object)newDictDataList), DictDataBo.class);
        if (CollectionUtils.isEmpty((Collection)newDictDataList)) {
            this.cacheClient.delete(DictFrameworkUtils.getKey((String)busiCenter, (String)pCode));
        } else {
            this.cacheClient.set(DictFrameworkUtils.getKey((String)busiCenter, (String)pCode), (Object)CacheDictDataList);
        }
    }

    @Override
    public void refreshByConfigKeys(List<String> configKeys) {
        if (CollectionUtils.isEmpty(configKeys)) {
            this.loadingDictDataCache(null);
        } else {
            List configList = this.smcDictConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery(SmcDictConfigPo.class).in(SmcDictConfigPo::getConfigKey, configKeys));
            ArrayList<SmcDictDataPo> dataList = new ArrayList<SmcDictDataPo>();
            for (SmcDictConfigPo smcDictConfigPo : configList) {
                List list = this.smcDictDataMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SmcDictDataPo.class).eq(SmcDictDataPo::getBusiCenter, (Object)smcDictConfigPo.getBusiCenter())).eq(SmcDictDataPo::getPCode, (Object)smcDictConfigPo.getPCode()));
                dataList.addAll(list);
            }
            if (!CollectionUtils.isEmpty(dataList)) {
                this.loadingDictDataCache(dataList);
            }
        }
    }

    @Override
    public void deleteCache(String busiCenter, String pCode) {
        this.cacheClient.delete(DictFrameworkUtils.getKey((String)busiCenter, (String)pCode));
    }

    private void loadingDictDataCache(List<SmcDictDataPo> smcDictDataList) {
        if (CollectionUtils.isEmpty(smcDictDataList) && CollectionUtils.isEmpty((Collection)(smcDictDataList = this.smcDictDataMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SmcDictDataPo::getStatus, (Object)1))))) {
            return;
        }
        List CacheDictDataList = JSONArray.parseArray((String)JSON.toJSONString(smcDictDataList), DictDataBo.class);
        Map<String, List<DictDataBo>> uniqueListMap = CacheDictDataList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)DictFrameworkUtils.getKey((String)t.getBusiCenter(), (String)t.getPCode()))).collect(Collectors.groupingBy(t -> DictFrameworkUtils.getKey((String)t.getBusiCenter(), (String)t.getPCode())));
        uniqueListMap.forEach((k, v) -> {
            if (CollectionUtils.isEmpty((Collection)v)) {
                this.cacheClient.delete(k);
            } else {
                this.cacheClient.set(k, v);
            }
        });
    }
}

