/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.repository.enterprise.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.smc.dao.SmcUmcEnterpriseContactMapper;
import com.tydic.dyc.smc.dao.SmcUmcEnterpriseInfoMapper;
import com.tydic.dyc.smc.dao.SmcUmcOrgInfoMapper;
import com.tydic.dyc.smc.dao.SmcUmcOrgTagRelMapper;
import com.tydic.dyc.smc.po.SmcUmcEnterpriseContactPo;
import com.tydic.dyc.smc.po.SmcUmcEnterpriseInfoPo;
import com.tydic.dyc.smc.po.SmcUmcOrgInfoExtPo;
import com.tydic.dyc.smc.po.SmcUmcOrgInfoPo;
import com.tydic.dyc.smc.po.SmcUmcOrgTagRelPo;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcEnterpriseContactDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcEnterpriseInfoDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoQryDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoQryRspDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgTagRelDO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmcUmcOrgInfoRepositoryImpl
extends ServiceImpl<SmcUmcOrgInfoMapper, SmcUmcOrgInfoPo>
implements SmcUmcOrgInfoRepository {
    @Autowired
    private SmcUmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private SmcUmcOrgTagRelMapper umcOrgTagRelMapper;
    @Autowired
    private SmcUmcEnterpriseInfoMapper umcEnterpriseInfoMapper;
    @Autowired
    private SmcUmcEnterpriseContactMapper umcEnterpriseContactMapper;

    @Override
    public SmcUmcOrgInfoDO qryOrgInfoDetail(SmcUmcOrgInfoQryDO qryOrgDO) {
        SmcUmcOrgInfoPo umcOrgInfoPo = new SmcUmcOrgInfoPo();
        umcOrgInfoPo.setOrgId(qryOrgDO.getOrgId());
        SmcUmcOrgInfoExtPo umcOrgInfoExtPo = this.umcOrgInfoMapper.qryOrgInfoDetail(umcOrgInfoPo);
        if (ObjectUtil.isEmpty((Object)umcOrgInfoExtPo)) {
            return null;
        }
        SmcUmcOrgInfoDO umcOrgInfoDO = (SmcUmcOrgInfoDO)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)umcOrgInfoExtPo), SmcUmcOrgInfoDO.class);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SmcUmcOrgTagRelPo::getOrgId, (Object)umcOrgInfoDO.getOrgId())).eq(SmcUmcOrgTagRelPo::getDelFlag, (Object)"0");
        List umcOrgTagRelPoList = this.umcOrgTagRelMapper.selectList((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)umcOrgTagRelPoList)) {
            List orgTagRelList = JSON.parseArray((String)JSON.toJSONString((Object)umcOrgTagRelPoList), SmcUmcOrgTagRelDO.class);
            umcOrgInfoDO.setOrgTagRelList(orgTagRelList);
        }
        return umcOrgInfoDO;
    }

    @Override
    public Map<Long, String> getOrgFullNameByOrgIds(SmcUmcOrgInfoQryDO qryOrgDO) {
        HashMap<Long, String> orgFullNameMap = new HashMap<Long, String>();
        SmcUmcOrgInfoExtPo umcOrgInfoPo = new SmcUmcOrgInfoExtPo();
        umcOrgInfoPo.setOrgIds(qryOrgDO.getOrgIds());
        List<SmcUmcOrgInfoPo> umcOrgInfoPoList = this.umcOrgInfoMapper.getList(umcOrgInfoPo);
        if (CollectionUtils.isEmpty(umcOrgInfoPoList)) {
            throw new ZTBusinessException("\u673a\u6784\u4e0d\u5b58\u5728");
        }
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        for (SmcUmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
            orgIdStrList.addAll(Arrays.asList(orgInfoPo.getOrgTreePath().split("-")));
        }
        HashSet orgSet = new HashSet(orgIdStrList);
        List<Long> orgIdList = orgSet.stream().map(Long::parseLong).collect(Collectors.toList());
        SmcUmcOrgInfoExtPo umcOrgInfoPo1 = new SmcUmcOrgInfoExtPo();
        umcOrgInfoPo1.setOrgIds(orgIdList);
        List<SmcUmcOrgInfoPo> aboutOrgInfoPoList = this.umcOrgInfoMapper.getList(umcOrgInfoPo1);
        if (!CollectionUtils.isEmpty(aboutOrgInfoPoList)) {
            Map<String, String> orgIdAndOrgNameMap = aboutOrgInfoPoList.stream().collect(Collectors.toMap(po -> po.getOrgId().toString(), SmcUmcOrgInfoPo::getOrgName));
            for (SmcUmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                String orgTree = orgInfoPo.getOrgTreePath();
                String[] orgTrees = orgTree.split("-");
                ArrayList<String> orgNameList = new ArrayList<String>();
                for (String orgIdStr : orgTrees) {
                    if (orgIdAndOrgNameMap.get(orgIdStr) == null || orgIdAndOrgNameMap.get(orgIdStr).equals("root")) continue;
                    orgNameList.add(orgIdAndOrgNameMap.get(orgIdStr));
                }
                String orgFullName = "";
                if (!CollectionUtils.isEmpty(orgNameList)) {
                    orgFullName = String.join((CharSequence)"-", orgNameList);
                }
                orgFullNameMap.put(orgInfoPo.getOrgId(), orgFullName);
            }
        }
        return orgFullNameMap;
    }

    @Override
    public SmcUmcOrgInfoQryRspDO qryOrgDropDownList(SmcUmcOrgInfoQryDO orgInfoQryDO) {
        SmcUmcOrgInfoExtPo qryPo = (SmcUmcOrgInfoExtPo)SmcRu.js((Object)((Object)orgInfoQryDO), SmcUmcOrgInfoExtPo.class);
        Page page = new Page();
        page.setPageNo(orgInfoQryDO.getPageNo());
        page.setPageSize(orgInfoQryDO.getPageSize());
        List<SmcUmcOrgInfoExtPo> umcOrgInfoPos = this.umcOrgInfoMapper.qryOrgDropDownList(qryPo, (Page<SmcUmcOrgInfoExtPo>)page);
        SmcUmcOrgInfoQryRspDO rspBo = new SmcUmcOrgInfoQryRspDO();
        rspBo.setPageNo(page.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(ObjectUtil.isNotEmpty(umcOrgInfoPos) ? SmcRu.jsl(umcOrgInfoPos, SmcUmcOrgInfoDO.class) : new ArrayList(0));
        return rspBo;
    }

    @Override
    public SmcUmcOrgInfoQryRspDO qryOrgDropDownTree(SmcUmcOrgInfoQryDO orgInfoQryDO) {
        SmcUmcOrgInfoExtPo qryPo = (SmcUmcOrgInfoExtPo)SmcRu.js((Object)((Object)orgInfoQryDO), SmcUmcOrgInfoExtPo.class);
        List<SmcUmcOrgInfoExtPo> umcOrgInfoPos = this.umcOrgInfoMapper.qryOrgDropDownTree(qryPo);
        SmcUmcOrgInfoQryRspDO rspBo = new SmcUmcOrgInfoQryRspDO();
        rspBo.setRows(CollectionUtils.isEmpty(umcOrgInfoPos) ? new ArrayList() : SmcRu.jsl(umcOrgInfoPos, SmcUmcOrgInfoDO.class));
        return rspBo;
    }

    @Override
    public SmcUmcOrgInfoQryRspDO batchQueryOrgInfoListByOrgIds(SmcUmcOrgInfoQryDO orgInfoQryDO) {
        SmcUmcOrgInfoQryRspDO umcOrgInfoQryRspDO = new SmcUmcOrgInfoQryRspDO();
        List<SmcUmcOrgInfoPo> umcOrgInfoPoList = this.umcOrgInfoMapper.batchQueryOrgInfoListByOrgIds(orgInfoQryDO.getOrgIds());
        List umcOrgInfoList = SmcRu.jsl(umcOrgInfoPoList, SmcUmcOrgInfoDO.class);
        umcOrgInfoQryRspDO.setRows(umcOrgInfoList);
        return umcOrgInfoQryRspDO;
    }

    @Override
    public SmcUmcOrgInfoQryRspDO getOrgInfoByTag(SmcUmcOrgInfoQryDO orgInfoQryDO) {
        SmcUmcOrgInfoExtPo qryPo = (SmcUmcOrgInfoExtPo)SmcRu.js((Object)((Object)orgInfoQryDO), SmcUmcOrgInfoExtPo.class);
        List<SmcUmcOrgInfoExtPo> umcOrgInfoPos = this.umcOrgInfoMapper.getOrgInfoByTag(qryPo);
        SmcUmcOrgInfoQryRspDO rspBo = new SmcUmcOrgInfoQryRspDO();
        rspBo.setRows(CollectionUtils.isEmpty(umcOrgInfoPos) ? new ArrayList() : SmcRu.jsl(umcOrgInfoPos, SmcUmcOrgInfoDO.class));
        if (orgInfoQryDO.getQrySideInfo().booleanValue() && ObjectUtil.isNotEmpty((Object)rspBo.getRows())) {
            this.qrySideInfo(orgInfoQryDO, umcOrgInfoPos, rspBo);
        }
        return rspBo;
    }

    @Override
    public Long getParentNoDepartmentId(String parentOrgTreePath) {
        return this.umcOrgInfoMapper.getParentNoDepartmentId(parentOrgTreePath);
    }

    private void qrySideInfo(SmcUmcOrgInfoQryDO orgInfoQryDO, List<SmcUmcOrgInfoExtPo> umcOrgInfoPos, SmcUmcOrgInfoQryRspDO rspBo) {
        List orgIds = umcOrgInfoPos.stream().map(SmcUmcOrgInfoPo::getOrgId).collect(Collectors.toList());
        LambdaQueryWrapper enterpriseInfoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)enterpriseInfoWrapper.in(SmcUmcEnterpriseInfoPo::getOrgId, orgIds)).eq(SmcUmcEnterpriseInfoPo::getDelFlag, (Object)"0");
        List enterpriseInfoList = this.umcEnterpriseInfoMapper.selectList((Wrapper)enterpriseInfoWrapper);
        Map enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(SmcUmcEnterpriseInfoPo::getOrgId, Function.identity()));
        LambdaQueryWrapper orgTagWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)orgTagWrapper.in(SmcUmcOrgTagRelPo::getOrgId, orgIds)).eq(SmcUmcOrgTagRelPo::getDelFlag, (Object)"0");
        List orgTagRelPoList = this.umcOrgTagRelMapper.selectList((Wrapper)orgTagWrapper);
        Map<Long, List<SmcUmcOrgTagRelPo>> orgTagGroup = orgTagRelPoList.stream().collect(Collectors.groupingBy(SmcUmcOrgTagRelPo::getOrgId));
        LambdaQueryWrapper enterpriseContactWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)enterpriseContactWrapper.in(SmcUmcEnterpriseContactPo::getOrgId, orgIds)).eq(SmcUmcEnterpriseContactPo::getTagId, (Object)orgInfoQryDO.getOrgTagId())).eq(SmcUmcEnterpriseContactPo::getDelFlag, (Object)"0");
        List enterpriseContactList = this.umcEnterpriseContactMapper.selectList((Wrapper)enterpriseContactWrapper);
        Map<Long, List<SmcUmcEnterpriseContactPo>> enterpriseContactGroup = enterpriseContactList.stream().collect(Collectors.groupingBy(SmcUmcEnterpriseContactPo::getOrgId));
        for (SmcUmcOrgInfoDO orgInfoDO : rspBo.getRows()) {
            if (enterpriseInfoMap.containsKey(orgInfoDO.getOrgId())) {
                orgInfoDO.setEnterpriseInfo((SmcUmcEnterpriseInfoDO)SmcRu.js(enterpriseInfoMap.get(orgInfoDO.getOrgId()), SmcUmcEnterpriseInfoDO.class));
            }
            if (orgTagGroup.containsKey(orgInfoDO.getOrgId())) {
                orgInfoDO.setOrgTagRelList(SmcRu.jsl(orgTagGroup.get(orgInfoDO.getOrgId()), SmcUmcOrgTagRelDO.class));
            }
            if (!enterpriseContactGroup.containsKey(orgInfoDO.getOrgId())) continue;
            orgInfoDO.setEnterpriseContactList(SmcRu.jsl(enterpriseContactGroup.get(orgInfoDO.getOrgId()), SmcUmcEnterpriseContactDO.class));
        }
    }
}

