/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.repository.role.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.dao.SmcSysAuthDistributeMapper;
import com.tydic.dyc.smc.po.SmcSysAuthDistributeExtPo;
import com.tydic.dyc.smc.po.SmcSysAuthDistributePo;
import com.tydic.dyc.smc.repository.role.api.SmcSysAuthDistributeRepository;
import com.tydic.dyc.smc.repository.role.bo.SmcSysRoleInfoDO;
import com.tydic.dyc.smc.repository.role.bo.SmcSysRoleInfoQryDO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmcSysAuthDistributeRepositoryImpl
extends ServiceImpl<SmcSysAuthDistributeMapper, SmcSysAuthDistributePo>
implements SmcSysAuthDistributeRepository {
    @Autowired
    private SmcSysAuthDistributeMapper sysAuthDistributeMapper;

    @Override
    public List<SmcSysRoleInfoDO> getRoleInfoListByOrg(SmcSysRoleInfoQryDO qryDO) {
        SmcSysAuthDistributeExtPo roleListWherePo = new SmcSysAuthDistributeExtPo();
        roleListWherePo.setOrgTreePath(qryDO.getOrgTreePath());
        roleListWherePo.setDisAgFLagList(qryDO.getDisAgFlagList());
        roleListWherePo.setOrgExtend(SmcUmcConstants.AuthOrgExtend.YES);
        roleListWherePo.setTagIdList(qryDO.getTagIdList());
        roleListWherePo.setRoleStatus(qryDO.getRoleStatus());
        roleListWherePo.setIsTimeRange(qryDO.getIsTimeRange());
        List<SmcSysAuthDistributeExtPo> orgRoleList = this.sysAuthDistributeMapper.getRoleListBy(roleListWherePo);
        Map orgRoleMaps = orgRoleList.stream().collect(Collectors.toMap(SmcSysAuthDistributePo::getRoleId, Function.identity(), (e1, e2) -> e2));
        roleListWherePo.setOrgTreePath(qryDO.getOrgTreePath());
        roleListWherePo.setOrgExtend(SmcUmcConstants.AuthOrgExtend.YES);
        List<SmcSysAuthDistributeExtPo> orgExtendRoleList = this.sysAuthDistributeMapper.getRoleListBy(roleListWherePo);
        Map orgExtendRoleMaps = orgExtendRoleList.stream().collect(Collectors.toMap(SmcSysAuthDistributePo::getRoleId, Function.identity(), (e1, e2) -> e2));
        orgRoleMaps.putAll(orgExtendRoleMaps);
        ArrayList rspList = new ArrayList(orgRoleMaps.values());
        return SmcRu.jsl(rspList, SmcSysRoleInfoDO.class);
    }

    @Override
    public List<SmcSysRoleInfoDO> getRoleInfoListByUser(SmcSysRoleInfoQryDO qryDO) {
        SmcSysAuthDistributeExtPo roleListWherePo = new SmcSysAuthDistributeExtPo();
        ArrayList<SmcSysRoleInfoDO> rspList = new ArrayList<SmcSysRoleInfoDO>();
        roleListWherePo.setUserId(qryDO.getUserId());
        roleListWherePo.setTagIdList(qryDO.getTagIdList());
        roleListWherePo.setDisAgFLagList(qryDO.getDisAgFlagList());
        roleListWherePo.setRoleStatus(qryDO.getRoleStatus());
        roleListWherePo.setIsTimeRange(qryDO.getIsTimeRange());
        roleListWherePo.setUserIds(qryDO.getUserIds());
        List<SmcSysAuthDistributeExtPo> orgRoleList = this.sysAuthDistributeMapper.getRoleListBy(roleListWherePo);
        if (!CollectionUtils.isEmpty(orgRoleList)) {
            rspList.addAll(SmcRu.jsl(orgRoleList, SmcSysRoleInfoDO.class));
        }
        return rspList;
    }
}

