/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.repository.todo.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.smc.constants.SmcTodoConstants;
import com.tydic.dyc.smc.dao.CfcServiceDoneConfMapper;
import com.tydic.dyc.smc.dao.CfcServiceNoticeConfMapper;
import com.tydic.dyc.smc.dao.CfcServiceTodoConfMapper;
import com.tydic.dyc.smc.dao.CfcServiceTodoNoticeSelectConfMapper;
import com.tydic.dyc.smc.dao.CfcServiceTodoNoticeSwitchMapper;
import com.tydic.dyc.smc.dao.UmcTodoConfMapper;
import com.tydic.dyc.smc.po.CfcServiceDoneConfPO;
import com.tydic.dyc.smc.po.CfcServiceNoticeConfPO;
import com.tydic.dyc.smc.po.CfcServiceTodoConfPO;
import com.tydic.dyc.smc.po.CfcServiceTodoNoticeSelectConfPO;
import com.tydic.dyc.smc.po.CfcServiceTodoNoticeSwitchPO;
import com.tydic.dyc.smc.po.UmcTodoConfPO;
import com.tydic.dyc.smc.repository.todo.api.UmcTodoConfigRepository;
import com.tydic.dyc.smc.repository.todo.bo.CfcServiceDoneConfDo;
import com.tydic.dyc.smc.repository.todo.bo.CfcServiceNoticeConfDo;
import com.tydic.dyc.smc.repository.todo.bo.CfcServiceTodoConfDo;
import com.tydic.dyc.smc.repository.todo.bo.CfcServiceTodoNoticeSelectConfDo;
import com.tydic.dyc.smc.repository.todo.bo.CfcServiceTodoNoticeSwitchDo;
import com.tydic.dyc.smc.repository.todo.bo.UmcQryAllConfigListResultDo;
import com.tydic.dyc.smc.repository.todo.bo.UmcServiceTodoCacheBO;
import com.tydic.dyc.smc.repository.todo.bo.UmcTodoConfDo;
import com.tydic.dyc.smc.repository.todo.bo.UmcTodoQryDo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcTodoConfigRepositoryImpl
implements UmcTodoConfigRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcTodoConfigRepositoryImpl.class);
    @Autowired
    private CfcServiceTodoNoticeSwitchMapper cfcServiceTodoNoticeSwitchMapper;
    @Autowired
    private CfcServiceDoneConfMapper cfcServiceDoneConfMapper;
    @Autowired
    private CfcServiceTodoConfMapper cfcServiceTodoConfMapper;
    @Autowired
    private CfcServiceNoticeConfMapper cfcServiceNoticeConfMapper;
    @Autowired
    private UmcTodoConfMapper umcTodoConfMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CfcServiceTodoNoticeSelectConfMapper cfcServiceTodoNoticeSelectConfMapper;

    @Override
    public UmcQryAllConfigListResultDo qryTodoInfoList(UmcTodoQryDo umcTodoQryDo) {
        CfcServiceTodoConfPO cfcServiceTodoConfPO;
        if (umcTodoQryDo.getTodoItemCode() != null && umcTodoQryDo.getBusiItemCode() == null) {
            cfcServiceTodoConfPO = new CfcServiceTodoConfPO();
            cfcServiceTodoConfPO.setTodoItemCode(umcTodoQryDo.getTodoItemCode());
            List<String> busiItemCodeList = this.cfcServiceTodoConfMapper.selectBusiItemCodeListByTodoItemCode(cfcServiceTodoConfPO);
            if (busiItemCodeList.isEmpty()) {
                return new UmcQryAllConfigListResultDo();
            }
            umcTodoQryDo.setBusiItemCodeList(busiItemCodeList);
        }
        if (umcTodoQryDo.getBusiItemCode() != null) {
            ArrayList<String> busiItemCodeList = new ArrayList<String>();
            busiItemCodeList.add(umcTodoQryDo.getBusiItemCode());
            umcTodoQryDo.setBusiItemCodeList(busiItemCodeList);
        }
        log.info("\u5f85\u529e\u914d\u7f6e\u67e5\u8be2\u4e8b\u9879\u96c6\u5408:" + umcTodoQryDo.getBusiItemCodeList());
        cfcServiceTodoConfPO = (CfcServiceTodoConfPO)JSON.parseObject((String)JSON.toJSONString((Object)umcTodoQryDo), CfcServiceTodoConfPO.class);
        List<CfcServiceTodoConfPO> cfcServiceTodoConfPOList = this.cfcServiceTodoConfMapper.selectListByCenterServiceIdBusiItemCodeList(cfcServiceTodoConfPO);
        List cfcServiceTodoConfDoList = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceTodoConfPOList), CfcServiceTodoConfDo.class);
        CfcServiceDoneConfPO cfcServiceDoneConfPO = (CfcServiceDoneConfPO)JSON.parseObject((String)JSON.toJSONString((Object)umcTodoQryDo), CfcServiceDoneConfPO.class);
        List<CfcServiceDoneConfPO> cfcServiceDoneConfPOList = this.cfcServiceDoneConfMapper.selectListByCenterServiceIdBusiItemCodeList(cfcServiceDoneConfPO);
        List cfcServiceDoneConfDoList = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceDoneConfPOList), CfcServiceDoneConfDo.class);
        CfcServiceNoticeConfPO cfcServiceNoticeConfPO = (CfcServiceNoticeConfPO)JSON.parseObject((String)JSON.toJSONString((Object)umcTodoQryDo), CfcServiceNoticeConfPO.class);
        List<CfcServiceNoticeConfPO> cfcServiceNoticeConfPOList = this.cfcServiceNoticeConfMapper.selectListByCenterServiceIdBusiItemCodeList(cfcServiceNoticeConfPO);
        List cfcServiceNoticeConfDoList = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceNoticeConfPOList), CfcServiceNoticeConfDo.class);
        UmcQryAllConfigListResultDo umcQryAllConfigListResultDo = new UmcQryAllConfigListResultDo();
        umcQryAllConfigListResultDo.setCfcServiceTodoConfDoList(cfcServiceTodoConfDoList);
        umcQryAllConfigListResultDo.setCfcServiceDoneConfDoList(cfcServiceDoneConfDoList);
        umcQryAllConfigListResultDo.setCfcServiceNoticeConfDoList(cfcServiceNoticeConfDoList);
        return umcQryAllConfigListResultDo;
    }

    @Override
    public void addNoticeConfig(CfcServiceNoticeConfDo cfcServiceNoticeConfDo) {
        CfcServiceNoticeConfPO cfcServiceNoticeConfPO = (CfcServiceNoticeConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceNoticeConfDo), CfcServiceNoticeConfPO.class);
        cfcServiceNoticeConfPO.setServiceNoticeConfId(Sequence.getInstance().nextId());
        if (cfcServiceNoticeConfPO.getCreateTime() == null) {
            cfcServiceNoticeConfPO.setCreateTime(new Date());
        }
        cfcServiceNoticeConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
        this.cfcServiceNoticeConfMapper.insert(cfcServiceNoticeConfPO);
    }

    @Override
    public void addDoneConfig(CfcServiceDoneConfDo cfcServiceDoneConfDo) {
        CfcServiceDoneConfPO cfcServiceDoneConfPO = (CfcServiceDoneConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceDoneConfDo), CfcServiceDoneConfPO.class);
        cfcServiceDoneConfPO.setServiceDoneConfId(Sequence.getInstance().nextId());
        if (cfcServiceDoneConfPO.getCreateTime() == null) {
            cfcServiceDoneConfPO.setCreateTime(new Date());
        }
        cfcServiceDoneConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
        this.cfcServiceDoneConfMapper.insert(cfcServiceDoneConfPO);
    }

    @Override
    public void addTodoConfig(CfcServiceTodoConfDo cfcServiceTodoConfDo) {
        CfcServiceTodoConfPO cfcServiceTodoConfPO = (CfcServiceTodoConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoConfDo), CfcServiceTodoConfPO.class);
        cfcServiceTodoConfPO.setServiceTodoConfId(Sequence.getInstance().nextId());
        if (cfcServiceTodoConfPO.getCreateTime() == null) {
            cfcServiceTodoConfPO.setCreateTime(new Date());
        }
        cfcServiceTodoConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
        this.cfcServiceTodoConfMapper.insert(cfcServiceTodoConfPO);
        if (cfcServiceTodoConfPO.getPushFlag().equals(SmcTodoConstants.PushFlag.PUSH.getCode())) {
            CfcServiceNoticeConfDo cfcServiceNoticeConfDo = (CfcServiceNoticeConfDo)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoConfPO), CfcServiceNoticeConfDo.class);
            this.addNoticeConfig(cfcServiceNoticeConfDo);
        }
    }

    @Override
    public UmcQryAllConfigListResultDo qryTodoNoticeSwitchList(UmcTodoQryDo umcTodoQryDo) {
        List<CfcServiceTodoNoticeSwitchPO> cfcServiceTodoNoticeSwitchPOList = this.cfcServiceTodoNoticeSwitchMapper.selectAll();
        List cfcServiceTodoNoticeSwitchDoList = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceTodoNoticeSwitchPOList), CfcServiceTodoNoticeSwitchDo.class);
        for (CfcServiceTodoNoticeSwitchDo cfcServiceTodoNoticeSwitchDo : cfcServiceTodoNoticeSwitchDoList) {
            if (cfcServiceTodoNoticeSwitchDo.getSendTodoFlag() != null) {
                cfcServiceTodoNoticeSwitchDo.setSendTodoFlagStr(SmcTodoConstants.SendFlag.getDescriptionByCode(cfcServiceTodoNoticeSwitchDo.getSendTodoFlag()));
            }
            if (cfcServiceTodoNoticeSwitchDo.getSendNoticeFlag() != null) {
                cfcServiceTodoNoticeSwitchDo.setSendNoticeFlagStr(SmcTodoConstants.SendFlag.getDescriptionByCode(cfcServiceTodoNoticeSwitchDo.getSendNoticeFlag()));
            }
            if (cfcServiceTodoNoticeSwitchDo.getSendDoneFlag() == null) continue;
            cfcServiceTodoNoticeSwitchDo.setSendDoneFlagStr(SmcTodoConstants.SendFlag.getDescriptionByCode(cfcServiceTodoNoticeSwitchDo.getSendDoneFlag()));
        }
        UmcQryAllConfigListResultDo umcQryAllConfigListResultDo = new UmcQryAllConfigListResultDo();
        umcQryAllConfigListResultDo.setCfcServiceTodoNoticeSwitchDoList(cfcServiceTodoNoticeSwitchDoList);
        return umcQryAllConfigListResultDo;
    }

    @Override
    public void addTodoNoticeSwitch(CfcServiceTodoNoticeSwitchDo cfcServiceTodoNoticeSwitchDo) {
        CfcServiceTodoNoticeSwitchPO cfcServiceTodoNoticeSwitchPO = (CfcServiceTodoNoticeSwitchPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchDo), CfcServiceTodoNoticeSwitchPO.class);
        int count = this.cfcServiceTodoNoticeSwitchMapper.selectCountByServiceNameAndMethodName(cfcServiceTodoNoticeSwitchPO);
        if (count > 0) {
            throw new ZTBusinessException("\u8be5\u670d\u52a1\u540d+\u65b9\u6cd5\u540d\u5df2\u5b58\u5728");
        }
        cfcServiceTodoNoticeSwitchPO.setServiceId(Sequence.getInstance().nextId());
        cfcServiceTodoNoticeSwitchPO.setCreateTime(new Date());
        cfcServiceTodoNoticeSwitchPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
        log.info("\u5f85\u529e\u901a\u77e5\u5f00\u5173\u65b0\u589e\uff1a" + JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchPO));
        this.cfcServiceTodoNoticeSwitchMapper.insert(cfcServiceTodoNoticeSwitchPO);
    }

    @Override
    public UmcQryAllConfigListResultDo qryTodoItemList(UmcTodoQryDo umcTodoQryDo) {
        List<UmcTodoConfPO> umcTodoConfPOList = this.umcTodoConfMapper.selectAll();
        List umcTodoConfDoList = JSONArray.parseArray((String)JSON.toJSONString(umcTodoConfPOList), UmcTodoConfDo.class);
        UmcQryAllConfigListResultDo umcQryAllConfigListResultDo = new UmcQryAllConfigListResultDo();
        umcQryAllConfigListResultDo.setUmcTodoConfDoList(umcTodoConfDoList);
        return umcQryAllConfigListResultDo;
    }

    @Override
    public void addUmcTodoItemConfig(UmcTodoConfDo umcTodoConfDo) {
        UmcTodoConfPO umcTodoConfPO = (UmcTodoConfPO)JSON.parseObject((String)JSON.toJSONString((Object)umcTodoConfDo), UmcTodoConfPO.class);
        int count = this.umcTodoConfMapper.selectCountByBusiItemCodeAndBusiItemName(umcTodoConfPO);
        if (count > 0) {
            throw new ZTBusinessException("\u4e1a\u52a1\u4e8b\u9879\u7f16\u7801\u6216\u4e1a\u52a1\u4e8b\u9879\u540d\u79f0\u5df2\u5b58\u5728");
        }
        umcTodoConfPO.setTodoItemId(Sequence.getInstance().nextId());
        if (umcTodoConfPO.getCreateTime() == null) {
            umcTodoConfPO.setCreateTime(new Date());
        }
        umcTodoConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
        this.umcTodoConfMapper.insert(umcTodoConfPO);
    }

    @Override
    public void deleteTodoConfig(CfcServiceTodoConfDo cfcServiceTodoConfDo) {
        CfcServiceTodoConfPO cfcServiceTodoConfPO = (CfcServiceTodoConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoConfDo), CfcServiceTodoConfPO.class);
        cfcServiceTodoConfPO.setUpdateTime(new Date());
        cfcServiceTodoConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.DELETED.getCode());
        this.cfcServiceTodoConfMapper.updateDeleteFlagByServiceTodoConfId(cfcServiceTodoConfPO);
        CfcServiceNoticeConfPO cfcServiceNoticeConfPO = (CfcServiceNoticeConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoConfPO), CfcServiceNoticeConfPO.class);
        this.cfcServiceNoticeConfMapper.updateDeleteFlagByServiceTodoConfId(cfcServiceNoticeConfPO);
    }

    @Override
    public void deleteDoneConfig(CfcServiceDoneConfDo cfcServiceDoneConfDo) {
        CfcServiceDoneConfPO cfcServiceDoneConfPO = (CfcServiceDoneConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceDoneConfDo), CfcServiceDoneConfPO.class);
        cfcServiceDoneConfPO.setUpdateTime(new Date());
        cfcServiceDoneConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.DELETED.getCode());
        this.cfcServiceDoneConfMapper.updateDeleteFlagByServiceDoneConfId(cfcServiceDoneConfPO);
    }

    @Override
    public void deleteNoticeConfig(CfcServiceNoticeConfDo cfcServiceNoticeConfDo) {
        CfcServiceNoticeConfPO cfcServiceNoticeConfPO = (CfcServiceNoticeConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceNoticeConfDo), CfcServiceNoticeConfPO.class);
        cfcServiceNoticeConfPO.setUpdateTime(new Date());
        cfcServiceNoticeConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.DELETED.getCode());
        this.cfcServiceNoticeConfMapper.updateDeleteFlagByServiceNoticeConfId(cfcServiceNoticeConfPO);
    }

    @Override
    public void deleteTodoItem(UmcTodoConfDo umcTodoConfDo) {
        UmcTodoConfPO umcTodoConfPO = (UmcTodoConfPO)JSON.parseObject((String)JSON.toJSONString((Object)umcTodoConfDo), UmcTodoConfPO.class);
        umcTodoConfPO.setUpdateTime(new Date());
        umcTodoConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.DELETED.getCode());
        this.umcTodoConfMapper.updateDeleteFlagByTodoItemId(umcTodoConfPO);
    }

    @Override
    public void deleteTodoNoticeSwitch(CfcServiceTodoNoticeSwitchDo cfcServiceTodoNoticeSwitchDo) {
        CfcServiceTodoNoticeSwitchPO cfcServiceTodoNoticeSwitchPO = (CfcServiceTodoNoticeSwitchPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchDo), CfcServiceTodoNoticeSwitchPO.class);
        cfcServiceTodoNoticeSwitchPO.setUpdateTime(new Date());
        cfcServiceTodoNoticeSwitchPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.DELETED.getCode());
        this.cfcServiceTodoNoticeSwitchMapper.updateDeleteFlagByServiceId(cfcServiceTodoNoticeSwitchPO);
        CfcServiceTodoConfPO cfcServiceTodoConfPO = (CfcServiceTodoConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchPO), CfcServiceTodoConfPO.class);
        this.cfcServiceTodoConfMapper.updateDeleteFlagByServiceId(cfcServiceTodoConfPO);
        CfcServiceDoneConfPO cfcServiceDoneConfPO = (CfcServiceDoneConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchPO), CfcServiceDoneConfPO.class);
        this.cfcServiceDoneConfMapper.updateDeleteFlagByServiceId(cfcServiceDoneConfPO);
        CfcServiceNoticeConfPO cfcServiceNoticeConfPO = (CfcServiceNoticeConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchPO), CfcServiceNoticeConfPO.class);
        this.cfcServiceNoticeConfMapper.updateDeleteFlagByServiceId(cfcServiceNoticeConfPO);
    }

    @Override
    public void updateTodoNoticeSwitch(CfcServiceTodoNoticeSwitchDo cfcServiceTodoNoticeSwitchDo) {
        CfcServiceTodoNoticeSwitchPO cfcServiceTodoNoticeSwitchPO = (CfcServiceTodoNoticeSwitchPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchDo), CfcServiceTodoNoticeSwitchPO.class);
        cfcServiceTodoNoticeSwitchPO.setUpdateTime(new Date());
        log.info("\u4fee\u6539\u503c", (Object)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchPO));
        this.cfcServiceTodoNoticeSwitchMapper.updateByServiceId(cfcServiceTodoNoticeSwitchPO);
    }

    @Override
    public void cacheRefresh() {
        log.info("\u670d\u52a1\u4ee3\u529e\u7f13\u5b58\u67e5\u8be2\u540c\u6b65redis\u5f00\u59cb==========");
        Set getkeys = this.cacheClient.getkeys("todo_conf_key_*");
        for (String getkey : getkeys) {
            this.cacheClient.delete(getkey);
        }
        CfcServiceTodoNoticeSwitchPO cfcServiceTodoNoticeSwitchNotDeletePO = new CfcServiceTodoNoticeSwitchPO();
        cfcServiceTodoNoticeSwitchNotDeletePO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
        List<CfcServiceTodoNoticeSwitchPO> cfcServiceTodoNoticeSwitchPOS = this.cfcServiceTodoNoticeSwitchMapper.selectByCondition(cfcServiceTodoNoticeSwitchNotDeletePO);
        if (cfcServiceTodoNoticeSwitchPOS.size() < 1) {
            log.info("\u670d\u52a1\u5f85\u529e\u901a\u77e5\u5f00\u5173\u672a\u914d\u7f6e==========");
            return;
        }
        for (CfcServiceTodoNoticeSwitchPO cfcServiceTodoNoticeSwitchPO : cfcServiceTodoNoticeSwitchPOS) {
            UmcServiceTodoCacheBO umcServiceTodoCacheBO = (UmcServiceTodoCacheBO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSwitchPO), UmcServiceTodoCacheBO.class);
            CfcServiceTodoConfPO cfcServiceTodoConfPO = new CfcServiceTodoConfPO();
            cfcServiceTodoConfPO.setServiceId(cfcServiceTodoNoticeSwitchPO.getServiceId());
            cfcServiceTodoConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
            List<CfcServiceTodoConfPO> cfcServiceTodoConfPOS = this.cfcServiceTodoConfMapper.selectByCondition(cfcServiceTodoConfPO);
            List cfcServiceTodoConfBOS = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceTodoConfPOS), CfcServiceTodoConfDo.class);
            umcServiceTodoCacheBO.setServiceTodoConfBoList(cfcServiceTodoConfBOS);
            CfcServiceDoneConfPO cfcServiceDoneConfPO = new CfcServiceDoneConfPO();
            cfcServiceDoneConfPO.setServiceId(cfcServiceTodoNoticeSwitchPO.getServiceId());
            cfcServiceDoneConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
            List<CfcServiceDoneConfPO> cfcServiceDoneConfPOS = this.cfcServiceDoneConfMapper.selectByCondition(cfcServiceDoneConfPO);
            List cfcServiceDoneConfBOS = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceDoneConfPOS), CfcServiceDoneConfDo.class);
            umcServiceTodoCacheBO.setServiceDoneConfBoList(cfcServiceDoneConfBOS);
            CfcServiceNoticeConfPO cfcServiceNoticeConfPO = new CfcServiceNoticeConfPO();
            cfcServiceNoticeConfPO.setServiceId(cfcServiceTodoNoticeSwitchPO.getServiceId());
            cfcServiceNoticeConfPO.setDeleteFlag(SmcTodoConstants.DeleteFlag.NOT_DELETED.getCode());
            List<CfcServiceNoticeConfPO> cfcServiceNoticeConfPOS = this.cfcServiceNoticeConfMapper.selectByCondition(cfcServiceNoticeConfPO);
            List cfcServiceNoticeConfBOS = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceNoticeConfPOS), CfcServiceNoticeConfDo.class);
            umcServiceTodoCacheBO.setServiceNoticeConfBoList(cfcServiceNoticeConfBOS);
            log.debug("cfcServiceTodoNoticeSwitchPO.getServiceName():" + cfcServiceTodoNoticeSwitchPO.getServiceName() + "." + cfcServiceTodoNoticeSwitchPO.getMethodName());
            log.debug("serviceTodoCacheBO:" + JSON.toJSONString((Object)umcServiceTodoCacheBO));
            this.cacheClient.set("todo_conf_key_" + cfcServiceTodoNoticeSwitchPO.getServiceName() + "." + cfcServiceTodoNoticeSwitchPO.getMethodName(), (Object)JSON.toJSONString((Object)umcServiceTodoCacheBO));
        }
        log.info("\u670d\u52a1\u4ee3\u529e\u7f13\u5b58\u67e5\u8be2\u540c\u6b65redis\u7ed3\u675f==========");
    }

    @Override
    public void addTodoNoticeSelectConfig(CfcServiceTodoNoticeSelectConfDo cfcServiceTodoNoticeSelectConfDo) {
        CfcServiceTodoNoticeSelectConfPO cfcServiceTodoNoticeSelectConfPO = (CfcServiceTodoNoticeSelectConfPO)JSON.parseObject((String)JSON.toJSONString((Object)cfcServiceTodoNoticeSelectConfDo), CfcServiceTodoNoticeSelectConfPO.class);
        this.cfcServiceTodoNoticeSelectConfMapper.insert(cfcServiceTodoNoticeSelectConfPO);
    }

    @Override
    public List<CfcServiceTodoNoticeSelectConfDo> qryTodoNoticeSelectConfigList(CfcServiceTodoNoticeSelectConfDo cfcServiceTodoNoticeSelectConfDo) {
        CfcServiceTodoNoticeSelectConfPO cfcServiceTodoNoticeSelectConfPO = new CfcServiceTodoNoticeSelectConfPO();
        cfcServiceTodoNoticeSelectConfPO.setCenter(cfcServiceTodoNoticeSelectConfDo.getCenter());
        cfcServiceTodoNoticeSelectConfPO.setCodeType(cfcServiceTodoNoticeSelectConfDo.getCodeType());
        List<CfcServiceTodoNoticeSelectConfPO> cfcServiceTodoNoticeSelectConfPOs = this.cfcServiceTodoNoticeSelectConfMapper.selectByCondition(cfcServiceTodoNoticeSelectConfPO);
        List cfcServiceTodoNoticeSelectConfDos = JSONArray.parseArray((String)JSON.toJSONString(cfcServiceTodoNoticeSelectConfPOs), CfcServiceTodoNoticeSelectConfDo.class);
        return cfcServiceTodoNoticeSelectConfDos;
    }
}

