/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.partUser.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.tydic.dyc.base.utils.SmcIdUtil;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.base.utils.StrUtil;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.partUser.api.SmcUmcDealPartUserInfoSyncService;
import com.tydic.dyc.smc.partUser.bo.SmcUmcDealPartUserInfoBO;
import com.tydic.dyc.smc.partUser.bo.SmcUmcDealPartUserInfoSyncReqBO;
import com.tydic.dyc.smc.partUser.bo.SmcUmcDealPartUserInfoSyncRspBO;
import com.tydic.dyc.smc.po.SmcSysAuthDistributePo;
import com.tydic.dyc.smc.po.SmcSysRoleInfoPo;
import com.tydic.dyc.smc.po.SmcUmcExtPartUserSyncLogsPo;
import com.tydic.dyc.smc.po.SmcUmcExtPartUserSyncTempPo;
import com.tydic.dyc.smc.po.SmcUmcUserInfoPo;
import com.tydic.dyc.smc.po.SmcUmcUserTagRelPo;
import com.tydic.dyc.smc.repository.enterprise.api.SmcUmcOrgInfoRepository;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgInfoQryDO;
import com.tydic.dyc.smc.repository.enterprise.bo.SmcUmcOrgTagRelDO;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtPartUserSyncLogsRepository;
import com.tydic.dyc.smc.repository.ext.api.SmcUmcExtPartUserSyncTempRepository;
import com.tydic.dyc.smc.repository.role.api.SmcSysAuthDistributeRepository;
import com.tydic.dyc.smc.repository.role.api.SmcSysRoleInfoRepository;
import com.tydic.dyc.smc.repository.role.bo.SmcSysRoleInfoDO;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserInfoRepository;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserTagRelRepository;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserInfoDO;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserInfoQryDO;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserTagRelDO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.partUser.api.SmcUmcDealPartUserInfoSyncService"})
public class SmcUmcDealPartUserInfoSyncServiceImpl
implements SmcUmcDealPartUserInfoSyncService {
    @Autowired
    private SmcUmcOrgInfoRepository umcOrgInfoRepository;
    @Autowired
    private SmcSysRoleInfoRepository sysRoleInfoRepository;
    @Autowired
    private SmcUmcUserInfoRepository umcUserInfoRepository;
    @Autowired
    private SmcUmcUserTagRelRepository umcUserTagRelRepository;
    @Autowired
    private SmcSysAuthDistributeRepository sysAuthDistributeRepository;
    @Autowired
    private SmcUmcExtPartUserSyncTempRepository umcExtPartUserSyncTempRepository;
    @Autowired
    private SmcUmcExtPartUserSyncLogsRepository umcExtPartUserSyncLogsRepository;
    @Value(value="${dealPartUserInfoSync.dealUserMaxCount}")
    private Integer dealUserMaxCount;
    private static final String authorityType = "auth:system:manage";

    @Override
    @PostMapping(value={"dealPartUserInfoSync"})
    public SmcUmcDealPartUserInfoSyncRspBO dealPartUserInfoSync(@RequestBody SmcUmcDealPartUserInfoSyncReqBO reqBO) {
        List regAccountList = reqBO.getDealPartUserInfoBOList().stream().map(SmcUmcDealPartUserInfoBO::getRegAccount).collect(Collectors.toList());
        List orgCodeList = reqBO.getDealPartUserInfoBOList().stream().map(SmcUmcDealPartUserInfoBO::getOrgCode).collect(Collectors.toList());
        List authIdentityList = reqBO.getDealPartUserInfoBOList().stream().flatMap(item -> item.getAuthIdentityList().stream()).distinct().collect(Collectors.toList());
        List<Long> ids = reqBO.getDealPartUserInfoBOList().stream().map(SmcUmcDealPartUserInfoBO::getId).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(reqBO.getFailIdList())) {
            this.dealLogs(reqBO.getFailIdList(), SmcUmcConstants.DealResult.FAIL, "\u5fc5\u4f20\u53c2\u6570\u7f3a\u5931");
        }
        SmcUmcOrgInfoQryDO orgInfoQryDO = new SmcUmcOrgInfoQryDO();
        orgInfoQryDO.setOrgCodes(orgCodeList);
        orgInfoQryDO.setOrgTagId("2");
        orgInfoQryDO.setQrySideInfo(Boolean.TRUE);
        List umcOrgInfoDOList = this.umcOrgInfoRepository.getOrgInfoByTag(orgInfoQryDO).getRows();
        if (ObjectUtil.isEmpty((Object)umcOrgInfoDOList)) {
            this.updateDealStatus(ids, SmcUmcConstants.DealResult.NEXT, "\u673a\u6784\u6570\u636e\u672a\u540c\u6b65");
            return (SmcUmcDealPartUserInfoSyncRspBO)SmcRu.success(SmcUmcDealPartUserInfoSyncRspBO.class);
        }
        Map<String, SmcUmcOrgInfoDO> orgInfoMap = umcOrgInfoDOList.stream().collect(Collectors.toMap(SmcUmcOrgInfoDO::getOrgCode, Function.identity()));
        SmcUmcUserInfoQryDO userInfoQryDO = new SmcUmcUserInfoQryDO();
        userInfoQryDO.setRegAccountList(regAccountList);
        userInfoQryDO.setQrySideInfo(Boolean.TRUE);
        List umcCustInfoPoList = this.umcUserInfoRepository.qryUserInfoList(userInfoQryDO).getRows();
        if (ObjectUtil.isEmpty((Object)umcCustInfoPoList)) {
            this.updateDealStatus(ids, SmcUmcConstants.DealResult.NEXT, "\u4e3b\u804c\u6570\u636e\u672a\u540c\u6b65");
            return (SmcUmcDealPartUserInfoSyncRspBO)SmcRu.success(SmcUmcDealPartUserInfoSyncRspBO.class);
        }
        Map<String, SmcUmcUserInfoDO> custOrgInfoMap = umcCustInfoPoList.stream().collect(Collectors.toMap(item -> item.getRegAccount().toUpperCase() + "_" + item.getOrgCode() + "_0", Function.identity()));
        Map<String, SmcUmcUserInfoDO> custInfoMap = umcCustInfoPoList.stream().filter(item -> "1".equals(item.getIsMain())).collect(Collectors.toMap(item -> item.getRegAccount().toUpperCase(), Function.identity()));
        HashMap<String, SmcSysRoleInfoPo> roleInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty(authIdentityList)) {
            LambdaQueryWrapper roleQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)roleQueryWrapper.in(SmcSysRoleInfoPo::getAuthIdentity, authIdentityList)).eq(SmcSysRoleInfoPo::getDelFlag, (Object)"0");
            List sysRoleInfoPoList = this.sysRoleInfoRepository.list((Wrapper)roleQueryWrapper);
            if (ObjectUtil.isEmpty((Object)sysRoleInfoPoList)) {
                this.updateDealStatus(ids, SmcUmcConstants.DealResult.NEXT, "\u89d2\u8272\u4fe1\u606f\u4e0d\u5b58\u5728");
                return (SmcUmcDealPartUserInfoSyncRspBO)SmcRu.success(SmcUmcDealPartUserInfoSyncRspBO.class);
            }
            roleInfoMap = sysRoleInfoPoList.stream().collect(Collectors.toMap(SmcSysRoleInfoPo::getAuthIdentity, Function.identity()));
        }
        HashMap<Long, String> failResultMap = new HashMap<Long, String>();
        ArrayList<Long> nextOrgIdList = new ArrayList<Long>();
        ArrayList<Long> nextCustIdList = new ArrayList<Long>();
        ArrayList<Long> successIdList = new ArrayList<Long>();
        ArrayList<String> deleteCustKey = new ArrayList<String>();
        ArrayList<SmcUmcExtPartUserSyncLogsPo> insertPartUserLogsList = new ArrayList<SmcUmcExtPartUserSyncLogsPo>();
        ArrayList<SmcUmcUserInfoPo> insertUserInfoList = new ArrayList<SmcUmcUserInfoPo>();
        ArrayList<SmcUmcUserInfoPo> updateUserInfoList = new ArrayList<SmcUmcUserInfoPo>();
        ArrayList<Long> deleteUserIdList = new ArrayList<Long>();
        ArrayList<SmcUmcUserTagRelPo> insertUserTagList = new ArrayList<SmcUmcUserTagRelPo>();
        ArrayList<SmcSysAuthDistributePo> insertUserRoleList = new ArrayList<SmcSysAuthDistributePo>();
        for (SmcUmcDealPartUserInfoBO partUserInfoBO : reqBO.getDealPartUserInfoBOList()) {
            try {
                StrUtil.noNullStringAttr((Object)partUserInfoBO);
                if (this.dealMaxCount(partUserInfoBO, orgInfoMap, custInfoMap, failResultMap)) continue;
                if (!orgInfoMap.containsKey(partUserInfoBO.getOrgCode())) {
                    nextOrgIdList.add(partUserInfoBO.getId());
                    continue;
                }
                if (!custInfoMap.containsKey(partUserInfoBO.getRegAccount().toUpperCase())) {
                    nextCustIdList.add(partUserInfoBO.getId());
                    continue;
                }
                SmcUmcOrgInfoDO orgInfo = orgInfoMap.get(partUserInfoBO.getOrgCode());
                SmcUmcUserInfoDO custInfo = custInfoMap.get(partUserInfoBO.getRegAccount().toUpperCase());
                String custMapKey = partUserInfoBO.getRegAccount().toUpperCase() + "_" + partUserInfoBO.getOrgCode() + "_0";
                if (!custOrgInfoMap.containsKey(custMapKey)) {
                    SmcUmcUserInfoPo userInfoPo = this.insertUserInfo(partUserInfoBO, custInfo, orgInfo, insertUserInfoList);
                    this.insertUserTag(orgInfo, userInfoPo, insertUserTagList, null);
                    this.insertUserRole(partUserInfoBO, roleInfoMap, userInfoPo, orgInfo, insertUserRoleList, null);
                    custOrgInfoMap.put(partUserInfoBO.getRegAccount().toUpperCase() + "_" + partUserInfoBO.getOrgCode() + "_1", new SmcUmcUserInfoDO());
                    successIdList.add(partUserInfoBO.getId());
                } else {
                    SmcUmcUserInfoDO umcUserInfoDO = custOrgInfoMap.get(custMapKey);
                    SmcUmcUserInfoPo userInfoPo = this.updateUserInfo(partUserInfoBO, umcUserInfoDO, updateUserInfoList);
                    List<String> oldTagList = umcUserInfoDO.getUserTagList().stream().map(SmcUmcUserTagRelDO::getTagId).collect(Collectors.toList());
                    this.insertUserTag(orgInfo, userInfoPo, insertUserTagList, oldTagList);
                    List<Long> oldRoleList = umcUserInfoDO.getUserRoleList().stream().map(SmcSysRoleInfoDO::getRoleId).collect(Collectors.toList());
                    this.insertUserRole(partUserInfoBO, roleInfoMap, userInfoPo, orgInfo, insertUserRoleList, oldRoleList);
                    custOrgInfoMap.remove(partUserInfoBO.getRegAccount().toUpperCase() + "_" + partUserInfoBO.getOrgCode() + "_0");
                    custOrgInfoMap.put(partUserInfoBO.getRegAccount().toUpperCase() + "_" + partUserInfoBO.getOrgCode() + "_1", umcUserInfoDO);
                    successIdList.add(partUserInfoBO.getId());
                }
            }
            catch (Exception e) {
                failResultMap.put(partUserInfoBO.getId(), e.getMessage());
            }
            this.dealDeleteUser(reqBO, custOrgInfoMap, deleteCustKey, deleteUserIdList);
            this.dealInsert(insertUserInfoList, insertUserTagList, insertUserRoleList);
            this.dealUpdate(updateUserInfoList);
            this.dealDelete(deleteUserIdList);
            this.dealTemp(failResultMap, reqBO.getFailIdList(), insertPartUserLogsList, nextOrgIdList, nextCustIdList, successIdList);
        }
        return (SmcUmcDealPartUserInfoSyncRspBO)SmcRu.success(SmcUmcDealPartUserInfoSyncRspBO.class);
    }

    private void dealDelete(List<Long> deleteUserIdList) {
        if (ObjectUtil.isNotEmpty(deleteUserIdList)) {
            LambdaUpdateWrapper delUserWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delUserWrapper.in(SmcUmcUserInfoPo::getUserId, deleteUserIdList)).set(SmcUmcUserInfoPo::getDelFlag, (Object)"1");
            this.umcUserInfoRepository.update((Wrapper)delUserWrapper);
            LambdaUpdateWrapper delUserTagWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delUserTagWrapper.in(SmcUmcUserTagRelPo::getUserId, deleteUserIdList)).set(SmcUmcUserTagRelPo::getDelFlag, (Object)"1");
            this.umcUserTagRelRepository.update((Wrapper)delUserTagWrapper);
            LambdaUpdateWrapper delUserRoleWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)delUserRoleWrapper.in(SmcSysAuthDistributePo::getUserId, deleteUserIdList)).set(SmcSysAuthDistributePo::getDelFlag, (Object)"1");
            this.sysAuthDistributeRepository.update((Wrapper)delUserRoleWrapper);
        }
    }

    private void dealDeleteUser(SmcUmcDealPartUserInfoSyncReqBO reqBO, Map<String, SmcUmcUserInfoDO> custOrgInfoMap, List<String> deleteCustKey, List<Long> deleteUserIdList) {
        for (String key : custOrgInfoMap.keySet()) {
            String dealStatus = key.split("_")[2];
            if (!"0".equals(dealStatus)) continue;
            deleteCustKey.add(SmcUmcDealPartUserInfoSyncServiceImpl.removeLastUnderscoreAndSuffix(key));
        }
        if (ObjectUtil.isNotEmpty(deleteCustKey)) {
            LambdaQueryWrapper queryTempWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryTempWrapper.eq(SmcUmcExtPartUserSyncTempPo::getBatchId, (Object)reqBO.getBatchId())).in(SmcUmcExtPartUserSyncTempPo::getExtObjId, deleteCustKey);
            List tempList = this.umcExtPartUserSyncTempRepository.list((Wrapper)queryTempWrapper);
            Map tempMap = tempList.stream().collect(Collectors.toMap(SmcUmcExtPartUserSyncTempPo::getExtObjId, Function.identity()));
            LambdaQueryWrapper queryLogsWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryLogsWrapper.eq(SmcUmcExtPartUserSyncLogsPo::getBatchId, (Object)reqBO.getBatchId())).in(SmcUmcExtPartUserSyncLogsPo::getExtObjId, deleteCustKey);
            List logsList = this.umcExtPartUserSyncLogsRepository.list((Wrapper)queryLogsWrapper);
            Map logsMap = logsList.stream().collect(Collectors.toMap(SmcUmcExtPartUserSyncLogsPo::getExtObjId, Function.identity()));
            deleteCustKey.forEach(delete -> {
                if (!tempMap.containsKey(delete) && !logsMap.containsKey(delete)) {
                    deleteUserIdList.add(((SmcUmcUserInfoDO)custOrgInfoMap.get(delete + "_0")).getUserId());
                }
            });
        }
    }

    private void dealTemp(Map<Long, String> failResultMap, List<Long> failIdList, List<SmcUmcExtPartUserSyncLogsPo> insertUserLogsList, List<Long> nextOrgIdList, List<Long> nextCustIdList, List<Long> successIdList) {
        LambdaUpdateWrapper nextUserDeal;
        if (ObjectUtil.isNotEmpty(failResultMap)) {
            ArrayList<Long> dealFailIdList = new ArrayList<Long>(failResultMap.keySet());
            List dealFailTempList = this.umcExtPartUserSyncTempRepository.listByIds(dealFailIdList);
            dealFailTempList.forEach(temp -> {
                SmcUmcExtPartUserSyncLogsPo logs = (SmcUmcExtPartUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtPartUserSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc((String)failResultMap.get(temp.getId()));
                insertUserLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(failIdList)) {
            List failTempList = this.umcExtPartUserSyncTempRepository.listByIds(failIdList);
            failTempList.forEach(temp -> {
                SmcUmcExtPartUserSyncLogsPo logs = (SmcUmcExtPartUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtPartUserSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.FAIL);
                logs.setDealResultDesc("\u5fc5\u4f20\u53c2\u6570\u7f3a\u5931");
                insertUserLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(nextOrgIdList)) {
            nextUserDeal = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)nextUserDeal.in(SmcUmcExtPartUserSyncTempPo::getId, nextOrgIdList)).set(SmcUmcExtPartUserSyncTempPo::getDealTime, (Object)new Date())).set(SmcUmcExtPartUserSyncTempPo::getDealResult, (Object)SmcUmcConstants.DealResult.NEXT);
            this.umcExtPartUserSyncTempRepository.update((Wrapper)nextUserDeal);
        }
        if (ObjectUtil.isNotEmpty(nextCustIdList)) {
            nextUserDeal = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)nextUserDeal.in(SmcUmcExtPartUserSyncTempPo::getId, nextCustIdList)).set(SmcUmcExtPartUserSyncTempPo::getDealTime, (Object)new Date())).set(SmcUmcExtPartUserSyncTempPo::getDealResult, (Object)SmcUmcConstants.DealResult.NEXT);
            this.umcExtPartUserSyncTempRepository.update((Wrapper)nextUserDeal);
        }
        if (ObjectUtil.isNotEmpty(successIdList)) {
            List successTemp = this.umcExtPartUserSyncTempRepository.listByIds(successIdList);
            successTemp.forEach(temp -> {
                SmcUmcExtPartUserSyncLogsPo logs = (SmcUmcExtPartUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtPartUserSyncLogsPo.class);
                logs.setDealTime(new Date());
                logs.setDealResult(SmcUmcConstants.DealResult.SUCCESS);
                logs.setDealResultDesc("\u5904\u7406\u6210\u529f");
                insertUserLogsList.add(logs);
            });
        }
        if (ObjectUtil.isNotEmpty(insertUserLogsList)) {
            List ids = insertUserLogsList.stream().map(SmcUmcExtPartUserSyncLogsPo::getId).collect(Collectors.toList());
            this.umcExtPartUserSyncLogsRepository.saveBatch(insertUserLogsList);
            this.umcExtPartUserSyncTempRepository.removeBatchByIds(ids);
        }
    }

    private void dealUpdate(List<SmcUmcUserInfoPo> updateUserInfoList) {
        if (ObjectUtil.isNotEmpty(updateUserInfoList)) {
            updateUserInfoList.forEach(updateUserInfo -> this.umcUserInfoRepository.updateById(updateUserInfo));
        }
    }

    private void dealInsert(List<SmcUmcUserInfoPo> insertUserInfoList, List<SmcUmcUserTagRelPo> insertUserTagList, List<SmcSysAuthDistributePo> insertUserRoleList) {
        if (ObjectUtil.isNotEmpty(insertUserInfoList)) {
            this.umcUserInfoRepository.saveBatch(insertUserInfoList);
        }
        if (ObjectUtil.isNotEmpty(insertUserTagList)) {
            this.umcUserTagRelRepository.saveBatch(insertUserTagList);
        }
        if (ObjectUtil.isNotEmpty(insertUserRoleList)) {
            this.sysAuthDistributeRepository.saveBatch(insertUserRoleList);
        }
    }

    private SmcUmcUserInfoPo updateUserInfo(SmcUmcDealPartUserInfoBO partUserInfoBO, SmcUmcUserInfoDO umcUserInfoDO, List<SmcUmcUserInfoPo> updateUserInfoList) {
        SmcUmcUserInfoPo userInfoPo = new SmcUmcUserInfoPo();
        userInfoPo.setUserId(umcUserInfoDO.getUserId());
        userInfoPo.setStopStatus(partUserInfoBO.getStopStatus());
        if (ObjectUtil.isNotEmpty((Object)partUserInfoBO.getUpdateOperId())) {
            userInfoPo.setUpdateOperId(partUserInfoBO.getUpdateOperId());
        } else {
            userInfoPo.setUpdateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isNotEmpty((Object)partUserInfoBO.getUpdateOperName())) {
            userInfoPo.setUpdateOperName(partUserInfoBO.getUpdateOperName());
        } else {
            userInfoPo.setUpdateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isNotEmpty((Object)partUserInfoBO.getUpdateTime())) {
            userInfoPo.setUpdateTime(partUserInfoBO.getUpdateTime());
        } else {
            userInfoPo.setUpdateTime(new Date());
        }
        updateUserInfoList.add(userInfoPo);
        return userInfoPo;
    }

    private void insertUserRole(SmcUmcDealPartUserInfoBO partUserInfoBO, Map<String, SmcSysRoleInfoPo> roleInfoMap, SmcUmcUserInfoPo userInfoPo, SmcUmcOrgInfoDO orgInfo, List<SmcSysAuthDistributePo> insertUserRoleList, List<Long> oldRoleList) {
        if (ObjectUtil.isEmpty(partUserInfoBO.getAuthIdentityList())) {
            for (String roleCode : partUserInfoBO.getAuthIdentityList()) {
                if (!roleInfoMap.containsKey(roleCode) || ObjectUtil.isNotEmpty(oldRoleList) && oldRoleList.contains(roleInfoMap.get(roleCode).getRoleId())) continue;
                SmcSysAuthDistributePo userRolePo = new SmcSysAuthDistributePo();
                userRolePo.setAuthId(Long.valueOf(SmcIdUtil.nextId()));
                userRolePo.setUserId(userInfoPo.getUserId());
                userRolePo.setRoleId(roleInfoMap.get(roleCode).getRoleId());
                userRolePo.setDisFlag(SmcUmcConstants.AuthDisFlag.USER);
                userRolePo.setOrgExtend(SmcUmcConstants.AuthOrgExtend.NO);
                userRolePo.setDisAgFlag(SmcUmcConstants.AuthDisAgFlag.VIEW);
                userRolePo.setCreateTime(new Date());
                userRolePo.setCreateOperId(userInfoPo.getCreateOperId());
                userRolePo.setCreateOperName(userInfoPo.getCreateOperName());
                userRolePo.setDelFlag(userInfoPo.getDelFlag());
                userRolePo.setManageLevel(orgInfo.getManageLevel());
                insertUserRoleList.add(userRolePo);
            }
        }
    }

    private void insertUserTag(SmcUmcOrgInfoDO orgInfo, SmcUmcUserInfoPo userInfoPo, List<SmcUmcUserTagRelPo> insertUserTagList, List<String> oldTagList) {
        for (SmcUmcOrgTagRelDO orgTag : orgInfo.getOrgTagRelList()) {
            if (ObjectUtil.isNotEmpty(oldTagList) && oldTagList.contains(orgTag.getTagId())) continue;
            SmcUmcUserTagRelPo userTagRelPo = new SmcUmcUserTagRelPo();
            userTagRelPo.setRelId(Long.valueOf(SmcIdUtil.nextId()));
            userTagRelPo.setUserId(userInfoPo.getUserId());
            userTagRelPo.setTenantId(userInfoPo.getTenantId());
            userTagRelPo.setTagId(orgTag.getTagId());
            userTagRelPo.setIsDefalt("0");
            userTagRelPo.setCreateTime(new Date());
            userTagRelPo.setCreateOperId(userInfoPo.getCreateOperId());
            userTagRelPo.setCreateOperName(userInfoPo.getCreateOperName());
            userTagRelPo.setDelFlag(userInfoPo.getDelFlag());
            if ("0".equals(orgTag.getTagId())) {
                userTagRelPo.setIsDefalt("1");
            }
            insertUserTagList.add(userTagRelPo);
        }
    }

    private SmcUmcUserInfoPo insertUserInfo(SmcUmcDealPartUserInfoBO partUserInfoBO, SmcUmcUserInfoDO custInfo, SmcUmcOrgInfoDO orgInfo, List<SmcUmcUserInfoPo> insertUserInfoList) {
        SmcUmcUserInfoPo userInfoPo = new SmcUmcUserInfoPo();
        userInfoPo.setUserId(Long.valueOf(SmcIdUtil.nextId()));
        userInfoPo.setCustId(custInfo.getCustId());
        userInfoPo.setTenantId(custInfo.getTenantId());
        userInfoPo.setMainCustId(userInfoPo.getCustId());
        userInfoPo.setCompanyId(orgInfo.getCompanyId());
        userInfoPo.setOrgId(orgInfo.getOrgId());
        userInfoPo.setOrgTreePath(orgInfo.getOrgTreePath());
        userInfoPo.setUserType(custInfo.getCustType());
        userInfoPo.setAuthorityType(authorityType);
        userInfoPo.setIsMain("0");
        userInfoPo.setStopStatus(partUserInfoBO.getStopStatus());
        userInfoPo.setDelFlag("0");
        if (ObjectUtil.isEmpty((Object)partUserInfoBO.getCreateOperId())) {
            userInfoPo.setCreateOperId(userInfoPo.getCreateOperId());
        } else {
            userInfoPo.setCreateOperId(SmcUmcConstants.SystemUser.ID);
        }
        if (ObjectUtil.isEmpty((Object)partUserInfoBO.getCreateOperName())) {
            userInfoPo.setCreateOperName(userInfoPo.getCreateOperName());
        } else {
            userInfoPo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        if (ObjectUtil.isEmpty((Object)partUserInfoBO.getCreateTime())) {
            userInfoPo.setCreateTime(userInfoPo.getCreateTime());
        } else {
            userInfoPo.setCreateTime(new Date());
        }
        insertUserInfoList.add(userInfoPo);
        return userInfoPo;
    }

    private boolean dealMaxCount(SmcUmcDealPartUserInfoBO dealPartUserInfoBO, Map<String, SmcUmcOrgInfoDO> orgInfoMap, Map<String, SmcUmcUserInfoDO> custInfoMap, Map<Long, String> failResultMap) {
        if (dealPartUserInfoBO.getCurrentDealCount() <= this.dealUserMaxCount) {
            return false;
        }
        String orgCode = dealPartUserInfoBO.getOrgCode();
        String regAccount = dealPartUserInfoBO.getRegAccount();
        String regAccountUpper = regAccount != null ? regAccount.toUpperCase() : "";
        boolean isOrgExist = orgInfoMap.containsKey(orgCode);
        boolean isCustExist = custInfoMap.containsKey(regAccountUpper);
        String errorMessage = this.buildErrorMessage(isOrgExist, isCustExist, orgCode, regAccount);
        failResultMap.put(dealPartUserInfoBO.getId(), errorMessage);
        return true;
    }

    private String buildErrorMessage(boolean isOrgExist, boolean isCustExist, String orgCode, String regAccount) {
        if (isOrgExist && isCustExist) {
            return "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c\u6570\u636e\u65e0\u6cd5\u5904\u7406";
        }
        ArrayList<String> errors = new ArrayList<String>(2);
        if (!isOrgExist) {
            errors.add("\u6240\u5c5e\u673a\u6784\u3010" + orgCode + "\u3011\u4e0d\u5b58\u5728");
        }
        if (!isCustExist) {
            errors.add("\u6240\u5c5e\u4e3b\u804c\u7528\u6237\u3010" + regAccount + "\u3011\u4e0d\u5b58\u5728");
        }
        return "\u5904\u7406\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff0c" + String.join((CharSequence)"\uff0c\u4e14", errors);
    }

    private void updateDealStatus(List<Long> ids, Integer dealResult, String dealResultDesc) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.in(SmcUmcExtPartUserSyncTempPo::getId, ids)).set(SmcUmcExtPartUserSyncTempPo::getDealResult, (Object)dealResult)).set(SmcUmcExtPartUserSyncTempPo::getDealResultDesc, (Object)dealResultDesc)).set(SmcUmcExtPartUserSyncTempPo::getDealTime, (Object)new Date());
        this.umcExtPartUserSyncTempRepository.update((Wrapper)updateWrapper);
    }

    private void dealLogs(List<Long> ids, Integer dealResult, String dealResultDesc) {
        List failTempList = this.umcExtPartUserSyncTempRepository.listByIds(ids);
        List failLogsList = failTempList.stream().map(temp -> {
            SmcUmcExtPartUserSyncLogsPo logs = (SmcUmcExtPartUserSyncLogsPo)SmcRu.js((Object)temp, SmcUmcExtPartUserSyncLogsPo.class);
            logs.setDealTime(new Date());
            logs.setDealResult(dealResult);
            logs.setDealResultDesc(dealResultDesc);
            return logs;
        }).collect(Collectors.toList());
        this.umcExtPartUserSyncTempRepository.removeBatchByIds(ids);
        this.umcExtPartUserSyncLogsRepository.saveBatch(failLogsList);
    }

    public static String removeLastUnderscoreAndSuffix(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        int lastUnderscoreIndex = input.lastIndexOf(95);
        if (lastUnderscoreIndex != -1) {
            return input.substring(0, lastUnderscoreIndex);
        }
        return input;
    }
}

