/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.uec.atom.UecEvaCreateCheckService;
import com.tydic.uec.atom.bo.UecEvaCreateCheckReqBO;
import com.tydic.uec.atom.bo.UecEvaCreateCheckRspBO;
import com.tydic.uec.busi.UecEvaluateListQryBusiService;
import com.tydic.uec.busi.bo.UecEvaluateListQryBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateListQryBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaBrowseRecMapper;
import com.tydic.uec.dao.EvaThumbUpRecMapper;
import com.tydic.uec.dao.ReplyMapper;
import com.tydic.uec.dao.UnionQuerySqlMapper;
import com.tydic.uec.dao.po.EvaBrowseRecPO;
import com.tydic.uec.dao.po.EvaThumbUpRecPO;
import com.tydic.uec.dao.po.ReplyPO;
import com.tydic.uec.utils.CommonMethodUtil;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecEvaluateListQryBusiServiceImpl
implements UecEvaluateListQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UecEvaluateListQryBusiServiceImpl.class);
    private final UnionQuerySqlMapper unionQuerySqlMapper;
    private final UecEvaCreateCheckService uecEvaCreateCheckService;
    private final EvaThumbUpRecMapper evaThumbUpRecMapper;
    private final EvaBrowseRecMapper evaBrowseRecMapper;
    private final ReplyMapper replyMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateListQryBusiServiceImpl(UnionQuerySqlMapper unionQuerySqlMapper, UecEvaCreateCheckService uecEvaCreateCheckService, RedisUtil redisUtil, EvaThumbUpRecMapper evaThumbUpRecMapper, EvaBrowseRecMapper evaBrowseRecMapper, ReplyMapper replyMapper) {
        this.unionQuerySqlMapper = unionQuerySqlMapper;
        this.uecEvaCreateCheckService = uecEvaCreateCheckService;
        this.evaThumbUpRecMapper = evaThumbUpRecMapper;
        this.evaBrowseRecMapper = evaBrowseRecMapper;
        this.replyMapper = replyMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateListQryBusiRspBO qryEvaluateList(UecEvaluateListQryBusiReqBO reqBO) {
        boolean saveRedis = false;
        UecEvaluateListQryBusiRspBO rspBO = new UecEvaluateListQryBusiRspBO();
        Page evaPage = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.unionQuerySqlMapper.qryEvaList(reqBO));
        Set<ZSetOperations.TypedTuple<Object>> saveEvaIdTuples = null;
        Map<String, Object> saveEvaInfoMap = null;
        this.handleEvaListProcess((Page<EvaListQryInfo>)evaPage, saveEvaIdTuples, saveEvaInfoMap, reqBO.getMemIdExt());
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotalRecords((int)evaPage.getTotal());
        rspBO.setTotalPages(evaPage.getPages());
        rspBO.setRows(evaPage.getResult());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u8bc4\u4ef7\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private String getEvaListRedisKey(UecEvaluateListQryBusiReqBO reqBO) {
        String redisKey = null;
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getEvaState())) {
            boolean checkParam;
            boolean bl = checkParam = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{reqBO.getBusiSn(), reqBO.getIpAddr(), reqBO.getModId(), reqBO.getTypeCode()}) && reqBO.getIsAnonymous() == null && reqBO.getIsForward() == null && reqBO.getIsReply() == null && reqBO.getIsThumbDown() == null && reqBO.getIsThumbUp() == null && StringUtils.isNotBlank((CharSequence)reqBO.getObjId()) || StringUtils.isNotBlank((CharSequence)reqBO.getMemId());
            if (checkParam) {
                boolean isObjQry;
                boolean isMemQry = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{reqBO.getObjId(), reqBO.getLabelCode()}) && StringUtils.isNotBlank((CharSequence)reqBO.getMemId());
                boolean bl2 = isObjQry = StringUtils.isNotBlank((CharSequence)reqBO.getObjId()) && reqBO.getObjType() != null && StringUtils.isBlank((CharSequence)reqBO.getMemId());
                if (isMemQry) {
                    redisKey = "uec_eva_list_" + reqBO.getSysCode() + "_memId#" + reqBO.getMemId();
                } else if (isObjQry) {
                    redisKey = "uec_eva_list_" + reqBO.getSysCode() + "_objType#" + reqBO.getObjType() + "_objId#" + reqBO.getObjId();
                    if (StringUtils.isNotBlank((CharSequence)reqBO.getLabelCode())) {
                        redisKey = redisKey + "_label#" + reqBO.getLabelCode();
                    }
                }
            }
        }
        return redisKey;
    }

    private UecEvaluateListQryBusiRspBO returnEvaListFromRedis(String redisKey, int redisListSize, UecEvaluateListQryBusiReqBO reqBO) {
        int pageSize;
        int pageNo = reqBO.getPageNo();
        if ((pageNo - 1) * (pageSize = reqBO.getPageSize().intValue()) < redisListSize) {
            boolean notInPage;
            Object hashCount = this.redisUtil.hashGet("uec_eva_list_", redisKey + "_totalRecords");
            if (hashCount == null) {
                return null;
            }
            int totalCount = (Integer)hashCount;
            int totalPage = (totalCount - 1) / pageSize + 1;
            boolean bl = notInPage = pageNo < totalPage && pageNo * pageSize > redisListSize || pageNo == totalPage && totalCount - (totalPage - 1) * pageSize != redisListSize - (pageNo - 1) * pageSize;
            if (notInPage) {
                return null;
            }
            Set<Object> evaIds = this.redisUtil.zGet(redisKey, (pageNo - 1) * pageSize, pageNo * pageSize - 1, true);
            if (!CollectionUtils.isEmpty(evaIds)) {
                List<Object> hashObjects = this.redisUtil.hashMultiGet("uec_eva_list_", evaIds);
                if (CollectionUtils.isEmpty(hashObjects) || hashObjects.size() != evaIds.size()) {
                    this.redisUtil.zRemove(redisKey, evaIds.toArray());
                    return null;
                }
                ArrayList<EvaListQryInfo> evaList = new ArrayList<EvaListQryInfo>(hashObjects.size());
                try {
                    for (Object e : hashObjects) {
                        if (e == null) continue;
                        EvaListQryInfo evaInfo = (EvaListQryInfo)e;
                        if (evaInfo.getLikeCount() > 0) {
                            this.getUserLikeType(reqBO.getMemIdExt(), evaInfo);
                        }
                        evaList.add(evaInfo);
                    }
                }
                catch (ClassCastException e) {
                    log.error("\u8bc4\u4ef7\u5217\u8868\u67e5\u8be2\u670d\u52a1\u7f13\u5b58\u5bf9\u8c61\u8f6c\u8bc4\u4ef7\u5bf9\u8c61\u5f02\u5e38");
                    this.redisUtil.hashDel("uec_eva_list_", evaIds.toArray());
                }
                if (evaList.size() != evaIds.size()) {
                    this.redisUtil.zRemove(redisKey, evaIds.toArray());
                    return null;
                }
                UecEvaluateListQryBusiRspBO rspBO = new UecEvaluateListQryBusiRspBO();
                rspBO.setPageNo(pageNo);
                rspBO.setTotalRecords(totalCount);
                rspBO.setTotalPages(totalPage);
                rspBO.setRows(evaList);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u8bc4\u4ef7\u5217\u8868\u6210\u529f");
                return rspBO;
            }
        }
        return null;
    }

    private void handleEvaListProcess(Page<EvaListQryInfo> evaPage, Set<ZSetOperations.TypedTuple<Object>> saveEvaIdTuples, Map<String, Object> saveEvaInfoMap, Long currentMemId) {
        boolean saveRedis = saveEvaIdTuples != null;
        for (EvaListQryInfo evaInfo : evaPage.getResult()) {
            evaInfo.setIsAddEva(UecCommonConstant.NO_FLAG);
            if (evaInfo.getAddEvaInfo() == null) {
                UecEvaCreateCheckReqBO checkReqBO = new UecEvaCreateCheckReqBO();
                checkReqBO.setAddEva(true);
                checkReqBO.setReviewLen(evaInfo.getReviewLen());
                checkReqBO.setEvaTime(evaInfo.getEvaTime());
                UecEvaCreateCheckRspBO checkRspBO = this.uecEvaCreateCheckService.checkEvaValid(checkReqBO);
                if ("0000".equals(checkRspBO.getRespCode())) {
                    evaInfo.setIsAddEva(UecCommonConstant.YES_FLAG);
                }
            } else {
                int intervalDays = CommonMethodUtil.getDay(evaInfo.getEvaTime(), evaInfo.getAddEvaInfo().getEvaTime());
                evaInfo.getAddEvaInfo().setIntervalDays(Integer.valueOf(intervalDays));
            }
            if (StringUtils.isNotBlank((CharSequence)evaInfo.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(evaInfo.getIsAnonymous())) {
                evaInfo.setMemName(evaInfo.getMemName().substring(0, 1) + "***" + evaInfo.getMemName().substring(evaInfo.getMemName().length() - 1));
            }
            if (UecCommonConstant.YES_FLAG.equals(evaInfo.getIsContentHide())) {
                evaInfo.setEvaContent("\u7528\u6237\u5df2\u9690\u85cf\u8be5\u8bc4\u4ef7\u5185\u5bb9");
            }
            this.qryCountInfo(evaInfo);
            if (evaInfo.getLikeCount() > 0) {
                this.getUserLikeType(currentMemId, evaInfo);
            }
            if (!saveRedis) continue;
            saveEvaIdTuples.add((ZSetOperations.TypedTuple<Object>)new DefaultTypedTuple((Object)evaInfo.getEvaId(), Double.valueOf(evaInfo.getEvaTime().getTime())));
            saveEvaInfoMap.put(evaInfo.getEvaId(), evaInfo);
        }
    }

    private void saveEvaListIntoRedis(String redisKey, int redisListSize, int saveSize, int totalCount, Set<ZSetOperations.TypedTuple<Object>> saveEvaIdTuples, Map<String, Object> saveEvaInfoMap) {
        if (redisListSize + saveSize > 30) {
            this.redisUtil.zRemoveRange(redisKey, 0L, redisListSize + saveSize - 30 - 1);
        }
        this.redisUtil.zAddTuple(redisKey, saveEvaIdTuples, UecRedisConstant.getExpireMinutes(20, 10));
        saveEvaInfoMap.put(redisKey + "_totalRecords", totalCount);
        this.redisUtil.hashMapSet("uec_eva_list_", saveEvaInfoMap, UecRedisConstant.getExpireMinutes(20, 30));
    }

    private void qryCountInfo(EvaListQryInfo evaInfo) {
        long evaId = Long.parseLong(evaInfo.getEvaId());
        EvaThumbUpRecPO thumbUpRecParam = new EvaThumbUpRecPO();
        thumbUpRecParam.setEvaId(evaId);
        thumbUpRecParam.setState(UecCommonConstant.StateEnum.YES.value);
        thumbUpRecParam.setThumbUpType(UecCommonConstant.ThumbUpEnum.YES.value);
        int thumbUpCount = this.evaThumbUpRecMapper.getCountBy(thumbUpRecParam);
        EvaBrowseRecPO browseRecParam = new EvaBrowseRecPO();
        browseRecParam.setEvaId(evaId);
        int browseCount = this.evaBrowseRecMapper.getCountBy(browseRecParam);
        ReplyPO replyParam = new ReplyPO();
        replyParam.setObjId(String.valueOf(evaId));
        replyParam.setObjType(UecCommonConstant.ReplyType.EVALUATE);
        replyParam.setReplyState(UecCommonConstant.StateEnum.YES.value);
        int replyCount = this.replyMapper.getCountBy(replyParam);
        evaInfo.setLikeCount(Integer.valueOf(thumbUpCount));
        evaInfo.setBrowseCount(Integer.valueOf(browseCount));
        evaInfo.setReplyCount(Integer.valueOf(replyCount));
    }

    private void getUserLikeType(Long currentMemId, EvaListQryInfo evaInfo) {
        if (currentMemId != null) {
            Set<Object> likeMemIds = this.redisUtil.sGet("uec_eva_like_" + evaInfo.getEvaId());
            if (!CollectionUtils.isEmpty(likeMemIds)) {
                Optional<Object> isLike = likeMemIds.stream().filter(memId -> String.valueOf(memId).equals(String.valueOf(currentMemId))).findAny();
                evaInfo.setUserLikeType(isLike.isPresent() ? UecCommonConstant.YES_FLAG : null);
            } else {
                EvaThumbUpRecPO thumbUpRecParam = new EvaThumbUpRecPO();
                thumbUpRecParam.setEvaId(Long.parseLong(evaInfo.getEvaId()));
                thumbUpRecParam.setState(UecCommonConstant.StateEnum.YES.value);
                thumbUpRecParam.setThumbUpType(UecCommonConstant.ThumbUpEnum.YES.value);
                thumbUpRecParam.setMemId(currentMemId.toString());
                int thumbUpCount = this.evaThumbUpRecMapper.getCountBy(thumbUpRecParam);
                if (thumbUpCount > 0) {
                    evaInfo.setUserLikeType(UecCommonConstant.YES_FLAG);
                    this.redisUtil.sSet("uec_eva_like_" + evaInfo.getEvaId(), UecRedisConstant.getExpireMinutes(20, 60), currentMemId.toString());
                } else {
                    evaInfo.setUserLikeType(null);
                }
            }
        }
    }
}

