/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.uec.ability.UecEvaluateListQryAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateListQryAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateListQryAbilityRspBO;
import com.tydic.uec.busi.UecEvaluateListQryBusiService;
import com.tydic.uec.busi.bo.UecEvaluateListQryBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateListQryBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.common.bo.eva.EvaStarLevelBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.EvaStarLevelMapper;
import com.tydic.uec.dao.po.EvaStarLevelPO;
import com.tydic.uec.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_DEV/1.0.0/com.tydic.uec.ability.UecEvaluateListQryAbilityService"})
public class UecEvaluateListQryAbilityServiceImpl
implements UecEvaluateListQryAbilityService {
    private final UecEvaluateListQryBusiService uecEvaluateListQryBusiService;
    private final EvaStarLevelMapper evaStarLevelMapper;

    public UecEvaluateListQryAbilityServiceImpl(UecEvaluateListQryBusiService uecEvaluateListQryBusiService, EvaStarLevelMapper evaStarLevelMapper) {
        this.uecEvaluateListQryBusiService = uecEvaluateListQryBusiService;
        this.evaStarLevelMapper = evaStarLevelMapper;
    }

    @PostMapping(value={"qryEvaluateList"})
    public UecEvaluateListQryAbilityRspBO qryEvaluateList(@RequestBody UecEvaluateListQryAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecEvaluateListQryBusiReqBO busiReqBO = new UecEvaluateListQryBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        UecEvaluateListQryBusiRspBO busiRspBO = this.uecEvaluateListQryBusiService.qryEvaluateList(busiReqBO);
        this.qryStarLevelList(busiRspBO);
        String jsonStr = JSONObject.toJSONString((Object)((Object)busiRspBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return (UecEvaluateListQryAbilityRspBO)JSON.parseObject((String)jsonStr, UecEvaluateListQryAbilityRspBO.class);
    }

    private void qryStarLevelList(UecEvaluateListQryBusiRspBO busiRspBO) {
        if (busiRspBO != null && !CollectionUtils.isEmpty((Collection)busiRspBO.getRows())) {
            HashMap<Long, EvaListQryInfo> tempMap = new HashMap<Long, EvaListQryInfo>();
            ArrayList<Long> evaIds = new ArrayList<Long>();
            for (EvaListQryInfo evaListQryInfo : busiRspBO.getRows()) {
                evaIds.add(Long.parseLong(evaListQryInfo.getEvaId()));
                tempMap.put(Long.parseLong(evaListQryInfo.getEvaId()), evaListQryInfo);
            }
            EvaStarLevelPO starLevelParam = new EvaStarLevelPO();
            starLevelParam.setEvaIds(evaIds);
            List<EvaStarLevelPO> starLevelPOList = this.evaStarLevelMapper.getList(starLevelParam);
            if (!CollectionUtils.isEmpty(starLevelPOList)) {
                Map<Long, List<EvaStarLevelPO>> map = starLevelPOList.stream().collect(Collectors.groupingBy(EvaStarLevelPO::getEvaId));
                for (Long evaId : map.keySet()) {
                    ArrayList<EvaStarLevelBO> starLevelList = new ArrayList<EvaStarLevelBO>(starLevelPOList.size());
                    for (EvaStarLevelPO starLevelPO : map.get(evaId)) {
                        EvaStarLevelBO starLevel = new EvaStarLevelBO();
                        BeanUtils.copyProperties((Object)starLevelPO, (Object)starLevel);
                        starLevelList.add(starLevel);
                    }
                    ((EvaListQryInfo)tempMap.get(evaId)).setStarLevels(starLevelList);
                }
            }
        }
    }

    private void validArgs(UecEvaluateListQryAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u67e5\u8be2\u8bc4\u4ef7\u5217\u8868\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSysCode())) {
            throw new BusinessException("4444", "\u67e5\u8be2\u8bc4\u4ef7\u5217\u8868\u670d\u52a1\u8bc4\u4ef7\u6765\u6e90\u7cfb\u7edf[sysCode]\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() == null || reqBO.getPageNo() <= 0) {
            reqBO.setPageNo(UecCommonConstant.DEFAULT_PAGE_NO);
        }
        if (reqBO.getPageSize() == null || reqBO.getPageSize() <= 0) {
            reqBO.setPageSize(UecCommonConstant.DEFAULT_PAGE_SIZE);
        }
        if (reqBO.getEvaState() == null && StringUtils.isBlank((CharSequence)reqBO.getBusiSn())) {
            reqBO.setEvaState(UecCommonConstant.StateEnum.YES.value);
        }
    }
}

