/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.manager.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.authority.busi.api.ChangePwdOfExpireWebService;
import com.tydic.authority.busi.bo.ChangePwdIsOrNotWebReqBO;
import com.tydic.authority.busi.bo.ChangePwdIsOrNotWebRspBO;
import com.tydic.authority.busi.bo.SelectUserInfoReqBO;
import com.tydic.authority.constants.Constants;
import com.tydic.umc.base.bo.UmcRspBaseBO;
import com.tydic.umc.general.ability.api.UmcApplicationPropertyAbilityService;
import com.tydic.umc.general.ability.api.UmcQryMemIdByUserIdAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoByUserIdAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemInfoByUserIdAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQrySingleValuePropertyAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQrySingleValuePropertyAbilityRspBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.manager.VisitDomainManager;
import java.util.ArrayList;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VisitDomainManagerImpl
implements VisitDomainManager {
    private static final Logger log = LoggerFactory.getLogger(VisitDomainManagerImpl.class);
    private static final String SEC_ORIGIN_HEADER = "HT-Mall-Sec-Origin";
    @Value(value="${DOMAIN_NAME_FRONT}")
    private String DOMAIN_NAME_FRONT;
    @Value(value="${DOMAIN_NAME_MIDDLE}")
    private String DOMAIN_NAME_MIDDLE;
    @Value(value="${DOMAIN_NAME_ADMIN}")
    private String DOMAIN_NAME_ADMIN;
    @Autowired
    private CacheClient cacheTemplate;
    @Autowired
    private UmcApplicationPropertyAbilityService umcApplicationPropertyAbilityService;
    @Autowired
    private UmcQryMemIdByUserIdAbilityService umcQryMemIdByUserIdAbilityService;
    @Autowired
    private ChangePwdOfExpireWebService changePwdOfExpireWebService;

    @Override
    public UmcMemInfoBO queryUmcMemInfo(Long userId, String token) {
        String o = (String)this.cacheTemplate.get(token);
        UmcMemInfoBO uInfo = (UmcMemInfoBO)JSONObject.parseObject((String)o, UmcMemInfoBO.class);
        if (Objects.nonNull(uInfo)) {
            return uInfo;
        }
        return this.loadUserInfo(userId, token);
    }

    @Override
    public UmcRspBaseBO authOriginMatchesUserType(HttpServletRequest request, Long userId, String token) {
        String userType = this.calUserType(userId, token);
        return this.authOriginMatchesUserType(request, userType);
    }

    private String calOriginType(HttpServletRequest request) {
        String reqUrl = request.getRequestURL().toString();
        log.info("[VisitDomainManagerImpl] reqUrl:{}", (Object)reqUrl);
        if (VisitDomainManagerImpl.isReqByIp(reqUrl)) {
            return Constants.SERVER_TYPE_ORIGIN;
        }
        String secOrigin = request.getHeader(SEC_ORIGIN_HEADER);
        log.info("[VisitDomainManagerImpl] secOrigin:{}", (Object)secOrigin);
        if (StringUtils.isNotBlank((CharSequence)secOrigin)) {
            if (this.DOMAIN_NAME_MIDDLE.equals(secOrigin)) {
                return Constants.MIDDLE_TYPE_ORIGIN;
            }
            if (this.DOMAIN_NAME_ADMIN.equals(secOrigin)) {
                return Constants.ADMIN_TYPE_ORIGIN;
            }
        }
        return Constants.FRONT_TYPE_ORIGIN;
    }

    private String calUserType(Long userId, String token) {
        UmcMemInfoBO memInfo = this.queryUmcMemInfo(userId, token);
        log.info("[VisitDomainManagerImpl-calUserType] memInfo:{}", (Object)JSONUtil.toJsonStr((Object)memInfo));
        if (Objects.nonNull(memInfo) && Objects.nonNull(memInfo.getVisitUserType())) {
            return memInfo.getVisitUserType();
        }
        return Constants.VISIT_USER_TYPE_FRONT;
    }

    @Override
    public UmcRspBaseBO authOriginMatchesUserType(HttpServletRequest request, String visitUserType) {
        String originType = this.calOriginType(request);
        if (originType.equals(Constants.SERVER_TYPE_ORIGIN)) {
            return UmcRspBaseBO.ofSuccess();
        }
        if (Constants.VISIT_USER_TYPE_FRONT.equals(visitUserType) && !Constants.FRONT_TYPE_ORIGIN.equals(originType)) {
            return UmcRspBaseBO.ofFailed((String)("\u8be5\u8d26\u6237\u4e3a\u524d\u53f0\u7528\u6237\uff0c\u8bf7\u901a\u8fc7\u524d\u53f0\u5165\u53e3\u767b\u5f55: " + this.DOMAIN_NAME_FRONT));
        }
        if (Constants.VISIT_USER_TYPE_MIDDLE.equals(visitUserType) && !Constants.MIDDLE_TYPE_ORIGIN.equals(originType)) {
            return UmcRspBaseBO.ofFailed((String)("\u8be5\u8d26\u6237\u4e3a\u4e2d\u53f0\u7528\u6237\uff0c\u8bf7\u901a\u8fc7\u4e2d\u53f0\u5165\u53e3\u767b\u5f55: " + this.DOMAIN_NAME_MIDDLE));
        }
        if (Constants.VISIT_USER_TYPE_ADMIN.equals(visitUserType) && !Constants.ADMIN_TYPE_ORIGIN.equals(originType)) {
            return UmcRspBaseBO.ofFailed((String)("\u8be5\u8d26\u6237\u4e3a\u540e\u53f0\u7528\u6237\uff0c\u8bf7\u901a\u8fc7\u540e\u53f0\u5165\u53e3\u767b\u5f55: " + this.DOMAIN_NAME_ADMIN));
        }
        return UmcRspBaseBO.ofSuccess();
    }

    private UmcMemInfoBO loadUserInfo(Long userId, String token) {
        log.info("[VisitDomainManagerImpl-loadUserInfo] userId:{},token:{}", (Object)userId, (Object)token);
        UmcMemInfoBO userInfo = new UmcMemInfoBO();
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        UmcQryMemInfoByUserIdAbilityReqBO abilityReqBO = new UmcQryMemInfoByUserIdAbilityReqBO();
        abilityReqBO.setUserIdWeb(userId);
        log.info("[VisitDomainManagerImpl-loadUserInfo]-qryMemInfoByUserId,req:{}", (Object)JSONUtil.toJsonStr((Object)abilityReqBO));
        UmcQryMemInfoByUserIdAbilityRspBO rspUser = this.umcQryMemIdByUserIdAbilityService.qryMemInfoByUserId(abilityReqBO);
        log.info("[VisitDomainManagerImpl-loadUserInfo]-qryMemInfoByUserId,rspUser:{}", (Object)JSONUtil.toJsonStr((Object)rspUser));
        if (rspUser != null) {
            BeanUtils.copyProperties((Object)rspUser, (Object)userInfo);
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getMemName2());
            userInfo.setCompanyIdExt(userInfo.getCompanyId());
            userInfo.setMgOrgIdsExt(rspUser.getMgOrgIds());
            userInfo.setMemIdIn(rspUser.getMemId());
            userInfo.setOrgIdIn(userInfo.getOrgId());
            userInfo.setOrgCodeIn(rspUser.getOrgCode());
            userInfo.setUserIdIn(userInfo.getUserId());
            userInfo.setMemAffiliationExt(userInfo.getMemAffiliation());
            userInfo.setMemIdExt(rspUser.getMemId());
            userInfo.setSupSaleOrgList(rspUser.getSupSaleOrgList());
            userInfo.setIsprofess(rspUser.getIsprofess());
            userInfo.setSupId(rspUser.getSupId());
            userInfo.setSupName(rspUser.getSupName());
            userInfo.setSex(rspUser.getSex());
            userInfo.setRegEmail(rspUser.getRegEmail());
            userInfo.setPsDiscountRate(rspUser.getPsDiscountRate());
            userInfo.setOrgLevelIn(rspUser.getOrgLevel());
            userInfo.setUmcStationsListWebExt(rspUser.getUmcStationsListWeb());
            userInfo.setUsername(rspUser.getRegAccount());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setOrgCodeIn(rspUser.getOrgCode());
            userInfo.setLastLoginTime(rspUser.getLastLoginTime());
            userInfo.setLastLoginTime(rspUser.getLastLoginTime());
            userInfo.setCellphone(rspUser.getRegMobile());
            userInfo.setOrgTypeIn(rspUser.getOrgType());
            userInfo.setOrgPath(rspUser.getOrgTreePath());
            userInfo.setOrgName(rspUser.getOrgName());
            userInfo.setOldMemIdIn(rspUser.getOldMemIdIn());
            userInfo.setMemUserType(rspUser.getUserType());
            userInfo.setIntExtPropertyCook(rspUser.getIntExtPropertyCook());
            userInfo.setTradeCapacityCook(rspUser.getTradeCapacityCook());
            userInfo.setTradeUserTypeCook(rspUser.getTradeUserTypeCook());
            userInfo.setTradeUserTypeSelectCook(rspUser.getTradeUserTypeSelectCook());
            userInfo.setOrgClass(rspUser.getOrgClass());
            Long adminId = 1L;
            if (adminId.equals(rspUser.getMemId())) {
                ArrayList<Long> mgOrgIds = new ArrayList<Long>();
                mgOrgIds.add(1L);
                userInfo.setMgOrgIdsExt(mgOrgIds);
            }
            ArrayList<String> outerUserTypes = new ArrayList<String>();
            if ("2".equals(rspUser.getIsProfessionalOrgExt())) {
                if (null != rspUser.getIsBranchUnit() && 1 == rspUser.getIsBranchUnit()) {
                    outerUserTypes.add("6");
                } else {
                    outerUserTypes.add("5");
                }
            } else {
                outerUserTypes.add(rspUser.getUserType());
            }
            String loginSource = (String)this.cacheTemplate.get(token + "loginSource");
            userInfo.setLoginSource(loginSource);
            userInfo.setOuterUserTypes(outerUserTypes);
            userInfo.setWorkNo(rspUser.getWorkNo());
            UmcQrySingleValuePropertyAbilityReqBO umcQrySingleValuePropertyAbilityReqBO = new UmcQrySingleValuePropertyAbilityReqBO();
            umcQrySingleValuePropertyAbilityReqBO.setKey("staff.welfare.pay.config.enable");
            UmcQrySingleValuePropertyAbilityRspBO umcQrySingleValuePropertyAbilityRspBO = this.umcApplicationPropertyAbilityService.qrySingleValue(umcQrySingleValuePropertyAbilityReqBO);
            if ("0000".equals(umcQrySingleValuePropertyAbilityRspBO.getRespCode()) && !StringUtils.isBlank((CharSequence)umcQrySingleValuePropertyAbilityRspBO.getValue())) {
                userInfo.setStaffWelfarePayConfigEnable(Boolean.parseBoolean(umcQrySingleValuePropertyAbilityRspBO.getValue()));
            }
            log.info("[\u4f1a\u5458\u4e2d\u5fc3-\u662f\u5426\u9700\u8981\u4fee\u6539\u5bc6\u7801]-userId\uff1a{}", (Object)rspUser.getUserId());
            ChangePwdIsOrNotWebReqBO changePwdIsOrNotWebReqBO = new ChangePwdIsOrNotWebReqBO();
            changePwdIsOrNotWebReqBO.setUserId(rspUser.getUserId());
            ChangePwdIsOrNotWebRspBO changePwdIsOrNotWebRspBO = this.changePwdOfExpireWebService.changePwd(changePwdIsOrNotWebReqBO);
            if (changePwdIsOrNotWebRspBO.getChange().booleanValue()) {
                userInfo.setCheckPasswordFlag("Y");
            } else {
                userInfo.setCheckPasswordFlag("N");
            }
            log.info("[\u4f1a\u5458\u4e2d\u5fc3-\u662f\u5426\u9700\u8981\u4fee\u6539\u5bc6\u7801]-userId\uff1a{},\u7ed3\u679c:{}", (Object)rspUser.getUserId(), (Object)userInfo.getCheckPasswordFlag());
        }
        return userInfo;
    }

    private static boolean isReqByIp(String reqUrl) {
        String regex = "^http(s)?://(\\d{1,3}\\.){3}\\d{1,3}:\\d{1,5}/.*";
        return reqUrl.matches(regex);
    }
}

