/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils;

import com.ohaotian.plugin.common.util.DateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Random;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GenObjectByExcel {
    public static void genObject(File excelFile, ObjectInfo objectInfo) throws IOException {
        Cell cell;
        Row row;
        int rowNum;
        Workbook wb = GenObjectByExcel.createWorkbook(excelFile);
        Sheet sheet = wb.getSheetAt(0);
        File objectFile = new File(objectInfo.getFilePath());
        FileWriterWithEncoding writer = new FileWriterWithEncoding(objectFile, Charset.forName("UTF-8"));
        writer.write((objectInfo.getPackagePath().endsWith(";") ? objectInfo.getPackagePath() : objectInfo.getPackagePath() + ";") + "\n\n");
        writer.write("import lombok.Data;\n\n");
        writer.write("import java.io.Serializable;\n");
        boolean flagBigDecimal = false;
        boolean flagDate = false;
        boolean flagList = false;
        boolean flagMap = false;
        for (rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            row = sheet.getRow(rowNum);
            cell = row.getCell(1);
            String cellValue = cell.getStringCellValue();
            if (!flagBigDecimal && "BigDecimal".equals(cellValue)) {
                writer.write("import java.math.BigDecimal;\n");
                flagBigDecimal = true;
                continue;
            }
            if (!flagDate && "Date".equals(cellValue)) {
                writer.write("import java.util.Date;\n");
                flagDate = true;
                continue;
            }
            if (!flagList && cellValue.startsWith("List<")) {
                writer.write("import java.util.List;\n");
                flagList = true;
                continue;
            }
            if (!flagMap && cellValue.startsWith("Map<")) {
                writer.write("import java.util.Map;\n");
                flagMap = true;
                continue;
            }
            if (flagBigDecimal && flagDate && flagList && flagMap) break;
        }
        writer.write("\n/**\n * \u63cf\u8ff0\uff1a" + objectInfo.getDesc() + "\n" + " *\n" + " * @author " + objectInfo.getAuthor() + "\n" + " * @date " + DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm") + "\n" + " * <p>\n" + " **/\n");
        writer.write("@Data\npublic class " + objectInfo.getObjectName() + " implements Serializable {\n" + "\tprivate static final long serialVersionUID = " + new Random().nextLong() + "L;\n\n");
        for (rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            row = sheet.getRow(rowNum);
            cell = row.getCell(2);
            String comment = cell.getStringCellValue();
            writer.write("\t/**\n\t * " + comment + "\n" + "\t */\n");
            cell = row.getCell(1);
            String type = cell.getStringCellValue();
            writer.write("\tprivate " + type);
            cell = row.getCell(0);
            String name = cell.getStringCellValue();
            writer.write(" " + name + ";\n");
        }
        writer.write("}");
        writer.flush();
        writer.close();
    }

    private static Workbook createWorkbook(File file) throws IOException {
        boolean isE2007 = false;
        String e07Suffix = "xlsx";
        if (file.getName().endsWith(e07Suffix)) {
            isE2007 = true;
        }
        FileInputStream input = new FileInputStream(file);
        Object wb = isE2007 ? new XSSFWorkbook((InputStream)input) : new HSSFWorkbook((InputStream)input);
        return wb;
    }

    public static void main(String[] args) throws IOException {
        ObjectInfo objectInfo = new ObjectInfo();
        objectInfo.setFilePath("D:\\git\\cloud-order\\cloud-uoc\\order-api\\src\\main\\java\\com\\tydic\\order\\pec\\bo\\com.tydic.order.bo.bo.order.PebOrderAdjustPriceReqBO.java");
        objectInfo.setPackagePath("com.tydic.order.bo.bo.order;");
        objectInfo.setObjectName("com.tydic.order.bo.bo.order.PebOrderAdjustPriceReqBO");
        objectInfo.setAuthor("liao xing jun");
        objectInfo.setDesc("\u8c03\u4ef7");
        File excel = new File("C:\\Users\\lantian\\Desktop\\111.xlsx");
        GenObjectByExcel.genObject(excel, objectInfo);
        System.out.println("\u5b8c\u6210");
    }

    private static class ObjectInfo
    implements Serializable {
        private static final long serialVersionUID = 9059210326349118427L;
        private String filePath;
        private String packagePath;
        private String objectName;
        private String author;
        private String desc;

        public String getFilePath() {
            return this.filePath;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectInfo)) {
                return false;
            }
            ObjectInfo other = (ObjectInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            String this$packagePath = this.getPackagePath();
            String other$packagePath = other.getPackagePath();
            if (this$packagePath == null ? other$packagePath != null : !this$packagePath.equals(other$packagePath)) {
                return false;
            }
            String this$objectName = this.getObjectName();
            String other$objectName = other.getObjectName();
            if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObjectInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            String $packagePath = this.getPackagePath();
            result = result * 59 + ($packagePath == null ? 43 : $packagePath.hashCode());
            String $objectName = this.getObjectName();
            result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            return result;
        }

        public String toString() {
            return "GenObjectByExcel.ObjectInfo(filePath=" + this.getFilePath() + ", packagePath=" + this.getPackagePath() + ", objectName=" + this.getObjectName() + ", author=" + this.getAuthor() + ", desc=" + this.getDesc() + ")";
        }
    }
}

