package com.tydic.inner.dyc.oc.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.inner.dyc.oc.busi.bo.WcsAttachmentAddBusiReqBo;
import com.tydic.inner.dyc.oc.busi.bo.WcsAttachmentAddBusiRspBo;
import com.tydic.inner.dyc.oc.busi.service.WcsAttachmentAddBusiService;
import com.tydic.inner.dyc.oc.constants.WcsRspConstant;
import com.tydic.inner.dyc.oc.exception.BaseBusinessException;
import com.tydic.inner.dyc.oc.repository.dao.FscAttachmentMapper;
import com.tydic.inner.dyc.oc.repository.po.FscAttachmentPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：WcsAttachmentAddBusiServiceImpl
 * 说明：附件新增Busiapi实现类
 * 时间：2022/6/1 4:10 下午
 * 作者：汪成松
 */
@Service
public class WcsAttachmentAddBusiServiceImpl implements WcsAttachmentAddBusiService {
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public WcsAttachmentAddBusiRspBo addAttachment(WcsAttachmentAddBusiReqBo busiReqBo) {
        FscAttachmentPO fscAttachmentPo = JSONObject.parseObject(JSONObject.toJSONString(busiReqBo), FscAttachmentPO.class);
        int insert = fscAttachmentMapper.insert(fscAttachmentPo);
        if (insert < 1) {
            throw new BaseBusinessException(WcsRspConstant.RESP_CODE_ERROR, "新增附件失败");
        }
        WcsAttachmentAddBusiRspBo wcsAttachmentAddBusiRspBo = new WcsAttachmentAddBusiRspBo();
        wcsAttachmentAddBusiRspBo.setRespCode(WcsRspConstant.RESP_CODE_SUCCESS);
        wcsAttachmentAddBusiRspBo.setRespDesc(WcsRspConstant.RESP_DESC_SUCCESS);
        return wcsAttachmentAddBusiRspBo;
    }
}
