package com.tydic.inner.dyc.oc.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.inner.dyc.oc.ability.bo.WcsAttachmentAddAbilityReqBo;
import com.tydic.inner.dyc.oc.ability.bo.WcsAttachmentAddAbilityRspBo;
import com.tydic.inner.dyc.oc.ability.service.WcsAttachmentAddAbilityService;
import com.tydic.inner.dyc.oc.busi.bo.WcsAttachmentAddBusiReqBo;
import com.tydic.inner.dyc.oc.busi.bo.WcsAttachmentAddBusiRspBo;
import com.tydic.inner.dyc.oc.busi.service.WcsAttachmentAddBusiService;
import com.tydic.inner.dyc.oc.constants.WcsRspConstant;
import com.tydic.inner.dyc.oc.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：WcsAttachmentAddAbilityServiceImpl
 * 说明：附件新增Abilityapi实现
 * 时间：2022/6/1 3:56 下午
 * 作者：汪成松
 */
@HTServiceImpl
@Slf4j
public class WcsAttachmentAddAbilityServiceImpl implements WcsAttachmentAddAbilityService {
    @Autowired
    private WcsAttachmentAddBusiService wcsAttachmentAddBusiService;

    @Override
    public WcsAttachmentAddAbilityRspBo addAttachment(WcsAttachmentAddAbilityReqBo abilityReqBo) {
        check(abilityReqBo);
        WcsAttachmentAddBusiReqBo wcsAttachmentAddBusiReqBo = JSONObject.parseObject(JSONObject.toJSONString(abilityReqBo), WcsAttachmentAddBusiReqBo.class);
        log.debug("新增附件入参{}",wcsAttachmentAddBusiReqBo);
        WcsAttachmentAddBusiRspBo wcsAttachmentAddBusiRspBo = wcsAttachmentAddBusiService.addAttachment(wcsAttachmentAddBusiReqBo);
        log.debug("新增附件出参{}",wcsAttachmentAddBusiReqBo);
        if (!WcsRspConstant.RESP_CODE_SUCCESS.equals(wcsAttachmentAddBusiRspBo.getRespCode())) {
            throw new BaseBusinessException(wcsAttachmentAddBusiRspBo.getRespCode(), wcsAttachmentAddBusiRspBo.getRespDesc());
        }
        return JSONObject.parseObject(JSONObject.toJSONString(wcsAttachmentAddBusiRspBo), WcsAttachmentAddAbilityRspBo.class);
    }

    private void check(WcsAttachmentAddAbilityReqBo abilityReqBo){
        if (abilityReqBo.getAttachmentId() == null){
            throw new BaseBusinessException(WcsRspConstant.RESP_CODE_ERROR,"新增附件入参附件id不能为空");
        }
    }
}
