package com.tydic.dyc.act.constants;

/**
 * 标题：DycActivityConstants
 * 说明：
 * 时间： 2023-12-12 16:43
 * 作者 @author LY
 */
public class DycActivityConstants {


    /**
     * 发票类别
     */
    public static final class InvoiceClass{
        /**
         * 1:纸质发票
         */
        public static final String INVOICE_CLASS_ONE = "1";
        /**
         * 1:纸质发票(翻译)
         */
        public static final String INVOICE_CLASS_ONE_STR = "纸质发票";
        /**
         * 2:电子发票
         */
        public static final String INVOICE_CLASS_TWO = "2";
        /**
         * 2:电子发票(翻译)
         */
        public static final String INVOICE_CLASS_TWO_STR = "电子发票";
    }


    /**
     * 发票类型
     */
    public static final class InvoiceType{
        /**
         * 1:专用发票
         */
        public static final String INVOICE_TYPE_ONE = "1";
        /**
         * 1:专用发票(翻译)
         */
        public static final String INVOICE_TYPE_ONE_STR = "专用发票";
        /**
         * 2：普通发票
         */
        public static final String INVOICE_TYPE_TWO = "2";
        /**
         * 2：普通发票(翻译)
         */
        public static final String INVOICE_TYPE_TWO_STR = "普通发票";
    }

    /**
     * 活动类型
     */
    public static final class ActivityType{
        /**
         * 1:工会活动
         */
        public static final String ACTIVITY_TYPE_ONE = "1";
        /**
         * 1:工会活动(翻译)
         */
        public static final String ACTIVITY_TYPE_ONE_STR = "工会活动";
        /**
         * 2：劳防活动
         */
        public static final String ACTIVITY_TYPE_TWO = "2";
        /**
         * 2：劳防活动(翻译)
         */
        public static final String ACTIVITY_TYPE_TWO_STR = "劳防活动";
    }

    /**
     * 支付方式
     */
    public static final class ActivityPayMode{
        /**
         * 1:积分支付
         */
        public static final String ACTIVITY_PAY_MODE_ONE = "1";
        /**
         * 1:积分支付(翻译)
         */
        public static final String ACTIVITY_PAY_MODE_ONE_STR = "积分支付";
        /**
         * 2：混合支付
         */
        public static final String ACTIVITY_PAY_MODE_TWO = "2";
        /**
         * 2：混合支付(翻译)
         */
        public static final String ACTIVITY_PAY_MODE_TWO_STR = "混合支付";
    }

    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    public static final class ActivityState{
        /**
         * 1:草稿
         */
        public static final String ACTIVITY_STATE_ONE = "1";
        /**
         * 1:草稿(翻译)
         */
        public static final String ACTIVITY_STATE_ONE_STR = "草稿";
        /**
         * 2：待审批
         */
        public static final String ACTIVITY_STATE_TWO = "2";
        /**
         * 2：待审批(翻译)
         */
        public static final String ACTIVITY_STATE_TWO_STR = "审批中";
        /**
         * 3：已驳回
         */
        public static final String ACTIVITY_STATE_THREE = "3";
        /**
         * 3：已驳回(翻译)
         */
        public static final String ACTIVITY_STATE_THREE_STR = "审批驳回";
        /**
         * 4：启用
         */
        public static final String ACTIVITY_STATE_FOUR = "4";
        /**
         * 4：启用(翻译)
         */
        public static final String ACTIVITY_STATE_FOUR_STR = "待生效";
        /**
         * 5：已生效
         */
        public static final String ACTIVITY_STATE_FIVE = "5";
        /**
         * 5：已生效(翻译)
         */
        public static final String ACTIVITY_STATE_FIVE_STR = "生效中";
        /**
         * 6：停用
         */
        public static final String ACTIVITY_STATE_SIX = "6";
        /**
         * 6：停用(翻译)
         */
        public static final String ACTIVITY_STATE_SIX_STR = "已关闭";
        /**
         * 7：已失效
         */
        public static final String ACTIVITY_STATE_SEVEN = "7";
        /**
         * 7：已失效(翻译)
         */
        public static final String ACTIVITY_STATE_SEVEN_STR = "已失效";
        /**
         * 8：变更中
         */
        public static final String ACTIVITY_STATE_EIGHT = "8";
        /**
         * 8：变更中(翻译)
         */
        public static final String ACTIVITY_STATE_EIGHT_STR = "变更中";
    }

    /**
     * 业务对象类型
     */
    public static final class BusinessObject{
        /**
         * 1:活动
         */
        public static final String BUSINESS_OBJECT_MODE_ONE = "1";
        /**
         * 1:活动(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_ONE_STR = "活动";
        /**
         * 2：活动变更单
         */
        public static final String BUSINESS_OBJECT_MODE_TWO = "2";
        /**
         * 2：活动变更单(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_TWO_STR = "活动变更单";
        /**
         * 3：审批单
         */
        public static final String BUSINESS_OBJECT_MODE_THREE = "3";
        /**
         * 3：审批单(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_THREE_STR = "审批单";
    }

    /**
     *商品关联方式:1:商品池；2：商品类型；3：商品
     */
    public static final class CommodityRelaMethod{
        public static final String COMMODITY_TYPE_ONE = "1";
        public static final String COMMODITY_TYPE_ONE_STR = "商品池";
        public static final String COMMODITY_TYPE_TWO = "2";
        public static final String COMMODITY_TYPE_TWO_STR = "商品类型";
        public static final String COMMODITY_TYPE_THREE = "3";
        public static final String COMMODITY_TYPE_THREE_STR = "商品";
    }

    /**
     * 变更单状态:0：草稿；1:待审批；2：审批通过；3：已驳回
     */
    public static final class ChangeState{
        /**
         * 0:草稿
         */
        public static final String CHANGE_STATE_ZERO = "0";
        /**
         * 0:草稿(翻译)
         */
        public static final String CHANGE_STATE_ZERO_STR = "草稿";
        /**
         * 1:待审批
         */
        public static final String CHANGE_STATE_ONE = "1";
        /**
         * 1:待审批(翻译)
         */
        public static final String CHANGE_STATE_ONE_STR = "待审批";
        /**
         * 2：审批通过
         */
        public static final String CHANGE_STATE_TWO = "2";
        /**
         * 2：审批通过(翻译)
         */
        public static final String CHANGE_STATE_TWO_STR = "审批通过";
        /**
         * 3：已驳回
         */
        public static final String CHANGE_STATE_THREE = "3";
        /**
         * 3：已驳回(翻译)
         */
        public static final String CHANGE_STATE_THREE_STR = "已驳回";
    }


    /**
     * 使用类型： 1：发放，2：消费:3：退回，4：失效:
     */
    public static final class UseType{
        /**
         * 1:发放
         */
        public static final String USE_TYPE_ONE = "1";
        /**
         * 1:发放(翻译)
         */
        public static final String USE_TYPE_ONE_STR = "发放";
        /**
         * 2：消费
         */
        public static final String USE_TYPE_TWO = "2";
        /**
         * 2：消费(翻译)
         */
        public static final String USE_TYPE_TWO_STR = "消费";
        /**
         * 3：退回
         */
        public static final String USE_TYPE_THREE = "3";
        /**
         * 3：退回(翻译)
         */
        public static final String USE_TYPE_THREE_STR = "退回";
        /**
         * 4：失效
         */
        public static final String USE_TYPE_FOUR = "4";
        /**
         * 4：失效(翻译)
         */
        public static final String USE_TYPE_FOUR_STR = "失效";
    }

    public static final class OBJ_TYPE{
        //活动审批
        public static final String ACT_AUDIT = "1";
        //活动变更审批
        public static final String ACT_AUDIT_CHANGE = "2";
    }

    public static final class TAB_ID{
        //待生效
        public static final String TAB_ID_1 = "1001";
        //生效中
        public static final String TAB_ID_2 = "1002";
        //已失效
        public static final String TAB_ID_3 = "1003";
        //全部
        public static final String TAB_ID_4 = "1004";
    }
    public static final class ACT_STATE{
        //待生效对应的状态
        public static final String TAB_ID_1_STATE = "1,2,3,4,6,8";
        //生效中对应的状态
        public static final String TAB_ID_2_STATE = "5";
        //已失效对应的状态
        public static final String TAB_ID_3_STATE = "7";
        //全部对应的状态
        public static final String TAB_ID_4_STATE = "1,2,3,4,5,6,7,8";
    }


    public static final class Settle_Flag{
        //未结算
        public static final String Settle_Flag_ZERO = "0";
        //已结算
        public static final String Settle_Flag_ONE = "1";
    }

    public static final class FILE_TYPE{
        //对账单附件类型
        public static final String FILE_TYPE_BILL = "1";
        //结算单发票附件类型
        public static final String FILE_TYPE_INVOICE = "2";
    }

    public static final class FSC_ORDER_STATE{
        //已提交
        public static final Integer COMMITED = 1014;
        //开票中
        public static final Integer INVOICING = 1017;
        //已开票
        public static final Integer INVOICED = 1002;
        //已收票
        public static final Integer SIGNED = 1003;
        //开票中
        public static final Integer PAYED = 1008;
        //已驳回
        public static final Integer REJECT = 1010;
        //已取消
        public static final Integer CANCELED = 1099;
    }
}
