package com.tydic.dyc.act.service.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName DycActFscInvoiceListBO
 * @Author 14051
 * @Date 2024/4/7 11:32
 * @Version 1.0
 * @Description TODO
 **/
@Data
public class DycActFscInvoiceListBO implements Serializable {
    private static final long serialVersionUID = -3174375433571169988L;
    /**
     * 发票号码
     */
    private String invoiceId;
    /**
     * 发票代码
     */
    private String invoiceCode;
    /**
     * 普票校验码
     */
    private String verificationCode;
    /**
     * 发票日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date invoiceDate;
    /**
     * 发票金额（裸价） 保留2位小数
     */
    private BigDecimal invoiceNakedAmount;
    /**
     * 发票税率
     */
    private String invoiceTaxRate;
    /**
     * 发票税额  保留2位小数
     */
    private BigDecimal invoiceTaxAmount;
    /**
     * 价税合计 保留2位小数
     */
    private BigDecimal invoiceAmount;
    /**
     * 发票类型 2：专票 3：电票 23：数电票-增值税普通发票  24：数电票-增值税专用发票
     */
    private Integer invoiceType;
    /**
     * 电子票下载地址 电票必传
     */
    private String fileUrl;
    /**
     * 数电场景下，此字段有值，为发票xml文件链接
     */
    private String xmlSourceFileUrl;
    /**
     * 数电发票的ofd文件
     */
    private String ofdFileUrl;
    /**
     * 开票状态
     */
    private Boolean Success;
}
