package com.tydic.dyc.act.service.bo;

import com.tydic.dyc.base.bo.DycCenterRspBaseBO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 类名： DycActQuerySkuDetailsRspBO
 * 说明：商品详情查询服务--出参
 *
 * @author： lishiqing
 * 时间： 2024/4/11 17:56
 */
@Data
public class DycActQuerySkuDetailsRspBO extends DycCenterRspBaseBO {
    private static final long serialVersionUID = 1080853848941430069L;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 外部单品id
     */
    private String extSkuId;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private Integer skuStatus;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private String skuStatusDesc;
    /**
     * 协议价
     */
    private BigDecimal agreementPrice;
    /**
     * 市场价
     */
    private BigDecimal marketPrice;
    /**
     * 折扣率
     */
    private BigDecimal discount;
    /**
     * 最小起订量
     */
    private BigDecimal moq;
    /**
     * 销售单位名称
     */
    private String measureName;
    /**
     * 来源电商
     */
    private String supplierName;
    /**
     * 商品描述
     */
    private String skuPicDetailUrl;
    /**
     * 商品图片集合
     */
    private List<DycActSkuPicBO> skuPicList;
    /**
     * 商品属性集合
     */
    private List<DycActSkuParamsBO> skuParamList;
}
