package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 类名： DycActQuerySkuPageListBO
 * 说明：商品列表查询（分页）服务--领域BO
 *
 * @author： lishiqing
 * 时间： 2024/4/8 16:20
 */
@Data
public class DycActQuerySkuPageListBO implements Serializable {
    private static final long serialVersionUID = -4072368821016795194L;
    /**
     * 单品id
     */
    private Long skuId;
    /**
     * 外部单品id
     */
    private String extSkuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 图片URL
     */
    private String picUrl;
    /**
     * 京东C端链接
     */
    private String jdSkuUrl;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private Integer skuStatus;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private String skuStatusDesc;
    /**
     * 类目名称
     */
    private String catalogNameDesc;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 来源电商ID
     */
    private Long supplierId;
    /**
     * 来源电商名称
     */
    private String supplierName;
    /**
     * 来源电商编码
     */
    private String supplierCode;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 协议价
     */
    private BigDecimal agreementPrice;
    /**
     * 市场价
     */
    private BigDecimal marketPrice;
    /**
     * 折扣率
     */
    private BigDecimal discount;
    /**
     * 所属商品池
     */
    private String skuPools;
    /**
     * 好评率
     */
    private BigDecimal goodRate;
    /**
     * 商品详情
     */
    private String skuPcDetailUrl;
    /**
     * 一级类目id
     */
    private String firstCatalogId;
    /**
     * 一级类目名称
     */
    private String firstCatalogName;
    /**
     * 二级类目id
     */
    private String secondCatalogId;
    /**
     * 二级类目名称
     */
    private String secondCatalogName;
    /**
     * 三级类目id
     */
    private String threeCatalogId;
    /**
     * 三级类目名称
     */
    private String threeCatalogName;
}
