package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 ActActivityUserInfoBO
 * 说明
 * 时间 2024/4/12 13:47
 *
 * @author 唐富强
 */
@Data
public class ActivityChangeUserInfoBO implements Serializable {
    /**
     * ID
     */
    private Long id;
    /**
     * 变更单ID
     */
    private Long changeId;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 用户姓名
     */
    private String name;
    /**
     * 工号
     */
    private String workNo;
    /**
     * 性别; 1 男 2 女
     */
    private Integer sex;
    /**
     * 电话
     */
    private String phone;
    /**
     * 用户所属组织ID
     */
    private Long userOrgId;
    /**
     * 用户所属组织名称
     */
    private String userOrgName;
    /**
     * 积分状态（0：正常，1：冻结）
     */
    private Integer scoresType;
    /**
     * 发放积分（第一次的发放）
     */
    private BigDecimal giveScores;
    /**
     * 已使用积分
     */
    private BigDecimal usedScores;
    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;
    /**
     * 过期积分
     */
    private BigDecimal loseScores;
    /**
     * 剩余可用金额（按照活动代币ID中的规则转换为法币价值）
     */
    private BigDecimal effMoney;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
}
