package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 ActivityChangeRelaCommodityInfoBO
 * 说明 活动变更已选商品信息BO
 * 时间 2024/4/12 10:23
 *
 * @author 唐富强
 */
@Data
public class ActivityChangeRelaCommodityInfoBO implements Serializable {


    private static final long serialVersionUID = -5193839816466732378L;
    /**
     * 关联ID
     */
    private Long relaId;
    /**
     * 变更单ID
     */
    private Long changeId;

    /**
     * 商品池名称
     */
    private String commodityPoolName;

    /**
     * 单品ID
     */
    private Long skuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 单品图片地址
     */
    private String skuUrl;
    /**
     * 单品详情
     */
    private String skuDetails;

    /**
     * 一级类目id
     */
    private String firstCatalogId;

    /**
     * 一级类目名称
     */
    private String firstCatalogName;

    /**
     * 二级类目id
     */
    private String secondCatalogId;

    /**
     * 二级类目名称
     */
    private String secondCatalogName;

    /**
     * 三级类目id
     */
    private String threeCatalogId;

    /**
     * 三级类目名称
     */
    private String threeCatalogName;

    /**
     * C端链接
     */
    private String cterminalUrl;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 好评率
     */
    private Double favorableRate;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
}
