package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycActSaveActiveBaseInfoReqBO
 * 说明：
 * 时间： 2023-12-13 14:20
 * 作者 @author LY
 */
@Data
public class DycActSaveActiveBaseInfoReqBO implements Serializable {

    private static final long serialVersionUID = -6435622811917487348L;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动场景id
     */
    private Long activitySceneId;
    /**
     * 活动场景名称
     */
    private String activitySceneCode;
    /**
     * 活动场景名称
     */
    private String activitySceneName;
    /**
     * 活动PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * 活动浮窗图url
     */
    private String emergePicUrl;
    /**
     * 活动app端banner图url
     */
    private String appBannerPicUrl;
    /**
     * 发票ID
     */
    private Long invoiceId;
    /**
     * 发票抬头
     */
    private String invoiceTitle;
    /**
     * 发票类别;1:纸质发票 2:电子发票
     */
    private Integer invoiceClass;
    /**
     * 发票类型:1:专用发票；2：普通发票

     */
    private Integer invoiceType;
    /**
     * 发票纳税人识别号
     */
    private String invoiceTaxpayerId;
    /**
     * 发票开户银行
     */
    private String invoiceBank;
    /**
     * 发票开户银行账户
     */
    private String invoiceBankAccount;
    /**
     * 发票地址
     */
    private String invoiceAddress;
    /**
     * 发票电话
     */
    private String invoicePhone;
    /**
     * 发票地址Id
     */
    private Long invoiceAddrId;
    /**
     * 发票地址省编码
     */
    private String provinceId;
    /**
     * 发票地址省名称
     */
    private String provinceName;
    /**
     * 发票地址地市名称
     */
    private String cityName;
    /**
     * 发票地址地市编号
     */
    private String cityId;
    /**
     * 发票地址乡镇编号
     */
    private String townName;
    /**
     * 发票地址乡镇名称
     */
    private String townId;
    /**
     * 发票地址区县名称
     */
    private String countyName;
    /**
     * 发票地址区县编号
     */
    private String countyId;
    /**
     * 发票地址联系人
     */
    private String contactName;
    /**
     * 发票地址联系人电话
     */
    private String contactPhone;
    /**
     * 发票地址联系人邮箱
     */
    private String contactEmial;
    /**
     * 活动类型:1:工会活动；2：劳防活动
     */
    private Integer activityType;
    /**
     * 活动期限:1:有限期，2:无限期
     */
    private Integer activityCycleType;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 支付方式:1:积分支付；2：混合支付
     */
    private Integer activityPayMode;
    /**
     * 活动备注
     */
    private String remark;
    /**
     * 商品最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 商品最低价格
     */
    private BigDecimal minPrice;
    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Integer commodityRelaMethod;
    /**
     * 创建人ID
     */
    private Long userId;
    /**
     * 创建人名称
     */
    private String name;
    /**
     * 活动附件列表
     */
    private List<DycActActiveFileInfoBO> fileInfoBOS;
    /**
     * 活动供应商集合
     */
    private List<DycActActivitySupplierInfoBO> activitySupplierList;
}
