package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 DycActUserScoresBaseInfoBO
 * 说明 用户积分信息BO
 * 时间 2024/4/16 11:43
 *
 * @author 唐富强
 */
@Data
public class DycActUserScoresBaseInfoBO implements Serializable {


    private static final long serialVersionUID = -1850583023747373703L;
    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动场景id
     */
    private Long activitySceneId;

    /**
     * 活动场景名称
     */
    private String activitySceneName;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 活动类型翻译
     */
    private String activityTypeStr;

    /**
     * 活动开始时间
     */
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    private Date activityEndTime;

    /**
     * 活动状态
     */
    private String activityState;

    /**
     * 活动状态翻译
     */
    private String activityStateStr;

    /**
     * 发放积分
     */
    private BigDecimal giveScores;

    /**
     * 已使用积分
     */
    private BigDecimal usedScores;

    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * 活动浮窗图url
     */
    private String emergePicUrl;
    /**
     * 活动app端banner图url
     */
    private String appBannerPicUrl;

    /**
     * 用户id
     */
    private Long userId;
}
