package com.tydic.dyc.act.service.bo;

import com.tydic.dyc.base.bo.DycCenterPageReqBaseBO;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：DycActQueryCatalogListReqBO
 * 说明：
 * 时间：2024/4/10 16:46
 * 作者：Zhouhaifeng
 */
@Data
public class DycActQueryCatalogListReqBO extends DycCenterPageReqBaseBO {
    /**
     * 类目编码
     */
    private String catalogCode;
    /**
     * 类目名称
     */
    private String catalogName;
    /**
     * 创建人
     */
    private String createOperName;
    /**
     * 更新人
     */
    private String updateOperName;
    /**
     * 创建开始时间
     */
    private Date createStartTime;
    /**
     * 创建结束时间
     */
    private Date createStopTime;
    /**
     * 更新开始时间
     */
    private Date updateStartTime;
    /**
     * 更新结束时间
     */
    private Date updateStopTime;
    /**
     * 父类目ID
     */
    private Long upperCatalogId;
    /**
     * 查询方式 1普通查询 2带条件搜索查询
     */
    private Integer qryFlag;

    public boolean check() {
        return !StringUtils.isEmpty(catalogCode) || !StringUtils.isEmpty(catalogName)
                || !StringUtils.isEmpty(updateOperName) || !StringUtils.isEmpty(createOperName)
                || null != createStartTime || null != updateStartTime;
    }
}
