package com.tydic.dyc.act.service.bo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题 ActActivityMyScoreListReqBO
 * 说明 用户积分信息查询入参
 * 时间 2024/4/16 11:38
 *
 * @author 唐富强
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DycActQueryUserScoresPageListReqBO extends BasePageReqBo {


    private static final long serialVersionUID = -2650588346809989083L;
    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动场景id
     */
    private Long activitySceneId;

    /**
     * 活动类型:1:工会活动；2：公司活动
     */
    private Integer activityType;

    /**
     * 活动状态
     */
    private String activityState;

    /**
     * 排序规则
     */
    private String orderBy;

    /**
     * 1001全部 1002进行中 1003未开始 1004已结束（不传查询生效中和待生效的）
     */
    private Integer tabId;


    /**
     * 活动结束时间
     */
    private Date activityEndTimeStart;
    /**
     * 活动结束时间
     */
    private Date activityEndTimeEnd;

    /**
     * 剩余积分最小值
     */
    private BigDecimal balanceScoresMin;
    /**
     * 剩余积分最大值
     */
    private BigDecimal balanceScoresMax;

    /**
     * 是否已经发送预警通知：1：发送 0或空:未发送
     */
    private Integer isNotify;


    /**
     * 活动状态集合
     */
    private List<String> activityStateList;

}
