package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ActivityChangeInfoPO
 * @Description: ActivityChangeInfoPO
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityChangeInfoBO implements Serializable {


	private static final long serialVersionUID = -3256596967059828465L;
	/**
	 * 变更单ID
	 */
    private Long changeId;
	/**
	 * 变更单编号
	 */
    private String changeCode;
	/**
	 * 变更原因
	 */
    private String changeReason;
	/**
	 * 变更单状态:1:待审批；2：审批通过；3：已驳回
	 */
    private String changeState;
	/**
	 * 原活动id
	 */
    private Long originalActivityId;
	/**
	 * 原活动版本号
	 */
    private Integer originalActivityVersion;
	/**
	 * 原活动编号
	 */
    private String originalActivityCode;
	/**
	 * 活动适用组织id
	 */
    private Long activityScopeOrgId;
	/**
	 * 活动适用组织名称
	 */
    private String activityScopeOrgName;
	/**
	 * 活动名称
	 */
    private String activityName;
	/**
	 * 发票ID
	 */
    private Long invoiceId;
	/**
	 * 发票抬头
	 */
    private String invoiceTitle;
	/**
	 * 发票类别;1:纸质发票 2:电子发票
	 */
    private Integer invoiceClass;
	/**
	 * 发票类型:1:专用发票；2：普通发票
            
	 */
    private Integer invoiceType;
	/**
	 * 发票纳税人识别号
	 */
    private String invoiceTaxpayerId;
	/**
	 * 发票开户银行
	 */
    private String invoiceBank;
	/**
	 * 发票开户银行账户
	 */
    private String invoiceBankAccount;
	/**
	 * 发票地址
	 */
    private String invoiceAddress;
	/**
	 * 发票电话
	 */
    private String invoicePhone;


	/**
	 * 发票地址Id
	 */
	private String invoiceAddrId;

	/**
	 * 发票地址省编码
	 */
	private String provinceId;

	/**
	 * 发票地址省名称
	 */
	private String provinceName;

	/**
	 * 发票地址地市名称
	 */
	private String cityName;

	/**
	 * 发票地址地市编号
	 */
	private String cityId;

	/**
	 * 发票地址乡镇名称
	 */
	private String townName;

	/**
	 * 发票地址乡镇编号
	 */
	private String townId;

	/**
	 * 发票地址区县名称
	 */
	private String countyName;

	/**
	 * 发票地址区县编号
	 */
	private String countyId;

	/**
	 * 发票地址联系人
	 */
	private String contactName;

	/**
	 * 发票地址联系人电话
	 */
	private String contactPhone;

	/**
	 * 发票地址联系人邮箱
	 */
	private String contactEmial;

	/**
	 * 活动类型:1:工会活动；2：劳防活动
	 */
    private Integer activityType;
	/**
	 * 活动期限:1:有限期，2:无限期
	 */
    private Integer activityCycleType;
	/**
	 * 活动开始时间
	 */
    private Date activityStartTime;
	/**
	 * 活动结束时间
	 */
    private Date activityEndTime;
	/**
	 * 支付方式:1:积分支付；2：混合支付
	 */
    private Integer activityPayMode;
	/**
	 * 活动备注
	 */
    private String remark;
	/**
	 * 删除标志
            0:未删除；1：已删除
	 */
    private Integer delFlag;
	/**
	 * 代币id
	 */
    private Long tokenId;
	/**
	 * 代币数量
	 */
    private BigDecimal tokenNumber;
	/**
	 * 货币金额
	 */
    private BigDecimal convertAmount;
	/**
	 * 货币单位
	 */
    private String convertUnit;
	/**
	 * 商品最高价格
	 */
    private BigDecimal maxPrice;
	/**
	 * 商品最低价格
	 */
    private BigDecimal minPrice;
	/**
	 * 商品关联方式:1:商品池；2：商品类型；3：商品
	 */
    private Integer commodityRelaMethod;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 更新人名称
	 */
    private String updateUserName;
	/**
	 * 更新人ID
	 */
    private Long updateUserId;
	/**
	 * 新活动版本号
	 */
    private Integer newActivityVersion;
	/**
	 * 新活动编号
	 */
    private String newActivityCode;
	/**
	 * 创建人机构ID
	 */
    private Long createOrgId;
	/**
	 * 创建人机构名称
	 */
    private String createOrgName;
	/**
	 * 创建人机构路径
	 */
    private String createOrgTreePath;
	/**
	 * 创建人公司ID
	 */
    private Long createCompanyId;
	/**
	 * 创建人公司名称
	 */
    private String createCompanyName;
    /**
	 * 活动类型翻译:1:工会活动；2：劳防活动
	 */
    private String activityTypeDesc;
    /**
	 * 变更单状态翻译
	 */
    private String changeStateStr;

	/**
	 * 活动场景id
	 */
	private Long activitySceneId;

	/**
	 * 活动场景名称
	 */
	private String activitySceneName;

	/**
	 * 活动PC端banner图url
	 */
	private String  pcBannerPicUrl;

	/**
	 * 活动浮窗图url
	 */
	private String  emergePicUrl;

	/**
	 * 活动app端banner图url
	 */
	private String appBannerPicUrl;
	/**
	 * 支付方式:1:积分支付；2：混合支付
	 */
	private String activityPayModeStr;
	/**
	 * 活动类型:1:工会活动；2：劳防活动
	 */
	private String activityTypeStr;
	/**
	 * 发票接收地址
	 */
	private String addressDesc;
}