package com.tydic.dyc.act.constants;

/**
 * 标题：DycActivityConstants
 * 说明：
 * 时间： 2023-12-12 16:43
 * 作者 @author LY
 */
public class DycActivityConstants {

    /**
     * 是否主客户;1 主客户  0  兼职客户
     */
    public static final class IsMain {

        /**
         * 是
         */
        public static final String YES = "1";

        /**
         * 否
         */
        public static final String NO = "0";
    }

    /**
     * 排序规则
     */
    public static final class Sort {

        /**
         * 发放时间倒序排序
         */
        public static final Integer CREATE_TIME = 1;

        /**
         * 活动结束时间正序
         */
        public static final Integer END_TIME_DESC = 2;

        /**
         * 按生效中，待生效，已失效排序，同一状态按活动结束时间正序排序
         */
        public static final Integer STATE_END_TIME_SORT = 3;
    }


    /**
     * 活动期限
     */
    public static final class ActivityCycleType {
        /**
         * 有限期
         */
        public static final Integer FINITUDE = 1;

        /**
         * 无限期
         */
        public static final Integer UNLIMITED = 2;
    }

    /**
     * 发票类别
     */
    public static final class InvoiceClass {
        /**
         * 1:纸质发票
         */
        public static final String INVOICE_CLASS_ONE = "1";
        /**
         * 1:纸质发票(翻译)
         */
        public static final String INVOICE_CLASS_ONE_STR = "纸质发票";
        /**
         * 2:电子发票
         */
        public static final String INVOICE_CLASS_TWO = "2";
        /**
         * 2:电子发票(翻译)
         */
        public static final String INVOICE_CLASS_TWO_STR = "电子发票";
    }


    /**
     * 发票类型
     */
    public static final class InvoiceType {
        /**
         * 1:专用发票
         */
        public static final String INVOICE_TYPE_ONE = "1";
        /**
         * 1:专用发票(翻译)
         */
        public static final String INVOICE_TYPE_ONE_STR = "专用发票";
        /**
         * 2：普通发票
         */
        public static final String INVOICE_TYPE_TWO = "2";
        /**
         * 2：普通发票(翻译)
         */
        public static final String INVOICE_TYPE_TWO_STR = "普通发票";
    }

    /**
     * 活动类型
     */
    public static final class ActivityType {
        /**
         * 1:工会活动
         */
        public static final String ACTIVITY_TYPE_ONE = "1";
        /**
         * 1:工会活动(翻译)
         */
        public static final String ACTIVITY_TYPE_ONE_STR = "工会";
        /**
         * 2：劳防活动
         */
        public static final String ACTIVITY_TYPE_TWO = "2";
        /**
         * 2：劳防活动(翻译)
         */
        public static final String ACTIVITY_TYPE_TWO_STR = "公司";
    }

    /**
     * 支付方式
     */
    public static final class ActivityPayMode {
        /**
         * 1:积分支付
         */
        public static final String ACTIVITY_PAY_MODE_ONE = "1";
        /**
         * 1:积分支付(翻译)
         */
        public static final String ACTIVITY_PAY_MODE_ONE_STR = "积分支付";
        /**
         * 2：混合支付
         */
        public static final String ACTIVITY_PAY_MODE_TWO = "2";
        /**
         * 2：混合支付(翻译)
         */
        public static final String ACTIVITY_PAY_MODE_TWO_STR = "混合支付（积分优先）";
    }

    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    public static final class ActivityState {
        /**
         * 1:草稿
         */
        public static final String ACTIVITY_STATE_ONE = "1";
        /**
         * 1:草稿(翻译)
         */
        public static final String ACTIVITY_STATE_ONE_STR = "草稿";
        /**
         * 2：待审批
         */
        public static final String ACTIVITY_STATE_TWO = "2";
        /**
         * 2：待审批(翻译)
         */
        public static final String ACTIVITY_STATE_TWO_STR = "审批中";
        /**
         * 3：已驳回
         */
        public static final String ACTIVITY_STATE_THREE = "3";
        /**
         * 3：已驳回(翻译)
         */
        public static final String ACTIVITY_STATE_THREE_STR = "审批驳回";
        /**
         * 4：启用
         */
        public static final String ACTIVITY_STATE_FOUR = "4";
        /**
         * 4：启用(翻译)
         */
        public static final String ACTIVITY_STATE_FOUR_STR = "待生效";
        /**
         * 5：已生效
         */
        public static final String ACTIVITY_STATE_FIVE = "5";
        /**
         * 5：已生效(翻译)
         */
        public static final String ACTIVITY_STATE_FIVE_STR = "生效中";
        /**
         * 6：停用
         */
        public static final String ACTIVITY_STATE_SIX = "6";
        /**
         * 6：停用(翻译)
         */
        public static final String ACTIVITY_STATE_SIX_STR = "已关闭";
        /**
         * 7：已失效
         */
        public static final String ACTIVITY_STATE_SEVEN = "7";
        /**
         * 7：已失效(翻译)
         */
        public static final String ACTIVITY_STATE_SEVEN_STR = "已失效";
        /**
         * 8：变更中
         */
        public static final String ACTIVITY_STATE_EIGHT = "8";
        /**
         * 8：变更中(翻译)
         */
        public static final String ACTIVITY_STATE_EIGHT_STR = "变更中";
    }

    /**
     * 业务对象类型
     */
    public static final class BusinessObject {
        /**
         * 1:活动
         */
        public static final String BUSINESS_OBJECT_MODE_ONE = "1";
        /**
         * 1:活动(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_ONE_STR = "活动";
        /**
         * 2：活动变更单
         */
        public static final String BUSINESS_OBJECT_MODE_TWO = "2";
        /**
         * 2：活动变更单(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_TWO_STR = "活动变更单";
        /**
         * 3：审批单
         */
        public static final String BUSINESS_OBJECT_MODE_THREE = "3";
        /**
         * 3：审批单(翻译)
         */
        public static final String BUSINESS_OBJECT_MODE_THREE_STR = "审批单";
    }

    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    public static final class CommodityRelaMethod {
        public static final String COMMODITY_TYPE_ONE = "1";
        public static final String COMMODITY_TYPE_ONE_STR = "商品池";
        public static final String COMMODITY_TYPE_TWO = "2";
        public static final String COMMODITY_TYPE_TWO_STR = "按类目设置";
        public static final String COMMODITY_TYPE_THREE = "3";
        public static final String COMMODITY_TYPE_THREE_STR = "按商品设置";
    }

    /**
     * 变更单状态:0：草稿；1:待审批；2：审批通过；3：已驳回
     */
    public static final class ChangeState {
        /**
         * 0:草稿
         */
        public static final String CHANGE_STATE_ZERO = "0";
        /**
         * 0:草稿(翻译)
         */
        public static final String CHANGE_STATE_ZERO_STR = "草稿";
        /**
         * 1:待审批
         */
        public static final String CHANGE_STATE_ONE = "1";
        /**
         * 1:待审批(翻译)
         */
        public static final String CHANGE_STATE_ONE_STR = "待审批";
        /**
         * 2：审批通过
         */
        public static final String CHANGE_STATE_TWO = "2";
        /**
         * 2：审批通过(翻译)
         */
        public static final String CHANGE_STATE_TWO_STR = "审批通过";
        /**
         * 3：已驳回
         */
        public static final String CHANGE_STATE_THREE = "3";
        /**
         * 3：已驳回(翻译)
         */
        public static final String CHANGE_STATE_THREE_STR = "已驳回";
    }


    /**
     * 使用类型： 1：发放，2：消费:3：退回，4：失效:
     */
    public static final class UseType {
        /**
         * 1:发放
         */
        public static final String USE_TYPE_ONE = "1";
        /**
         * 1:发放(翻译)
         */
        public static final String USE_TYPE_ONE_STR = "发放";
        /**
         * 2：消费
         */
        public static final String USE_TYPE_TWO = "2";
        /**
         * 2：消费(翻译)
         */
        public static final String USE_TYPE_TWO_STR = "消费";
        /**
         * 3：退回
         */
        public static final String USE_TYPE_THREE = "3";
        /**
         * 3：退回(翻译)
         */
        public static final String USE_TYPE_THREE_STR = "退回";
        /**
         * 4：失效
         */
        public static final String USE_TYPE_FOUR = "4";
        /**
         * 4：失效(翻译)
         */
        public static final String USE_TYPE_FOUR_STR = "失效";
    }

    public static final class OBJ_TYPE {
        //活动审批
        public static final String ACT_AUDIT = "1";
        //活动变更审批
        public static final String ACT_AUDIT_CHANGE = "2";

        /**
         * 订单
         */
        public static final Integer ORDER = 1;

        /**
         * 售后单
         */
        public static final Integer AFTER = 2;

        /**
         * 结算单
         */
        public static final Integer FSC_ORDER = 3;

        /**
         * 活动
         */
        public static final Integer ACTIVITY = 4;
    }

    public static final class TAB_ID {
        //待生效
        public static final String TAB_ID_1 = "1001";
        //生效中
        public static final String TAB_ID_2 = "1002";
        //已失效
        public static final String TAB_ID_3 = "1003";
        //全部
        public static final String TAB_ID_4 = "1004";
    }

    public static final class ACT_STATE {
        //待生效对应的状态
        public static final String TAB_ID_1_STATE = "1,2,3,4,6,8";
        //生效中对应的状态
        public static final String TAB_ID_2_STATE = "5";
        //已失效对应的状态
        public static final String TAB_ID_3_STATE = "7";
        //全部对应的状态
        public static final String TAB_ID_4_STATE = "1,2,3,4,5,6,7,8";
    }


    public static final class Settle_Flag {
        //未结算
        public static final String Settle_Flag_ZERO = "0";
        //已结算
        public static final String Settle_Flag_ONE = "1";
    }

    public static final class FILE_TYPE {
        //对账单附件类型
        public static final String FILE_TYPE_BILL = "1";
        //结算单发票附件类型
        public static final String FILE_TYPE_INVOICE = "2";
    }

    public static final class FSC_ORDER_STATE {
        //已提交
        public static final Integer COMMITED = 1014;
        //开票中
        public static final Integer INVOICING = 1017;
        //已开票
        public static final Integer INVOICED = 1002;
        //已收票
        public static final Integer SIGNED = 1003;
        //开票中
        public static final Integer PAYED = 1008;
        //已驳回
        public static final Integer REJECT = 1010;
        //已取消
        public static final Integer CANCELED = 1099;
    }

    /**
     * 发票核对是否匹配
     * 1 是
     * 0 否
     */
    public static final class FscInvoiceVerifyResult {
        /**
         * 发票核对是否匹配 1 是
         */
        public static final Integer YES = 1;
        /**
         * 发票核对是否匹配 0 否
         */
        public static final Integer NO = 0;
    }

    /**
     * 发票明细标识
     * 1 已获取
     * 0 未获取
     */
    public static final class FscInvoiceItemFlag {
        /**
         * 1 以获取
         */
        public static final Integer YES = 1;
        /**
         * 0 未获取
         */
        public static final Integer NO = 0;
    }

    /**
     * 开票方
     * 1 电商
     */
    public static final class MakeType {
        /**
         * 1 电商开票
         */
        public static final Integer ECOM = 1;
    }

    /**
     * 收票方
     * 1 电商
     */
    public static final class ReceiveType {
        /**
         * 1 采购
         */
        public static final Integer PUR = 1;
        /**
         * 2 运营
         */
        public static final Integer OPERATION = 2;
    }

    /**
     * 商品类目等级
     */
    public static final class CatalogLevel {

        public static final Integer ONE = 1;

        public static final Integer TWO = 2;

        public static final Integer THREE = 3;
    }

    /**
     * 商品类目状态
     */
    public static final class CatalogStatus {

        /**
         * 启用
         */
        public static final Integer ENABLE = 1;

        /**
         * 停用
         */
        public static final Integer DISABLE = 0;


    }


    /**
     * 单品状态
     * 1 已上架
     * 2 已下架
     * 0 已删除
     */
    public static final class SkuStatue {
        /**
         * 1 已上架
         */
        public static final Integer ON_SALE = 1;
        /**
         * 2 已下架
         */
        public static final Integer WITHDRAWN = 2;
        /**
         * 0 已删除
         */
        public static final Integer DELETE = 0;
        /**
         * 1 已上架
         */
        public static final String ON_SALE_STR = "已上架";
        /**
         * 2 已下架
         */
        public static final String WITHDRAWN_STR = "已下架";
        /**
         * 0 已删除
         */
        public static final String DELETE_STR = "已删除";
    }

    /**
     * 电商推送结果
     */
    public static final class PushResult {

        public static final Integer UN_PUSH = 0;

        public static final Integer PUSH_SUCCESS = 1;

        public static final Integer PUSH_FAIL = 2;
    }

    /**
     * PCode
     */
    public static final class PCode {

        /**
         * 活动类型
         */
        public static final String ACTIVITY_TYPE = "ACTIVITY_TYPE";

        /**
         * 变更单状态
         */
        public static final String CHANGE_STATE = "CHANGE_STATE";

        /**
         * 活动状态
         */
        public static final String ACTIVITY_STATE = "ACTIVITY_STATE";

        /**
         * 用户积分Tab
         */
        public static final String ACT_USER_SCORE_TAB = "ACT_USER_SCORE_TAB";
    }

    /**
     * 用户积分Tab
     */
    public static final class ActUserScoreTab {

        /**
         * 全部
         */
        public static final Integer ALL = 1001;

        /**
         * 进行中
         */
        public static final Integer IN_HAND = 1002;

        /**
         * 未开始
         */
        public static final Integer DNS = 1003;

        /**
         * 已结束
         */
        public static final Integer OVER = 1004;

        /**
         * 默认
         */
        public static final Integer DEFAULT = 0;


    }

    /**
     * 图片类型
     */
    public static final class PicType {

        /**
         * 主图
         */
        public static final Integer CZG = 1;

        /**
         * 细节图
         */
        public static final Integer DETAIL = 0;
    }


    /**
     * 待办 单据类型(1、待审批福利活动)
     */
    public static final class TodoType {

        //活动审批
        public static final Integer ACT_AUDIT = 1;
        //活动变更审批
        public static final Integer ACT_AUDIT_CHANGE = 2;


    }

    /**
     * 商品池关联类型
     */
    public static final class PoolType {
        /**
         * 供应商
         */
        public static final Integer SUPPLIER = 1;
        /**
         * 供应商
         */
        public static final String SUPPLIERSTR = "供应商";
        /**
         * 商品
         */
        public static final Integer COMMODITY = 2;
        public static final String COMMODITYSTR = "商品";
        /**
         * 类目
         */
        public static final Integer CATALOG = 3;

        public static final String CATALOGSTR = "商品类目";
    }

    /**
     * 关联商品池操作类型
     */
    public static final class RelPoolOperType {
        /**
         * 关联
         */
        public static final Integer REL = 1;
        /**
         * 取消关联
         */
        public static final Integer CANCEL_REL = 2;
    }

    /**
     * 预警类型
     */
    public static final class AlertType {

        /**
         * 无预警
         */
        public static final Integer UN = 0;
        /**
         * 1超期未发货
         */
        public static final Integer UN_SEND = 1;
        /**
         * 超期未收货
         */
        public static final Integer UN_RECEIVCE = 2;
        /**
         * 超期未响应
         */
        public static final Integer UN_RESPONSE = 3;
        /**
         * 超期未签收
         */
        public static final Integer UN_SIGN = 4;
        /**
         * 超期未付款
         */
        public static final Integer UN_PAY = 5;

        /**
         * 最后付款日期
         */
        public static final Integer LAST_PAY = 6;
    }


    /**
     * 活动同步状态:
     * 1:待同步
     * 2：同步中
     * 3：同步成功
     * 4：同步失败
     */
    public static final class ActivitySyncState {
        /**
         * 1:待同步
         */
        public static final Integer WAIT = 1;
        /**
         * 2：同步中
         */
        public static final Integer ING = 2;
        /**
         * 3：同步成功
         */
        public static final Integer SUCCESS = 3;
        /**
         * 4：同步失败
         */
        public static final Integer FAIL = 4;
    }

    /**
     * 预警状态
     */
    public static final class AlertState {
        /**
         * 未处理
         */
        public static final Integer UN_DEAL = 0;
        /**
         * 已处理
         */
        public static final Integer DEALED = 1;
        /**
         * 待处理
         */
        public static final Integer DEALING = 2;
    }

    /**
     * 自动任务类型
     */
    public static final class AutoType {

        /**
         * 无自动任务
         */
        public static final Integer NO = 0;

        /**
         * 自动生效
         */
        public static final Integer COME_INTO = 1;

        /**
         * 自动失效
         */
        public static final Integer LOSE = 2;


    }

    /**
     * 履约风控员工福利监控统查询类型1:本周 2:本月 3:本年 4:指定日期）
     */
    public static final class RiskControlQryType {
        /**
         * 本周
         */
        public static final Integer WEEK = 1;
        /**
         * 本月
         */
        public static final Integer MONTH = 2;
        /**
         * 本年
         */
        public static final Integer YEAR = 3;
        /**
         * 指定日期
         */
        public static final Integer SPECIFY_DATE = 4;
    }

    /**
     * 履约风控员工福利监控统查询范围（1:按单位查询 2:全量查询）
     */
    public static final class RiskQryRadius {
        /**
         * 按单位查询
         */
        public static final Integer COMPANY = 1;
        /**
         * 全量查询
         */
        public static final Integer ALL = 2;
    }

    /**
     * 价格是否异常：0异常1正常
     */
    public static final class IsAnomalousPrice {
        /**
         * 正常
         */
        public static final Integer NORMAL = 1;
        /**
         * 正常翻译
         */
        public static final String NORMAL_STR = "核验通过";
        /**
         * 异常
         */
        public static final Integer ABNORMAL = 0;
        /**
         * 异常翻译
         */
        public static final String ABNORMAL_STR = "价格异常";
    }
}
