package com.tydic.dyc.act.utils;

import java.text.SimpleDateFormat;
import java.time.*;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 标题：DateUtil
 * 说明：时间工具
 * 时间：2024/5/07 18:58
 *
 * @author zhoujie
 */
public class DateUtil {
    //获取当本月开始时间 ，即2021-01-31 00:00:00
    private final static SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private final static SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");
    private final static SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 传入时间的月初
     */
    public static Date getMonthStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            c.set(Calendar.DATE, 1);
            now = shortSdf.parse(longSdf.format(c.getTime()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    /**
     * 传入时间的月的结束时间，即2021-01-31 23:59:59
     *
     * @return
     */
    public static Date getMonthEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            c.set(Calendar.DATE, 1);
            c.add(Calendar.MONTH, 1);
            c.add(Calendar.DATE, -1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    //获取当本季度开始时间    即2021-01-01 00:00:00
    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(Calendar.MONTH, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(Calendar.MONTH, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(Calendar.MONTH, 6);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(Calendar.MONTH, 9);
            }
            c.set(Calendar.DATE, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    // 当前季度的结束时间，即2021-03-31 23:59:59
    public static Date getCurrentQuarterEndTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(Calendar.MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(Calendar.MONTH, 2);
                c.set(Calendar.DATE, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(Calendar.MONTH, 5);
                c.set(Calendar.DATE, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(Calendar.MONTH, 8);
                c.set(Calendar.DATE, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(Calendar.MONTH, 11);
                c.set(Calendar.DATE, 31);
            }
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }


    /**
     * 获取传入时间的年开始时间   即2021-01-01 00:00:00
     *
     * @return
     */
    public static Date getYearStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            c.set(Calendar.MONTH, 0);
            c.set(Calendar.DATE, 1);
            now = shortSdf.parse(shortSdf.format(c.getTime()));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    /**
     * 传入时间的年的结束时间，即2021-12-31 23:59:59
     *
     * @return
     */
    public static Date getYearEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            c.set(Calendar.MONTH, 11);
            c.set(Calendar.DATE, 31);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }


    /**
     * 返回传入时间的开始时间 00:00:00
     *
     * @return Date
     */
    public static Date getCurrentDateStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    /**
     * 获取传入时间周的开始时间
     *
     * @param date
     * @return
     */
    public static Date getWeekStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        // 设置一周的第一天为周一（Calendar默认可能是周日，这取决于地区和JVM）
        c.setFirstDayOfWeek(Calendar.MONDAY);
        // 找到本周的第一天（即周一）
        int dayOfWeek = c.get(Calendar.DAY_OF_WEEK);
        c.add(Calendar.DAY_OF_WEEK, -(dayOfWeek - Calendar.MONDAY));
        Date now = null;
        try {
            now = shortSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }


    /**
     * 获取传入时间周的结束时间
     *
     * @param date
     * @return
     */
    public static Date getWeekEndTime(Date date) {
        Date weekStartTime = getWeekStartTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(weekStartTime);
        // 将日历设置为下周的周一
        calendar.add(Calendar.WEEK_OF_YEAR, 1);

        // 然后减去一天，得到本周的周日
        calendar.add(Calendar.DAY_OF_WEEK, -1);
        Date now = null;
        try {
            now = longSdf.parse(shortSdf.format(calendar.getTime()) + " 23:59:59");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    /**
     * 获取传入时间前一周的时间
     *
     * @param date
     * @return
     */
    public static Date getLastWeekTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        // 减去一周的时间，Calendar.WEEK_OF_YEAR表示一周，-1表示向前一周
        calendar.add(Calendar.WEEK_OF_YEAR, -1);
        return calendar.getTime();
    }

    /**
     * 获取传入时间前一个月的时间
     *
     * @param date
     * @return
     */
    public static Date getLastMonthTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        // 减去一个月的时间，Calendar.MONTH表示月份，-1表示向前一个月
        calendar.add(Calendar.MONTH, -1);
        return calendar.getTime();
    }

    /**
     * 获取传入时间前一个年的时间
     *
     * @param date
     * @return
     */
    public static Date getLastYearTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        // 减去一个月的时间，Calendar.MONTH表示月份，-1表示向前一个月
        calendar.add(Calendar.YEAR, -1);
        return calendar.getTime();
    }

}
