package com.tydic.dyc.act.service.bo;

import com.tydic.dyc.base.bo.DycCenterPageReqBaseBO;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class DycActQueryActivityCommodityPageListReqBO extends DycCenterPageReqBaseBO implements Serializable {
    private static final long serialVersionUID = 57226460620528017L;

    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 一级类目id
     */
    private String firstCatalogId;
    /**
     * 二级类目id
     */
    private String secondCatalogId;
    /**
     * 三级类目id
     */
    private String threeCatalogId;
    /**
     * 商品类型ID
     */
    private Long commodityTypeId;
    /**
     * 商品类型名称
     */
    private String commodityTypeName;
    /**
     * 商品池名称，多个商品池用逗号分隔
     */
    private String commodityPoolName;
    /**
     * 单品ID
     */
    private Long skuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 品牌
     */
    private String brand;
    /**
     * 最小价格
     */
    private BigDecimal minPrice;
    /**
     * 最大价格
     */
    private BigDecimal maxPrice;
    /**
     * 好评率排序：ASC：升序，DESC：降序。默认为降序
     */
    private String favorableRateOrder = "DESC";

    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Integer commodityRelaMethod;
    /**
     * 等于1 就走另一种查询
     */
    private Integer quoteActivity;
    /**
     * 同步状态：
     * 0：同步失败
     * 1：同步成功
     */
    private Integer syncState;
    /**
     * 价格是否异常：0异常1正常
     */
    private Integer isAnomalousPrice;
}
