package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycActSubmitActivityChangeReqBO
 * 说明：活动变更提交API入参
 * 时间： 2023-12-27 16:00
 * 作者 @author LY
 */
@Data
public class DycActSubmitActivityChangeReqBO implements Serializable {
    private static final long serialVersionUID = 2443806475205293715L;
    /**
     * 变更单ID
     */
    private Long changeId;
    /**
     * 变更原因
     */
    private String changeReason;
    /**
     * 变更附件列表
     */
    private List<DycActActivityChangeFileInfoBO> changeFileList;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动说明
     */
    private String remark;
    /**
     * PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * app端banner图url
     */
    private String appBannerPicUrl;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 商品最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 商品最低价格
     */
    private BigDecimal minPrice;
    /**
     * 当前操作人Id
     */
    private Long userId;
    /**
     * 当前操作人名称
     */
    private String name;
    /**
     * 当前操作人机构名称
     */
    private String orgName;
    /**
     * 当前操作人机构id
     */
    private Long orgId;
    /**
     * 当前操作人机构书路径（自动注入）
     */
    private String orgPath;
    /**
     * 当前操作人公司id（自动注入）
     */
    private Long companyId;
    /**
     * 当前操作人公司名称（自动注入）
     */
    private String companyName;
    /**
     * 同款最低价：0：否；1：是
     */
    private Integer lowPrice;
}
