package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：DycActBatchSelectActivityCommodityCatalogReqBO
 * 说明：活动商品类型选择（批量）服务BO
 * 时间： 2023-12-15 10:16
 * 作者 @author LY
 */
@Data
public class DycActBatchSelectActivityCommodityCatalogReqBO implements Serializable {

    private static final long serialVersionUID = -1417624582975390814L;
    /**
     * 商品类型列表
     */
    private List<DycActActivityCommodityCatalogInfoBO> commodityCatalogInfoBOS;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 创建人ID
     */
    private Long userId;
    /**
     * 创建人名称
     */
    private String name;
    /**
     * 协议价最小值
     */
    private BigDecimal agreementPriceMin;
    /**
     * 协议价最大值
     */
    private BigDecimal agreementPriceMax;
    /**
     * 同款同类目下最低价：0没勾选1勾选
     */
    private Integer lowPrice;
    /**
     * 价格是否异常：0异常1正常
     */
    private Integer isAnomalousPrice;
}
