package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题：AgrAlertInfoBO
 * 说明：预警信息表
 * 时间：2024/8/6 10:26
 *
 * @author 周钰焱
 */
@Data
public class AgrAlertInfoBO implements Serializable {

    private static final long serialVersionUID = -3003956728937356067L;
    /**
     * 主键ID
     */
    private Long id;
    /**
     * 单据ID
     */
    private String objId;
    /**
     * 类型：1订单、2服务单、3结算单、4活动
     */
    private Integer objType;
    /**
     * 预警类型：1超期未发货、2超期未收货、3超期未响应、4超期未签收、5超期未付款、6付款预警(活动)
     */
    private Integer alertType;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 预警状态：0未处理，1已处理，2待处理(中间状态)
     */
    private Integer alertState;
    /**
     * 更新时间
     */
    private Date updateTime;
    private Date updateTimeStart;
    private Date updateTimeEnd;
    /**
     * 单据创建人
     */
    private Long createUserId;
    /**
     * 单据创建人名称
     */
    private String createUserName;
    /**
     * 单据创建人机构ID
     */
    private Long createOrgId;
    /**
     * 单据创建人机构名称
     */
    private String createOrgName;
    /**
     * 单据创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 单据创建人公司名称
     */
    private String createCompanyName;
    /**
     * 单据创建人机构树
     */
    private String createOrgPath;
    /**
     * 是否发送：0 否 1是
     */
    private Integer isSend;
    /**
     * 排序
     */
    private String orderBy;
    /**
     * 单据ID集合
     */
    private List<String> objIds;
    /**
     * ID集合
     */
    private List<Long> ids;

    private AgrAlertInfoBO setDate;
    private AgrAlertInfoBO whereDate;
}
