package com.tydic.dyc.agr.service.agr.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题：AgrGetAgrItemListByOrgIdReqBo
 * 说明：查询采购单位适用协议明细列表入参
 * 时间：2024/7/24 14:56
 *
 * @author 周钰焱
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AgrGetAgrItemListByOrgIdReqBo extends BaseReqBo {
    private static final long serialVersionUID = -9090124644314763585L;

    /**
     * 采购单位id
     */
    private Long purOrgId;
    /**
     * 物料编码集合
     */
    private List<String> materialCodeList;
    /**
     * 当前页
     */
    private Integer pageNo;
    /**
     * 每页数量
     */
    private Integer pageSize;
    /**
     * 排序
     */
    private String orderBy;
    /**
     * 传入采购单位机构树
     */
    private String purOrgPath;
    /**
     * 协议明细ID集合
     */
    private List<Long> agrItemIds;
}
