package com.tydic.dyc.agr.components.es;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

/**
 * 标题:UocEsSyncBeanPostProcessor
 * 说明:IUocEsSync后置处理器
 * 时间:2022/3/1 12:40
 * 作者:田桂银
 */
@Component
public class AgrBeanPostProcessor implements BeanPostProcessor {

    @Autowired
    private AgrEsSyncManager manager;

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IAgrEsSync) {
            manager.register((IAgrEsSync) bean);
        }
        return bean;
    }

}


