package com.tydic.dyc.agr.model.agr;

import com.tydic.dyc.agr.model.agr.qrybo.*;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemPriceExecutionBo;
import com.tydic.dyc.agr.service.agr.bo.AgrQueryAlertStatisticsReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQueryAlertStatisticsRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;

import java.util.List;

/**
 * 描述： 
 * 
 * @author auto_gen
 * @date 2023-07-28 16:53
 **/
public interface IAgrAgrModel {
	/**
	 * 协议新增方法
	 */
	 void createAgr(AgrAgrDo agrAgrDo);
	/**
	 * 协议修改方法
	 */
	 void updateAgr(AgrAgrDo agrAgrDo);
	/**
	 * 协议主体查询方法
	 */
	 AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo);
	/**
	 * 协议删除方法
	 */
	 void deleteAgr(AgrAgrDo agrAgrDo);
	/**
	 * 协议详情查询
	 */
	 AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo);
	/**
	 * 协议明细列表查询
	 */
	 AgrItemListQryRspPageBo getAgrItemList(AgrItemListQryReqPageBo agrItemListQryReqPageBo);
	/**
	 * 协议明细新增
	 */
	 void saveAgrItem(AgrAgrDo agrAgrDo);
	/**
	 * 协议明细修改
	 */
	 void updateAgrItem(AgrAgrDo agrAgrDo);
	/**
	 * 协议明细删除
	 */
	 void deleteAgrItemByBatch(AgrAgrDo agrAgrDo);
	/**
	 * 协议明细批量修改
	 */
	 void updateAgrItemByBatch(AgrAgrDo agrAgrDo);
	/**
	 * 协议主体修改方法
	 */
	 void updateAgrMain(AgrAgrDo agrAgrDo);
	/**
	 * 数据同步查询协议列表
	 */
	AgrListQryRspPageBo getAllAgrList(AgrListQryReqPageBo agrListQryReqPageBo);
	/**
	 * 协议分配记录新增方法
	 */
	 void saveAgrAllocateRecord(AgrAgrDo agrAgrDo);
	/**
	 * 协议分配记录列表查询方法
	 */
	 AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo);
	/**
	 * 协议主体列表查询方法
	 */
	 AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo);
	/**
	 * 协议明细数量统计方法
	 */
	 AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCount(AgrGetAgrItemCountByCommodityTypeReqPageBo agrGetAgrItemCountByCommodityTypeReqPageBo);
	/**
	 * 协议版本记录新增方法
	 */
	 void saveAgrVersion(AgrAgrDo agrAgrDo);

	 void disValidAgrVersion(AgrAgrDo agrAgrDo);
	/**
	 * 协议版本列表查询方法
	 */
	 AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo);
	/**
	 * 协议日志新增方法
	 */
	 void saveAgrHis(AgrAgrDo agrAgrDo);
	/**
	 * AGRF0034-协议保存明细校验
	 */
	 void checkAgrItemSave(AgrAgrDo agrAgrDo);
	/**
	 * AGRF0035-协议明细指定字段修改
	 */
	 void updateAgrItemSpecifyField(AgrAgrDo agrAgrDo);
	/**
	 * AGRF0048-协议版本记录删除方法
	 */
	 void deleteAgrVersionRecord(AgrAgrDo agrAgrDo);
	/**
	 * AGRF0070-协议失效方法
	 */
	 AgrGetAgrMainListRspQryBo dealAgrInvalid(AgrAgrDo agrAgrDo);
	/**
	 * AGRF0071-协议变更同步方法
	 */
	 void dealChangeSyn(AgrAgrDo agrAgrDo);
	 /**
	  * 描述：根据协议id集合查询协议应用范围
	  */
	 List<AgrAppScope> getAgrAppScopeList(AgrAgrQryBo agrAgrQryBo);
	/**
	 * 协议主题变更修改方法
	 */
	void updateAgrChngMain(AgrAgrDo agrAgrDo);
	/**
	 * 协议明细列表查询
	 */
	AgrItemListQryRspPageBo qryAgrItemList(AgrItemListQryReqPageBo agrItemListQryReqPageBo);
	/**
	 * 新增协议明细价格执行
	 */
	void createAgrItemPriceExecution(List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList);
	/**
	 * 修改协议明细价格执行
	 */
	void updateAgrItemPriceExecution(List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList);
	/**
	 * 协议明细价格执行列表查询
	 */
	AgrItemListPriceExecutionQryRspPageBo getAgrItemPriceExecutionList(AgrItemListPriceExecutionQryReqPageBo agrItemListQryReqPageBo);
	/**
	 * 新增协议主体扩展
	 */
	void createAgrMainExt(AgrAgrDo agrAgrDo);
	/**
	 * 删除协议主体扩展
	 */
	void deleteAgrMainExt(AgrAgrDo agrAgrDo);
	/**
	 * 批量新增协议附件
	 * @param agrAgrDo
	 */
	void insertBatchAgrAccessory(AgrAgrDo agrAgrDo);
	/**
	 * 返回协议及协议明细允许商品解冻的协议信息
	 * @param agrSyncUccReqBO
	 */
	List<AgrItem>  checkAgrItemUnfreeze(AgrSyncUccReqBO agrSyncUccReqBO);

	/**
	 * 新增协议预警信息
	 * @param agrAlertInfoBOList
	 */
	void createAgrAlertInfo(List<AgrAlertInfoBO> agrAlertInfoBOList);

	/**
	 * 查寻协议预警集合
	 * @param qryAgrBo
	 */
	List<AgrAlertInfoBO> qryAgrAlertInfoList(AgrAlertInfoBO qryAgrBo);
	/**
	 * 修改协议预警信息
	 * @param agrAlertInfoBOList
	 */
	void updateAgrAlertInfo(List<AgrAlertInfoBO> agrAlertInfoBOList);

	void updateAgrAlertStatus(List<AgrAlertInfoBO> agrAlertInfoBOList);

	void updateAgrAlertIsSend(AgrAlertInfoBO reqSetBo,AgrAlertInfoBO reqWhereBo);

	AgrAgrDo getAgrExtList(AgrAgrQryBo agrAgrQryBo);

    AgrQueryAlertStatisticsRspBO queryAlertStatistics(AgrQueryAlertStatisticsReqBO reqBO);
}
