package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrAccessory;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAccessoryInsertBatchReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAccessoryInsertBatchRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.Data;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题：AgrAgrAccessoryInsertBatchServiceImpl
 * 说明：协议附件批量新增服务
 * 时间：2024/7/25 15:41
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class AgrAgrAccessoryInsertBatchServiceImpl implements AgrAgrAccessoryInsertBatchService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrAgrAccessoryInsertBatchRspBo agrAgrAccessoryInsertBatch(AgrAgrAccessoryInsertBatchReqBo reqBo) {
        varReq(reqBo);
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(reqBo.getAgrId());
        agrAgrDo.setAgrAccessory(JSON.parseArray(JSON.toJSONString(reqBo.getAgrAccessoryBOs()), AgrAccessory.class));
        this.iAgrAgrModel.insertBatchAgrAccessory(agrAgrDo);
        return AgrRu.success(AgrAgrAccessoryInsertBatchRspBo.class);
    }

    /**
     * 校验入参
     * @param reqBo
     */
    private void varReq(AgrAgrAccessoryInsertBatchReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参不能为空");
        }
        if (null == reqBo.getAgrId()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议id]不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getAgrAccessoryBOs())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[附件信息]不能为空");
        }
    }
}
